/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ContainerEntrypointCopier;
import software.amazon.awssdk.services.sagemaker.model.MonitoringContainerArgumentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringAppSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringAppSpecification> {
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUri").getter(MonitoringAppSpecification.getter(MonitoringAppSpecification::imageUri)).setter(MonitoringAppSpecification.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()}).build();
    private static final SdkField<List<String>> CONTAINER_ENTRYPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerEntrypoint").getter(MonitoringAppSpecification.getter(MonitoringAppSpecification::containerEntrypoint)).setter(MonitoringAppSpecification.setter(Builder::containerEntrypoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerEntrypoint").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONTAINER_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerArguments").getter(MonitoringAppSpecification.getter(MonitoringAppSpecification::containerArguments)).setter(MonitoringAppSpecification.setter(Builder::containerArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECORD_PREPROCESSOR_SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordPreprocessorSourceUri").getter(MonitoringAppSpecification.getter(MonitoringAppSpecification::recordPreprocessorSourceUri)).setter(MonitoringAppSpecification.setter(Builder::recordPreprocessorSourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordPreprocessorSourceUri").build()}).build();
    private static final SdkField<String> POST_ANALYTICS_PROCESSOR_SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostAnalyticsProcessorSourceUri").getter(MonitoringAppSpecification.getter(MonitoringAppSpecification::postAnalyticsProcessorSourceUri)).setter(MonitoringAppSpecification.setter(Builder::postAnalyticsProcessorSourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAnalyticsProcessorSourceUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_URI_FIELD, CONTAINER_ENTRYPOINT_FIELD, CONTAINER_ARGUMENTS_FIELD, RECORD_PREPROCESSOR_SOURCE_URI_FIELD, POST_ANALYTICS_PROCESSOR_SOURCE_URI_FIELD));
    private static final long serialVersionUID = 1L;
    private final String imageUri;
    private final List<String> containerEntrypoint;
    private final List<String> containerArguments;
    private final String recordPreprocessorSourceUri;
    private final String postAnalyticsProcessorSourceUri;

    private MonitoringAppSpecification(BuilderImpl builder) {
        this.imageUri = builder.imageUri;
        this.containerEntrypoint = builder.containerEntrypoint;
        this.containerArguments = builder.containerArguments;
        this.recordPreprocessorSourceUri = builder.recordPreprocessorSourceUri;
        this.postAnalyticsProcessorSourceUri = builder.postAnalyticsProcessorSourceUri;
    }

    public final String imageUri() {
        return this.imageUri;
    }

    public final boolean hasContainerEntrypoint() {
        return this.containerEntrypoint != null && !(this.containerEntrypoint instanceof SdkAutoConstructList);
    }

    public final List<String> containerEntrypoint() {
        return this.containerEntrypoint;
    }

    public final boolean hasContainerArguments() {
        return this.containerArguments != null && !(this.containerArguments instanceof SdkAutoConstructList);
    }

    public final List<String> containerArguments() {
        return this.containerArguments;
    }

    public final String recordPreprocessorSourceUri() {
        return this.recordPreprocessorSourceUri;
    }

    public final String postAnalyticsProcessorSourceUri() {
        return this.postAnalyticsProcessorSourceUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerEntrypoint() ? this.containerEntrypoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerArguments() ? this.containerArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recordPreprocessorSourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.postAnalyticsProcessorSourceUri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringAppSpecification)) {
            return false;
        }
        MonitoringAppSpecification other = (MonitoringAppSpecification)obj;
        return Objects.equals(this.imageUri(), other.imageUri()) && this.hasContainerEntrypoint() == other.hasContainerEntrypoint() && Objects.equals(this.containerEntrypoint(), other.containerEntrypoint()) && this.hasContainerArguments() == other.hasContainerArguments() && Objects.equals(this.containerArguments(), other.containerArguments()) && Objects.equals(this.recordPreprocessorSourceUri(), other.recordPreprocessorSourceUri()) && Objects.equals(this.postAnalyticsProcessorSourceUri(), other.postAnalyticsProcessorSourceUri());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringAppSpecification").add("ImageUri", (Object)this.imageUri()).add("ContainerEntrypoint", this.hasContainerEntrypoint() ? this.containerEntrypoint() : null).add("ContainerArguments", this.hasContainerArguments() ? this.containerArguments() : null).add("RecordPreprocessorSourceUri", (Object)this.recordPreprocessorSourceUri()).add("PostAnalyticsProcessorSourceUri", (Object)this.postAnalyticsProcessorSourceUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
            case "ContainerEntrypoint": {
                return Optional.ofNullable(clazz.cast(this.containerEntrypoint()));
            }
            case "ContainerArguments": {
                return Optional.ofNullable(clazz.cast(this.containerArguments()));
            }
            case "RecordPreprocessorSourceUri": {
                return Optional.ofNullable(clazz.cast(this.recordPreprocessorSourceUri()));
            }
            case "PostAnalyticsProcessorSourceUri": {
                return Optional.ofNullable(clazz.cast(this.postAnalyticsProcessorSourceUri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringAppSpecification, T> g) {
        return obj -> g.apply((MonitoringAppSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageUri;
        private List<String> containerEntrypoint = DefaultSdkAutoConstructList.getInstance();
        private List<String> containerArguments = DefaultSdkAutoConstructList.getInstance();
        private String recordPreprocessorSourceUri;
        private String postAnalyticsProcessorSourceUri;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringAppSpecification model) {
            this.imageUri(model.imageUri);
            this.containerEntrypoint(model.containerEntrypoint);
            this.containerArguments(model.containerArguments);
            this.recordPreprocessorSourceUri(model.recordPreprocessorSourceUri);
            this.postAnalyticsProcessorSourceUri(model.postAnalyticsProcessorSourceUri);
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        public final Collection<String> getContainerEntrypoint() {
            if (this.containerEntrypoint instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerEntrypoint;
        }

        @Override
        public final Builder containerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = ContainerEntrypointCopier.copy(containerEntrypoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerEntrypoint(String ... containerEntrypoint) {
            this.containerEntrypoint(Arrays.asList(containerEntrypoint));
            return this;
        }

        public final void setContainerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = ContainerEntrypointCopier.copy(containerEntrypoint);
        }

        public final Collection<String> getContainerArguments() {
            if (this.containerArguments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerArguments;
        }

        @Override
        public final Builder containerArguments(Collection<String> containerArguments) {
            this.containerArguments = MonitoringContainerArgumentsCopier.copy(containerArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerArguments(String ... containerArguments) {
            this.containerArguments(Arrays.asList(containerArguments));
            return this;
        }

        public final void setContainerArguments(Collection<String> containerArguments) {
            this.containerArguments = MonitoringContainerArgumentsCopier.copy(containerArguments);
        }

        public final String getRecordPreprocessorSourceUri() {
            return this.recordPreprocessorSourceUri;
        }

        @Override
        public final Builder recordPreprocessorSourceUri(String recordPreprocessorSourceUri) {
            this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
            return this;
        }

        public final void setRecordPreprocessorSourceUri(String recordPreprocessorSourceUri) {
            this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
        }

        public final String getPostAnalyticsProcessorSourceUri() {
            return this.postAnalyticsProcessorSourceUri;
        }

        @Override
        public final Builder postAnalyticsProcessorSourceUri(String postAnalyticsProcessorSourceUri) {
            this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
            return this;
        }

        public final void setPostAnalyticsProcessorSourceUri(String postAnalyticsProcessorSourceUri) {
            this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
        }

        public MonitoringAppSpecification build() {
            return new MonitoringAppSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringAppSpecification> {
        public Builder imageUri(String var1);

        public Builder containerEntrypoint(Collection<String> var1);

        public Builder containerEntrypoint(String ... var1);

        public Builder containerArguments(Collection<String> var1);

        public Builder containerArguments(String ... var1);

        public Builder recordPreprocessorSourceUri(String var1);

        public Builder postAnalyticsProcessorSourceUri(String var1);
    }
}

