/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelPackageGroupResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeModelPackageGroupResponse.Builder, DescribeModelPackageGroupResponse> {
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupName").getter(getter(DescribeModelPackageGroupResponse::modelPackageGroupName))
            .setter(setter(Builder::modelPackageGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupArn").getter(getter(DescribeModelPackageGroupResponse::modelPackageGroupArn))
            .setter(setter(Builder::modelPackageGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupArn").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupDescription")
            .getter(getter(DescribeModelPackageGroupResponse::modelPackageGroupDescription))
            .setter(setter(Builder::modelPackageGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupDescription")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeModelPackageGroupResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeModelPackageGroupResponse::createdBy))
            .setter(setter(Builder::createdBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupStatus")
            .getter(getter(DescribeModelPackageGroupResponse::modelPackageGroupStatusAsString))
            .setter(setter(Builder::modelPackageGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_GROUP_ARN_FIELD, MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD,
            CREATION_TIME_FIELD, CREATED_BY_FIELD, MODEL_PACKAGE_GROUP_STATUS_FIELD));

    private final String modelPackageGroupName;

    private final String modelPackageGroupArn;

    private final String modelPackageGroupDescription;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final String modelPackageGroupStatus;

    private DescribeModelPackageGroupResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageGroupArn = builder.modelPackageGroupArn;
        this.modelPackageGroupDescription = builder.modelPackageGroupDescription;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.modelPackageGroupStatus = builder.modelPackageGroupStatus;
    }

    /**
     * <p>
     * The name of the model group.
     * </p>
     * 
     * @return The name of the model group.
     */
    public final String modelPackageGroupName() {
        return modelPackageGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model group.
     */
    public final String modelPackageGroupArn() {
        return modelPackageGroupArn;
    }

    /**
     * <p>
     * A description of the model group.
     * </p>
     * 
     * @return A description of the model group.
     */
    public final String modelPackageGroupDescription() {
        return modelPackageGroupDescription;
    }

    /**
     * <p>
     * The time that the model group was created.
     * </p>
     * 
     * @return The time that the model group was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The status of the model group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageGroupStatus} will return {@link ModelPackageGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #modelPackageGroupStatusAsString}.
     * </p>
     * 
     * @return The status of the model group.
     * @see ModelPackageGroupStatus
     */
    public final ModelPackageGroupStatus modelPackageGroupStatus() {
        return ModelPackageGroupStatus.fromValue(modelPackageGroupStatus);
    }

    /**
     * <p>
     * The status of the model group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageGroupStatus} will return {@link ModelPackageGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #modelPackageGroupStatusAsString}.
     * </p>
     * 
     * @return The status of the model group.
     * @see ModelPackageGroupStatus
     */
    public final String modelPackageGroupStatusAsString() {
        return modelPackageGroupStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelPackageGroupResponse)) {
            return false;
        }
        DescribeModelPackageGroupResponse other = (DescribeModelPackageGroupResponse) obj;
        return Objects.equals(modelPackageGroupName(), other.modelPackageGroupName())
                && Objects.equals(modelPackageGroupArn(), other.modelPackageGroupArn())
                && Objects.equals(modelPackageGroupDescription(), other.modelPackageGroupDescription())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(modelPackageGroupStatusAsString(), other.modelPackageGroupStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelPackageGroupResponse").add("ModelPackageGroupName", modelPackageGroupName())
                .add("ModelPackageGroupArn", modelPackageGroupArn())
                .add("ModelPackageGroupDescription", modelPackageGroupDescription()).add("CreationTime", creationTime())
                .add("CreatedBy", createdBy()).add("ModelPackageGroupStatus", modelPackageGroupStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageGroupName":
            return Optional.ofNullable(clazz.cast(modelPackageGroupName()));
        case "ModelPackageGroupArn":
            return Optional.ofNullable(clazz.cast(modelPackageGroupArn()));
        case "ModelPackageGroupDescription":
            return Optional.ofNullable(clazz.cast(modelPackageGroupDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "ModelPackageGroupStatus":
            return Optional.ofNullable(clazz.cast(modelPackageGroupStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelPackageGroupResponse, T> g) {
        return obj -> g.apply((DescribeModelPackageGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeModelPackageGroupResponse> {
        /**
         * <p>
         * The name of the model group.
         * </p>
         * 
         * @param modelPackageGroupName
         *        The name of the model group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupName(String modelPackageGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model group.
         * </p>
         * 
         * @param modelPackageGroupArn
         *        The Amazon Resource Name (ARN) of the model group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupArn(String modelPackageGroupArn);

        /**
         * <p>
         * A description of the model group.
         * </p>
         * 
         * @param modelPackageGroupDescription
         *        A description of the model group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupDescription(String modelPackageGroupDescription);

        /**
         * <p>
         * The time that the model group was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the model group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The status of the model group.
         * </p>
         * 
         * @param modelPackageGroupStatus
         *        The status of the model group.
         * @see ModelPackageGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageGroupStatus
         */
        Builder modelPackageGroupStatus(String modelPackageGroupStatus);

        /**
         * <p>
         * The status of the model group.
         * </p>
         * 
         * @param modelPackageGroupStatus
         *        The status of the model group.
         * @see ModelPackageGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageGroupStatus
         */
        Builder modelPackageGroupStatus(ModelPackageGroupStatus modelPackageGroupStatus);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String modelPackageGroupName;

        private String modelPackageGroupArn;

        private String modelPackageGroupDescription;

        private Instant creationTime;

        private UserContext createdBy;

        private String modelPackageGroupStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelPackageGroupResponse model) {
            super(model);
            modelPackageGroupName(model.modelPackageGroupName);
            modelPackageGroupArn(model.modelPackageGroupArn);
            modelPackageGroupDescription(model.modelPackageGroupDescription);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            modelPackageGroupStatus(model.modelPackageGroupStatus);
        }

        public final String getModelPackageGroupName() {
            return modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        public final String getModelPackageGroupArn() {
            return modelPackageGroupArn;
        }

        @Override
        public final Builder modelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
            return this;
        }

        public final void setModelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
        }

        public final String getModelPackageGroupDescription() {
            return modelPackageGroupDescription;
        }

        @Override
        public final Builder modelPackageGroupDescription(String modelPackageGroupDescription) {
            this.modelPackageGroupDescription = modelPackageGroupDescription;
            return this;
        }

        public final void setModelPackageGroupDescription(String modelPackageGroupDescription) {
            this.modelPackageGroupDescription = modelPackageGroupDescription;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final String getModelPackageGroupStatus() {
            return modelPackageGroupStatus;
        }

        @Override
        public final Builder modelPackageGroupStatus(String modelPackageGroupStatus) {
            this.modelPackageGroupStatus = modelPackageGroupStatus;
            return this;
        }

        @Override
        public final Builder modelPackageGroupStatus(ModelPackageGroupStatus modelPackageGroupStatus) {
            this.modelPackageGroupStatus(modelPackageGroupStatus == null ? null : modelPackageGroupStatus.toString());
            return this;
        }

        public final void setModelPackageGroupStatus(String modelPackageGroupStatus) {
            this.modelPackageGroupStatus = modelPackageGroupStatus;
        }

        @Override
        public DescribeModelPackageGroupResponse build() {
            return new DescribeModelPackageGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
