/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelQualityJobDefinitionRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateModelQualityJobDefinitionRequest.Builder, CreateModelQualityJobDefinitionRequest> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDefinitionName").getter(getter(CreateModelQualityJobDefinitionRequest::jobDefinitionName))
            .setter(setter(Builder::jobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()).build();

    private static final SdkField<ModelQualityBaselineConfig> MODEL_QUALITY_BASELINE_CONFIG_FIELD = SdkField
            .<ModelQualityBaselineConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ModelQualityBaselineConfig")
            .getter(getter(CreateModelQualityJobDefinitionRequest::modelQualityBaselineConfig))
            .setter(setter(Builder::modelQualityBaselineConfig))
            .constructor(ModelQualityBaselineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityBaselineConfig").build())
            .build();

    private static final SdkField<ModelQualityAppSpecification> MODEL_QUALITY_APP_SPECIFICATION_FIELD = SdkField
            .<ModelQualityAppSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("ModelQualityAppSpecification")
            .getter(getter(CreateModelQualityJobDefinitionRequest::modelQualityAppSpecification))
            .setter(setter(Builder::modelQualityAppSpecification))
            .constructor(ModelQualityAppSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityAppSpecification")
                    .build()).build();

    private static final SdkField<ModelQualityJobInput> MODEL_QUALITY_JOB_INPUT_FIELD = SdkField
            .<ModelQualityJobInput> builder(MarshallingType.SDK_POJO).memberName("ModelQualityJobInput")
            .getter(getter(CreateModelQualityJobDefinitionRequest::modelQualityJobInput))
            .setter(setter(Builder::modelQualityJobInput)).constructor(ModelQualityJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityJobInput").build())
            .build();

    private static final SdkField<MonitoringOutputConfig> MODEL_QUALITY_JOB_OUTPUT_CONFIG_FIELD = SdkField
            .<MonitoringOutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ModelQualityJobOutputConfig")
            .getter(getter(CreateModelQualityJobDefinitionRequest::modelQualityJobOutputConfig))
            .setter(setter(Builder::modelQualityJobOutputConfig))
            .constructor(MonitoringOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQualityJobOutputConfig")
                    .build()).build();

    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField
            .<MonitoringResources> builder(MarshallingType.SDK_POJO).memberName("JobResources")
            .getter(getter(CreateModelQualityJobDefinitionRequest::jobResources)).setter(setter(Builder::jobResources))
            .constructor(MonitoringResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()).build();

    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField
            .<MonitoringNetworkConfig> builder(MarshallingType.SDK_POJO).memberName("NetworkConfig")
            .getter(getter(CreateModelQualityJobDefinitionRequest::networkConfig)).setter(setter(Builder::networkConfig))
            .constructor(MonitoringNetworkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateModelQualityJobDefinitionRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<MonitoringStoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(CreateModelQualityJobDefinitionRequest::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(MonitoringStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateModelQualityJobDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD,
            MODEL_QUALITY_BASELINE_CONFIG_FIELD, MODEL_QUALITY_APP_SPECIFICATION_FIELD, MODEL_QUALITY_JOB_INPUT_FIELD,
            MODEL_QUALITY_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD,
            STOPPING_CONDITION_FIELD, TAGS_FIELD));

    private final String jobDefinitionName;

    private final ModelQualityBaselineConfig modelQualityBaselineConfig;

    private final ModelQualityAppSpecification modelQualityAppSpecification;

    private final ModelQualityJobInput modelQualityJobInput;

    private final MonitoringOutputConfig modelQualityJobOutputConfig;

    private final MonitoringResources jobResources;

    private final MonitoringNetworkConfig networkConfig;

    private final String roleArn;

    private final MonitoringStoppingCondition stoppingCondition;

    private final List<Tag> tags;

    private CreateModelQualityJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.modelQualityBaselineConfig = builder.modelQualityBaselineConfig;
        this.modelQualityAppSpecification = builder.modelQualityAppSpecification;
        this.modelQualityJobInput = builder.modelQualityJobInput;
        this.modelQualityJobOutputConfig = builder.modelQualityJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the monitoring job definition.
     * </p>
     * 
     * @return The name of the monitoring job definition.
     */
    public final String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * Specifies the constraints and baselines for the monitoring job.
     * </p>
     * 
     * @return Specifies the constraints and baselines for the monitoring job.
     */
    public final ModelQualityBaselineConfig modelQualityBaselineConfig() {
        return modelQualityBaselineConfig;
    }

    /**
     * <p>
     * The container that runs the monitoring job.
     * </p>
     * 
     * @return The container that runs the monitoring job.
     */
    public final ModelQualityAppSpecification modelQualityAppSpecification() {
        return modelQualityAppSpecification;
    }

    /**
     * <p>
     * A list of the inputs that are monitored. Currently endpoints are supported.
     * </p>
     * 
     * @return A list of the inputs that are monitored. Currently endpoints are supported.
     */
    public final ModelQualityJobInput modelQualityJobInput() {
        return modelQualityJobInput;
    }

    /**
     * Returns the value of the ModelQualityJobOutputConfig property for this object.
     * 
     * @return The value of the ModelQualityJobOutputConfig property for this object.
     */
    public final MonitoringOutputConfig modelQualityJobOutputConfig() {
        return modelQualityJobOutputConfig;
    }

    /**
     * Returns the value of the JobResources property for this object.
     * 
     * @return The value of the JobResources property for this object.
     */
    public final MonitoringResources jobResources() {
        return jobResources;
    }

    /**
     * <p>
     * Specifies the network configuration for the monitoring job.
     * </p>
     * 
     * @return Specifies the network configuration for the monitoring job.
     */
    public final MonitoringNetworkConfig networkConfig() {
        return networkConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the StoppingCondition property for this object.
     * 
     * @return The value of the StoppingCondition property for this object.
     */
    public final MonitoringStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) An array of key-value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using
     * Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Optional) An array of key-value pairs. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
     *         >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelQualityJobDefinitionRequest)) {
            return false;
        }
        CreateModelQualityJobDefinitionRequest other = (CreateModelQualityJobDefinitionRequest) obj;
        return Objects.equals(jobDefinitionName(), other.jobDefinitionName())
                && Objects.equals(modelQualityBaselineConfig(), other.modelQualityBaselineConfig())
                && Objects.equals(modelQualityAppSpecification(), other.modelQualityAppSpecification())
                && Objects.equals(modelQualityJobInput(), other.modelQualityJobInput())
                && Objects.equals(modelQualityJobOutputConfig(), other.modelQualityJobOutputConfig())
                && Objects.equals(jobResources(), other.jobResources()) && Objects.equals(networkConfig(), other.networkConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelQualityJobDefinitionRequest").add("JobDefinitionName", jobDefinitionName())
                .add("ModelQualityBaselineConfig", modelQualityBaselineConfig())
                .add("ModelQualityAppSpecification", modelQualityAppSpecification())
                .add("ModelQualityJobInput", modelQualityJobInput())
                .add("ModelQualityJobOutputConfig", modelQualityJobOutputConfig()).add("JobResources", jobResources())
                .add("NetworkConfig", networkConfig()).add("RoleArn", roleArn()).add("StoppingCondition", stoppingCondition())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "ModelQualityBaselineConfig":
            return Optional.ofNullable(clazz.cast(modelQualityBaselineConfig()));
        case "ModelQualityAppSpecification":
            return Optional.ofNullable(clazz.cast(modelQualityAppSpecification()));
        case "ModelQualityJobInput":
            return Optional.ofNullable(clazz.cast(modelQualityJobInput()));
        case "ModelQualityJobOutputConfig":
            return Optional.ofNullable(clazz.cast(modelQualityJobOutputConfig()));
        case "JobResources":
            return Optional.ofNullable(clazz.cast(jobResources()));
        case "NetworkConfig":
            return Optional.ofNullable(clazz.cast(networkConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelQualityJobDefinitionRequest, T> g) {
        return obj -> g.apply((CreateModelQualityJobDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateModelQualityJobDefinitionRequest> {
        /**
         * <p>
         * The name of the monitoring job definition.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the monitoring job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * Specifies the constraints and baselines for the monitoring job.
         * </p>
         * 
         * @param modelQualityBaselineConfig
         *        Specifies the constraints and baselines for the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQualityBaselineConfig(ModelQualityBaselineConfig modelQualityBaselineConfig);

        /**
         * <p>
         * Specifies the constraints and baselines for the monitoring job.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelQualityBaselineConfig.Builder} avoiding the
         * need to create one manually via {@link ModelQualityBaselineConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelQualityBaselineConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #modelQualityBaselineConfig(ModelQualityBaselineConfig)}.
         * 
         * @param modelQualityBaselineConfig
         *        a consumer that will call methods on {@link ModelQualityBaselineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQualityBaselineConfig(ModelQualityBaselineConfig)
         */
        default Builder modelQualityBaselineConfig(Consumer<ModelQualityBaselineConfig.Builder> modelQualityBaselineConfig) {
            return modelQualityBaselineConfig(ModelQualityBaselineConfig.builder().applyMutation(modelQualityBaselineConfig)
                    .build());
        }

        /**
         * <p>
         * The container that runs the monitoring job.
         * </p>
         * 
         * @param modelQualityAppSpecification
         *        The container that runs the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQualityAppSpecification(ModelQualityAppSpecification modelQualityAppSpecification);

        /**
         * <p>
         * The container that runs the monitoring job.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelQualityAppSpecification.Builder} avoiding
         * the need to create one manually via {@link ModelQualityAppSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelQualityAppSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #modelQualityAppSpecification(ModelQualityAppSpecification)}.
         * 
         * @param modelQualityAppSpecification
         *        a consumer that will call methods on {@link ModelQualityAppSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQualityAppSpecification(ModelQualityAppSpecification)
         */
        default Builder modelQualityAppSpecification(Consumer<ModelQualityAppSpecification.Builder> modelQualityAppSpecification) {
            return modelQualityAppSpecification(ModelQualityAppSpecification.builder()
                    .applyMutation(modelQualityAppSpecification).build());
        }

        /**
         * <p>
         * A list of the inputs that are monitored. Currently endpoints are supported.
         * </p>
         * 
         * @param modelQualityJobInput
         *        A list of the inputs that are monitored. Currently endpoints are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQualityJobInput(ModelQualityJobInput modelQualityJobInput);

        /**
         * <p>
         * A list of the inputs that are monitored. Currently endpoints are supported.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelQualityJobInput.Builder} avoiding the need
         * to create one manually via {@link ModelQualityJobInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelQualityJobInput.Builder#build()} is called immediately and
         * its result is passed to {@link #modelQualityJobInput(ModelQualityJobInput)}.
         * 
         * @param modelQualityJobInput
         *        a consumer that will call methods on {@link ModelQualityJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQualityJobInput(ModelQualityJobInput)
         */
        default Builder modelQualityJobInput(Consumer<ModelQualityJobInput.Builder> modelQualityJobInput) {
            return modelQualityJobInput(ModelQualityJobInput.builder().applyMutation(modelQualityJobInput).build());
        }

        /**
         * Sets the value of the ModelQualityJobOutputConfig property for this object.
         *
         * @param modelQualityJobOutputConfig
         *        The new value for the ModelQualityJobOutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQualityJobOutputConfig(MonitoringOutputConfig modelQualityJobOutputConfig);

        /**
         * Sets the value of the ModelQualityJobOutputConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringOutputConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #modelQualityJobOutputConfig(MonitoringOutputConfig)}.
         * 
         * @param modelQualityJobOutputConfig
         *        a consumer that will call methods on {@link MonitoringOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQualityJobOutputConfig(MonitoringOutputConfig)
         */
        default Builder modelQualityJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> modelQualityJobOutputConfig) {
            return modelQualityJobOutputConfig(MonitoringOutputConfig.builder().applyMutation(modelQualityJobOutputConfig)
                    .build());
        }

        /**
         * Sets the value of the JobResources property for this object.
         *
         * @param jobResources
         *        The new value for the JobResources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobResources(MonitoringResources jobResources);

        /**
         * Sets the value of the JobResources property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringResources.Builder} avoiding the need
         * to create one manually via {@link MonitoringResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringResources.Builder#build()} is called immediately and
         * its result is passed to {@link #jobResources(MonitoringResources)}.
         * 
         * @param jobResources
         *        a consumer that will call methods on {@link MonitoringResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobResources(MonitoringResources)
         */
        default Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return jobResources(MonitoringResources.builder().applyMutation(jobResources).build());
        }

        /**
         * <p>
         * Specifies the network configuration for the monitoring job.
         * </p>
         * 
         * @param networkConfig
         *        Specifies the network configuration for the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfig(MonitoringNetworkConfig networkConfig);

        /**
         * <p>
         * Specifies the network configuration for the monitoring job.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringNetworkConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringNetworkConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringNetworkConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #networkConfig(MonitoringNetworkConfig)}.
         * 
         * @param networkConfig
         *        a consumer that will call methods on {@link MonitoringNetworkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfig(MonitoringNetworkConfig)
         */
        default Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return networkConfig(MonitoringNetworkConfig.builder().applyMutation(networkConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
         * behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
         *        your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * @param stoppingCondition
         *        The new value for the StoppingCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringStoppingCondition.Builder} avoiding
         * the need to create one manually via {@link MonitoringStoppingCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringStoppingCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingCondition(MonitoringStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link MonitoringStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(MonitoringStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(MonitoringStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String jobDefinitionName;

        private ModelQualityBaselineConfig modelQualityBaselineConfig;

        private ModelQualityAppSpecification modelQualityAppSpecification;

        private ModelQualityJobInput modelQualityJobInput;

        private MonitoringOutputConfig modelQualityJobOutputConfig;

        private MonitoringResources jobResources;

        private MonitoringNetworkConfig networkConfig;

        private String roleArn;

        private MonitoringStoppingCondition stoppingCondition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelQualityJobDefinitionRequest model) {
            super(model);
            jobDefinitionName(model.jobDefinitionName);
            modelQualityBaselineConfig(model.modelQualityBaselineConfig);
            modelQualityAppSpecification(model.modelQualityAppSpecification);
            modelQualityJobInput(model.modelQualityJobInput);
            modelQualityJobOutputConfig(model.modelQualityJobOutputConfig);
            jobResources(model.jobResources);
            networkConfig(model.networkConfig);
            roleArn(model.roleArn);
            stoppingCondition(model.stoppingCondition);
            tags(model.tags);
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final ModelQualityBaselineConfig.Builder getModelQualityBaselineConfig() {
            return modelQualityBaselineConfig != null ? modelQualityBaselineConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelQualityBaselineConfig(ModelQualityBaselineConfig modelQualityBaselineConfig) {
            this.modelQualityBaselineConfig = modelQualityBaselineConfig;
            return this;
        }

        public final void setModelQualityBaselineConfig(ModelQualityBaselineConfig.BuilderImpl modelQualityBaselineConfig) {
            this.modelQualityBaselineConfig = modelQualityBaselineConfig != null ? modelQualityBaselineConfig.build() : null;
        }

        public final ModelQualityAppSpecification.Builder getModelQualityAppSpecification() {
            return modelQualityAppSpecification != null ? modelQualityAppSpecification.toBuilder() : null;
        }

        @Override
        public final Builder modelQualityAppSpecification(ModelQualityAppSpecification modelQualityAppSpecification) {
            this.modelQualityAppSpecification = modelQualityAppSpecification;
            return this;
        }

        public final void setModelQualityAppSpecification(ModelQualityAppSpecification.BuilderImpl modelQualityAppSpecification) {
            this.modelQualityAppSpecification = modelQualityAppSpecification != null ? modelQualityAppSpecification.build()
                    : null;
        }

        public final ModelQualityJobInput.Builder getModelQualityJobInput() {
            return modelQualityJobInput != null ? modelQualityJobInput.toBuilder() : null;
        }

        @Override
        public final Builder modelQualityJobInput(ModelQualityJobInput modelQualityJobInput) {
            this.modelQualityJobInput = modelQualityJobInput;
            return this;
        }

        public final void setModelQualityJobInput(ModelQualityJobInput.BuilderImpl modelQualityJobInput) {
            this.modelQualityJobInput = modelQualityJobInput != null ? modelQualityJobInput.build() : null;
        }

        public final MonitoringOutputConfig.Builder getModelQualityJobOutputConfig() {
            return modelQualityJobOutputConfig != null ? modelQualityJobOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelQualityJobOutputConfig(MonitoringOutputConfig modelQualityJobOutputConfig) {
            this.modelQualityJobOutputConfig = modelQualityJobOutputConfig;
            return this;
        }

        public final void setModelQualityJobOutputConfig(MonitoringOutputConfig.BuilderImpl modelQualityJobOutputConfig) {
            this.modelQualityJobOutputConfig = modelQualityJobOutputConfig != null ? modelQualityJobOutputConfig.build() : null;
        }

        public final MonitoringResources.Builder getJobResources() {
            return jobResources != null ? jobResources.toBuilder() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return networkConfig != null ? networkConfig.toBuilder() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelQualityJobDefinitionRequest build() {
            return new CreateModelQualityJobDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
