/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserProfileRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateUserProfileRequest.Builder, CreateUserProfileRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(CreateUserProfileRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserProfileName").getter(getter(CreateUserProfileRequest::userProfileName))
            .setter(setter(Builder::userProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()).build();

    private static final SdkField<String> SINGLE_SIGN_ON_USER_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SingleSignOnUserIdentifier")
            .getter(getter(CreateUserProfileRequest::singleSignOnUserIdentifier))
            .setter(setter(Builder::singleSignOnUserIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnUserIdentifier").build())
            .build();

    private static final SdkField<String> SINGLE_SIGN_ON_USER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SingleSignOnUserValue").getter(getter(CreateUserProfileRequest::singleSignOnUserValue))
            .setter(setter(Builder::singleSignOnUserValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnUserValue").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateUserProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<UserSettings> USER_SETTINGS_FIELD = SdkField.<UserSettings> builder(MarshallingType.SDK_POJO)
            .memberName("UserSettings").getter(getter(CreateUserProfileRequest::userSettings))
            .setter(setter(Builder::userSettings)).constructor(UserSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            USER_PROFILE_NAME_FIELD, SINGLE_SIGN_ON_USER_IDENTIFIER_FIELD, SINGLE_SIGN_ON_USER_VALUE_FIELD, TAGS_FIELD,
            USER_SETTINGS_FIELD));

    private final String domainId;

    private final String userProfileName;

    private final String singleSignOnUserIdentifier;

    private final String singleSignOnUserValue;

    private final List<Tag> tags;

    private final UserSettings userSettings;

    private CreateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.singleSignOnUserIdentifier = builder.singleSignOnUserIdentifier;
        this.singleSignOnUserValue = builder.singleSignOnUserValue;
        this.tags = builder.tags;
        this.userSettings = builder.userSettings;
    }

    /**
     * <p>
     * The ID of the associated Domain.
     * </p>
     * 
     * @return The ID of the associated Domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * A name for the UserProfile.
     * </p>
     * 
     * @return A name for the UserProfile.
     */
    public final String userProfileName() {
        return userProfileName;
    }

    /**
     * <p>
     * A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value is
     * "UserName". If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this
     * field cannot be specified.
     * </p>
     * 
     * @return A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value
     *         is "UserName". If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not
     *         SSO, this field cannot be specified.
     */
    public final String singleSignOnUserIdentifier() {
        return singleSignOnUserIdentifier;
    }

    /**
     * <p>
     * The username of the associated AWS Single Sign-On User for this UserProfile. If the Domain's AuthMode is SSO,
     * this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is
     * not SSO, this field cannot be specified.
     * </p>
     * 
     * @return The username of the associated AWS Single Sign-On User for this UserProfile. If the Domain's AuthMode is
     *         SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's
     *         AuthMode is not SSO, this field cannot be specified.
     */
    public final String singleSignOnUserValue() {
        return singleSignOnUserValue;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Each tag consists of a key and an optional value. Tag keys must be unique per resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A collection of settings.
     * </p>
     * 
     * @return A collection of settings.
     */
    public final UserSettings userSettings() {
        return userSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOnUserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOnUserValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserProfileRequest)) {
            return false;
        }
        CreateUserProfileRequest other = (CreateUserProfileRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(userProfileName(), other.userProfileName())
                && Objects.equals(singleSignOnUserIdentifier(), other.singleSignOnUserIdentifier())
                && Objects.equals(singleSignOnUserValue(), other.singleSignOnUserValue()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(userSettings(), other.userSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserProfileRequest").add("DomainId", domainId()).add("UserProfileName", userProfileName())
                .add("SingleSignOnUserIdentifier", singleSignOnUserIdentifier())
                .add("SingleSignOnUserValue", singleSignOnUserValue()).add("Tags", hasTags() ? tags() : null)
                .add("UserSettings", userSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "UserProfileName":
            return Optional.ofNullable(clazz.cast(userProfileName()));
        case "SingleSignOnUserIdentifier":
            return Optional.ofNullable(clazz.cast(singleSignOnUserIdentifier()));
        case "SingleSignOnUserValue":
            return Optional.ofNullable(clazz.cast(singleSignOnUserValue()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UserSettings":
            return Optional.ofNullable(clazz.cast(userSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserProfileRequest, T> g) {
        return obj -> g.apply((CreateUserProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserProfileRequest> {
        /**
         * <p>
         * The ID of the associated Domain.
         * </p>
         * 
         * @param domainId
         *        The ID of the associated Domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * A name for the UserProfile.
         * </p>
         * 
         * @param userProfileName
         *        A name for the UserProfile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileName(String userProfileName);

        /**
         * <p>
         * A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value is
         * "UserName". If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO,
         * this field cannot be specified.
         * </p>
         * 
         * @param singleSignOnUserIdentifier
         *        A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported
         *        value is "UserName". If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode
         *        is not SSO, this field cannot be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOnUserIdentifier(String singleSignOnUserIdentifier);

        /**
         * <p>
         * The username of the associated AWS Single Sign-On User for this UserProfile. If the Domain's AuthMode is SSO,
         * this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode
         * is not SSO, this field cannot be specified.
         * </p>
         * 
         * @param singleSignOnUserValue
         *        The username of the associated AWS Single Sign-On User for this UserProfile. If the Domain's AuthMode
         *        is SSO, this field is required, and must match a valid username of a user in your directory. If the
         *        Domain's AuthMode is not SSO, this field cannot be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOnUserValue(String singleSignOnUserValue);

        /**
         * <p>
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * </p>
         * 
         * @param tags
         *        Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A collection of settings.
         * </p>
         * 
         * @param userSettings
         *        A collection of settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(UserSettings userSettings);

        /**
         * <p>
         * A collection of settings.
         * </p>
         * This is a convenience that creates an instance of the {@link UserSettings.Builder} avoiding the need to
         * create one manually via {@link UserSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #userSettings(UserSettings)}.
         * 
         * @param userSettings
         *        a consumer that will call methods on {@link UserSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userSettings(UserSettings)
         */
        default Builder userSettings(Consumer<UserSettings.Builder> userSettings) {
            return userSettings(UserSettings.builder().applyMutation(userSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainId;

        private String userProfileName;

        private String singleSignOnUserIdentifier;

        private String singleSignOnUserValue;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private UserSettings userSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserProfileRequest model) {
            super(model);
            domainId(model.domainId);
            userProfileName(model.userProfileName);
            singleSignOnUserIdentifier(model.singleSignOnUserIdentifier);
            singleSignOnUserValue(model.singleSignOnUserValue);
            tags(model.tags);
            userSettings(model.userSettings);
        }

        public final String getDomainId() {
            return domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getUserProfileName() {
            return userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        public final String getSingleSignOnUserIdentifier() {
            return singleSignOnUserIdentifier;
        }

        @Override
        public final Builder singleSignOnUserIdentifier(String singleSignOnUserIdentifier) {
            this.singleSignOnUserIdentifier = singleSignOnUserIdentifier;
            return this;
        }

        public final void setSingleSignOnUserIdentifier(String singleSignOnUserIdentifier) {
            this.singleSignOnUserIdentifier = singleSignOnUserIdentifier;
        }

        public final String getSingleSignOnUserValue() {
            return singleSignOnUserValue;
        }

        @Override
        public final Builder singleSignOnUserValue(String singleSignOnUserValue) {
            this.singleSignOnUserValue = singleSignOnUserValue;
            return this;
        }

        public final void setSingleSignOnUserValue(String singleSignOnUserValue) {
            this.singleSignOnUserValue = singleSignOnUserValue;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final UserSettings.Builder getUserSettings() {
            return userSettings != null ? userSettings.toBuilder() : null;
        }

        @Override
        public final Builder userSettings(UserSettings userSettings) {
            this.userSettings = userSettings;
            return this;
        }

        public final void setUserSettings(UserSettings.BuilderImpl userSettings) {
            this.userSettings = userSettings != null ? userSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserProfileRequest build() {
            return new CreateUserProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
