/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContextsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListContextsResponse.Builder, ListContextsResponse> {
    private static final SdkField<List<ContextSummary>> CONTEXT_SUMMARIES_FIELD = SdkField
            .<List<ContextSummary>> builder(MarshallingType.LIST)
            .memberName("ContextSummaries")
            .getter(getter(ListContextsResponse::contextSummaries))
            .setter(setter(Builder::contextSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContextSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContextSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContextsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ContextSummary> contextSummaries;

    private final String nextToken;

    private ListContextsResponse(BuilderImpl builder) {
        super(builder);
        this.contextSummaries = builder.contextSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ContextSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasContextSummaries() {
        return contextSummaries != null && !(contextSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of contexts and their properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContextSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of contexts and their properties.
     */
    public final List<ContextSummary> contextSummaries() {
        return contextSummaries;
    }

    /**
     * <p>
     * A token for getting the next set of contexts, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of contexts, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContextSummaries() ? contextSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContextsResponse)) {
            return false;
        }
        ListContextsResponse other = (ListContextsResponse) obj;
        return hasContextSummaries() == other.hasContextSummaries()
                && Objects.equals(contextSummaries(), other.contextSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContextsResponse")
                .add("ContextSummaries", hasContextSummaries() ? contextSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContextSummaries":
            return Optional.ofNullable(clazz.cast(contextSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContextsResponse, T> g) {
        return obj -> g.apply((ListContextsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListContextsResponse> {
        /**
         * <p>
         * A list of contexts and their properties.
         * </p>
         * 
         * @param contextSummaries
         *        A list of contexts and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextSummaries(Collection<ContextSummary> contextSummaries);

        /**
         * <p>
         * A list of contexts and their properties.
         * </p>
         * 
         * @param contextSummaries
         *        A list of contexts and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextSummaries(ContextSummary... contextSummaries);

        /**
         * <p>
         * A list of contexts and their properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContextSummary>.Builder} avoiding the need
         * to create one manually via {@link List<ContextSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContextSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #contextSummaries(List<ContextSummary>)}.
         * 
         * @param contextSummaries
         *        a consumer that will call methods on {@link List<ContextSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextSummaries(List<ContextSummary>)
         */
        Builder contextSummaries(Consumer<ContextSummary.Builder>... contextSummaries);

        /**
         * <p>
         * A token for getting the next set of contexts, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of contexts, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<ContextSummary> contextSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContextsResponse model) {
            super(model);
            contextSummaries(model.contextSummaries);
            nextToken(model.nextToken);
        }

        public final List<ContextSummary.Builder> getContextSummaries() {
            List<ContextSummary.Builder> result = ContextSummariesCopier.copyToBuilder(this.contextSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder contextSummaries(Collection<ContextSummary> contextSummaries) {
            this.contextSummaries = ContextSummariesCopier.copy(contextSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextSummaries(ContextSummary... contextSummaries) {
            contextSummaries(Arrays.asList(contextSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextSummaries(Consumer<ContextSummary.Builder>... contextSummaries) {
            contextSummaries(Stream.of(contextSummaries).map(c -> ContextSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContextSummaries(Collection<ContextSummary.BuilderImpl> contextSummaries) {
            this.contextSummaries = ContextSummariesCopier.copyFromBuilder(contextSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListContextsResponse build() {
            return new ListContextsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
