/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the properties of a trial component. To get all the properties, call the <a>DescribeTrialComponent</a>
 * API and provide the <code>TrialComponentName</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialComponentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrialComponentSummary.Builder, TrialComponentSummary> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentName").getter(getter(TrialComponentSummary::trialComponentName))
            .setter(setter(Builder::trialComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build())
            .build();

    private static final SdkField<String> TRIAL_COMPONENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentArn").getter(getter(TrialComponentSummary::trialComponentArn))
            .setter(setter(Builder::trialComponentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(TrialComponentSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<TrialComponentSource> TRIAL_COMPONENT_SOURCE_FIELD = SdkField
            .<TrialComponentSource> builder(MarshallingType.SDK_POJO).memberName("TrialComponentSource")
            .getter(getter(TrialComponentSummary::trialComponentSource)).setter(setter(Builder::trialComponentSource))
            .constructor(TrialComponentSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentSource").build())
            .build();

    private static final SdkField<TrialComponentStatus> STATUS_FIELD = SdkField
            .<TrialComponentStatus> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(TrialComponentSummary::status)).setter(setter(Builder::status))
            .constructor(TrialComponentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(TrialComponentSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(TrialComponentSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(TrialComponentSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(TrialComponentSummary::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(TrialComponentSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(TrialComponentSummary::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD,
            TRIAL_COMPONENT_ARN_FIELD, DISPLAY_NAME_FIELD, TRIAL_COMPONENT_SOURCE_FIELD, STATUS_FIELD, START_TIME_FIELD,
            END_TIME_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trialComponentName;

    private final String trialComponentArn;

    private final String displayName;

    private final TrialComponentSource trialComponentSource;

    private final TrialComponentStatus status;

    private final Instant startTime;

    private final Instant endTime;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private TrialComponentSummary(BuilderImpl builder) {
        this.trialComponentName = builder.trialComponentName;
        this.trialComponentArn = builder.trialComponentArn;
        this.displayName = builder.displayName;
        this.trialComponentSource = builder.trialComponentSource;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    /**
     * <p>
     * The name of the trial component.
     * </p>
     * 
     * @return The name of the trial component.
     */
    public final String trialComponentName() {
        return trialComponentName;
    }

    /**
     * <p>
     * The ARN of the trial component.
     * </p>
     * 
     * @return The ARN of the trial component.
     */
    public final String trialComponentArn() {
        return trialComponentArn;
    }

    /**
     * <p>
     * The name of the component as displayed. If <code>DisplayName</code> isn't specified,
     * <code>TrialComponentName</code> is displayed.
     * </p>
     * 
     * @return The name of the component as displayed. If <code>DisplayName</code> isn't specified,
     *         <code>TrialComponentName</code> is displayed.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * Returns the value of the TrialComponentSource property for this object.
     * 
     * @return The value of the TrialComponentSource property for this object.
     */
    public final TrialComponentSource trialComponentSource() {
        return trialComponentSource;
    }

    /**
     * <p>
     * The status of the component. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * InProgress
     * </p>
     * </li>
     * <li>
     * <p>
     * Completed
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the component. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         InProgress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Completed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed
     *         </p>
     *         </li>
     */
    public final TrialComponentStatus status() {
        return status;
    }

    /**
     * <p>
     * When the component started.
     * </p>
     * 
     * @return When the component started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * When the component ended.
     * </p>
     * 
     * @return When the component ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * When the component was created.
     * </p>
     * 
     * @return When the component was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Who created the component.
     * </p>
     * 
     * @return Who created the component.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * When the component was last modified.
     * </p>
     * 
     * @return When the component was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Who last modified the component.
     * </p>
     * 
     * @return Who last modified the component.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentSource());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentSummary)) {
            return false;
        }
        TrialComponentSummary other = (TrialComponentSummary) obj;
        return Objects.equals(trialComponentName(), other.trialComponentName())
                && Objects.equals(trialComponentArn(), other.trialComponentArn())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(trialComponentSource(), other.trialComponentSource())
                && Objects.equals(status(), other.status()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrialComponentSummary").add("TrialComponentName", trialComponentName())
                .add("TrialComponentArn", trialComponentArn()).add("DisplayName", displayName())
                .add("TrialComponentSource", trialComponentSource()).add("Status", status()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("CreationTime", creationTime()).add("CreatedBy", createdBy())
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedBy", lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialComponentName":
            return Optional.ofNullable(clazz.cast(trialComponentName()));
        case "TrialComponentArn":
            return Optional.ofNullable(clazz.cast(trialComponentArn()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "TrialComponentSource":
            return Optional.ofNullable(clazz.cast(trialComponentSource()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentSummary, T> g) {
        return obj -> g.apply((TrialComponentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialComponentSummary> {
        /**
         * <p>
         * The name of the trial component.
         * </p>
         * 
         * @param trialComponentName
         *        The name of the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentName(String trialComponentName);

        /**
         * <p>
         * The ARN of the trial component.
         * </p>
         * 
         * @param trialComponentArn
         *        The ARN of the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentArn(String trialComponentArn);

        /**
         * <p>
         * The name of the component as displayed. If <code>DisplayName</code> isn't specified,
         * <code>TrialComponentName</code> is displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the component as displayed. If <code>DisplayName</code> isn't specified,
         *        <code>TrialComponentName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * Sets the value of the TrialComponentSource property for this object.
         *
         * @param trialComponentSource
         *        The new value for the TrialComponentSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentSource(TrialComponentSource trialComponentSource);

        /**
         * Sets the value of the TrialComponentSource property for this object.
         *
         * This is a convenience that creates an instance of the {@link TrialComponentSource.Builder} avoiding the need
         * to create one manually via {@link TrialComponentSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialComponentSource.Builder#build()} is called immediately and
         * its result is passed to {@link #trialComponentSource(TrialComponentSource)}.
         * 
         * @param trialComponentSource
         *        a consumer that will call methods on {@link TrialComponentSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trialComponentSource(TrialComponentSource)
         */
        default Builder trialComponentSource(Consumer<TrialComponentSource.Builder> trialComponentSource) {
            return trialComponentSource(TrialComponentSource.builder().applyMutation(trialComponentSource).build());
        }

        /**
         * <p>
         * The status of the component. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * InProgress
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the component. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        InProgress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(TrialComponentStatus status);

        /**
         * <p>
         * The status of the component. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * InProgress
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link TrialComponentStatus.Builder} avoiding the need
         * to create one manually via {@link TrialComponentStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialComponentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(TrialComponentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link TrialComponentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(TrialComponentStatus)
         */
        default Builder status(Consumer<TrialComponentStatus.Builder> status) {
            return status(TrialComponentStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * When the component started.
         * </p>
         * 
         * @param startTime
         *        When the component started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * When the component ended.
         * </p>
         * 
         * @param endTime
         *        When the component ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * When the component was created.
         * </p>
         * 
         * @param creationTime
         *        When the component was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Who created the component.
         * </p>
         * 
         * @param createdBy
         *        Who created the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * <p>
         * Who created the component.
         * </p>
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * When the component was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the component was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Who last modified the component.
         * </p>
         * 
         * @param lastModifiedBy
         *        Who last modified the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * <p>
         * Who last modified the component.
         * </p>
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String trialComponentName;

        private String trialComponentArn;

        private String displayName;

        private TrialComponentSource trialComponentSource;

        private TrialComponentStatus status;

        private Instant startTime;

        private Instant endTime;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentSummary model) {
            trialComponentName(model.trialComponentName);
            trialComponentArn(model.trialComponentArn);
            displayName(model.displayName);
            trialComponentSource(model.trialComponentSource);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
        }

        public final String getTrialComponentName() {
            return trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        public final String getTrialComponentArn() {
            return trialComponentArn;
        }

        @Override
        public final Builder trialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
            return this;
        }

        public final void setTrialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final TrialComponentSource.Builder getTrialComponentSource() {
            return trialComponentSource != null ? trialComponentSource.toBuilder() : null;
        }

        @Override
        public final Builder trialComponentSource(TrialComponentSource trialComponentSource) {
            this.trialComponentSource = trialComponentSource;
            return this;
        }

        public final void setTrialComponentSource(TrialComponentSource.BuilderImpl trialComponentSource) {
            this.trialComponentSource = trialComponentSource != null ? trialComponentSource.build() : null;
        }

        public final TrialComponentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(TrialComponentStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(TrialComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public TrialComponentSummary build() {
            return new TrialComponentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
