/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details that you specify to provision a service catalog product. For information about service catalog, see .<a
 * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is AWS Service
 * Catalog</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceCatalogProvisioningDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceCatalogProvisioningDetails.Builder, ServiceCatalogProvisioningDetails> {
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(ServiceCatalogProvisioningDetails::productId))
            .setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactId").getter(getter(ServiceCatalogProvisioningDetails::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final SdkField<String> PATH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PathId")
            .getter(getter(ServiceCatalogProvisioningDetails::pathId)).setter(setter(Builder::pathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()).build();

    private static final SdkField<List<ProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField
            .<List<ProvisioningParameter>> builder(MarshallingType.LIST)
            .memberName("ProvisioningParameters")
            .getter(getter(ServiceCatalogProvisioningDetails::provisioningParameters))
            .setter(setter(Builder::provisioningParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ID_FIELD,
            PROVISIONING_ARTIFACT_ID_FIELD, PATH_ID_FIELD, PROVISIONING_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String productId;

    private final String provisioningArtifactId;

    private final String pathId;

    private final List<ProvisioningParameter> provisioningParameters;

    private ServiceCatalogProvisioningDetails(BuilderImpl builder) {
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pathId = builder.pathId;
        this.provisioningParameters = builder.provisioningParameters;
    }

    /**
     * <p>
     * The ID of the product to provision.
     * </p>
     * 
     * @return The ID of the product to provision.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The ID of the provisioning artifact.
     * </p>
     * 
     * @return The ID of the provisioning artifact.
     */
    public final String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    /**
     * <p>
     * The path identifier of the product. This value is optional if the product has a default path, and required if the
     * product has more than one path.
     * </p>
     * 
     * @return The path identifier of the product. This value is optional if the product has a default path, and
     *         required if the product has more than one path.
     */
    public final String pathId() {
        return pathId;
    }

    /**
     * Returns true if the ProvisioningParameters property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProvisioningParameters() {
        return provisioningParameters != null && !(provisioningParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key value pairs that you specify when you provision a product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisioningParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of key value pairs that you specify when you provision a product.
     */
    public final List<ProvisioningParameter> provisioningParameters() {
        return provisioningParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(pathId());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisioningParameters() ? provisioningParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceCatalogProvisioningDetails)) {
            return false;
        }
        ServiceCatalogProvisioningDetails other = (ServiceCatalogProvisioningDetails) obj;
        return Objects.equals(productId(), other.productId())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId())
                && Objects.equals(pathId(), other.pathId()) && hasProvisioningParameters() == other.hasProvisioningParameters()
                && Objects.equals(provisioningParameters(), other.provisioningParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceCatalogProvisioningDetails").add("ProductId", productId())
                .add("ProvisioningArtifactId", provisioningArtifactId()).add("PathId", pathId())
                .add("ProvisioningParameters", hasProvisioningParameters() ? provisioningParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        case "PathId":
            return Optional.ofNullable(clazz.cast(pathId()));
        case "ProvisioningParameters":
            return Optional.ofNullable(clazz.cast(provisioningParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceCatalogProvisioningDetails, T> g) {
        return obj -> g.apply((ServiceCatalogProvisioningDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceCatalogProvisioningDetails> {
        /**
         * <p>
         * The ID of the product to provision.
         * </p>
         * 
         * @param productId
         *        The ID of the product to provision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The ID of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The ID of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);

        /**
         * <p>
         * The path identifier of the product. This value is optional if the product has a default path, and required if
         * the product has more than one path.
         * </p>
         * 
         * @param pathId
         *        The path identifier of the product. This value is optional if the product has a default path, and
         *        required if the product has more than one path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathId(String pathId);

        /**
         * <p>
         * A list of key value pairs that you specify when you provision a product.
         * </p>
         * 
         * @param provisioningParameters
         *        A list of key value pairs that you specify when you provision a product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters);

        /**
         * <p>
         * A list of key value pairs that you specify when you provision a product.
         * </p>
         * 
         * @param provisioningParameters
         *        A list of key value pairs that you specify when you provision a product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(ProvisioningParameter... provisioningParameters);

        /**
         * <p>
         * A list of key value pairs that you specify when you provision a product.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProvisioningParameter>.Builder} avoiding
         * the need to create one manually via {@link List<ProvisioningParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProvisioningParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link #provisioningParameters(List<ProvisioningParameter>)}.
         * 
         * @param provisioningParameters
         *        a consumer that will call methods on {@link List<ProvisioningParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningParameters(List<ProvisioningParameter>)
         */
        Builder provisioningParameters(Consumer<ProvisioningParameter.Builder>... provisioningParameters);
    }

    static final class BuilderImpl implements Builder {
        private String productId;

        private String provisioningArtifactId;

        private String pathId;

        private List<ProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceCatalogProvisioningDetails model) {
            productId(model.productId);
            provisioningArtifactId(model.provisioningArtifactId);
            pathId(model.pathId);
            provisioningParameters(model.provisioningParameters);
        }

        public final String getProductId() {
            return productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getPathId() {
            return pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final List<ProvisioningParameter.Builder> getProvisioningParameters() {
            List<ProvisioningParameter.Builder> result = ProvisioningParametersCopier.copyToBuilder(this.provisioningParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(ProvisioningParameter... provisioningParameters) {
            provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<ProvisioningParameter.Builder>... provisioningParameters) {
            provisioningParameters(Stream.of(provisioningParameters)
                    .map(c -> ProvisioningParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningParameters(Collection<ProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        @Override
        public ServiceCatalogProvisioningDetails build() {
            return new ServiceCatalogProvisioningDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
