/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAutoMlJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeAutoMlJobResponse.Builder, DescribeAutoMlJobResponse> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobName").getter(getter(DescribeAutoMlJobResponse::autoMLJobName))
            .setter(setter(Builder::autoMLJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobArn").getter(getter(DescribeAutoMlJobResponse::autoMLJobArn))
            .setter(setter(Builder::autoMLJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()).build();

    private static final SdkField<List<AutoMLChannel>> INPUT_DATA_CONFIG_FIELD = SdkField
            .<List<AutoMLChannel>> builder(MarshallingType.LIST)
            .memberName("InputDataConfig")
            .getter(getter(DescribeAutoMlJobResponse::inputDataConfig))
            .setter(setter(Builder::inputDataConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLChannel> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLChannel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoMLOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<AutoMLOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(DescribeAutoMlJobResponse::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(AutoMLOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeAutoMlJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<AutoMLJobObjective> AUTO_ML_JOB_OBJECTIVE_FIELD = SdkField
            .<AutoMLJobObjective> builder(MarshallingType.SDK_POJO).memberName("AutoMLJobObjective")
            .getter(getter(DescribeAutoMlJobResponse::autoMLJobObjective)).setter(setter(Builder::autoMLJobObjective))
            .constructor(AutoMLJobObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobObjective").build())
            .build();

    private static final SdkField<String> PROBLEM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProblemType").getter(getter(DescribeAutoMlJobResponse::problemTypeAsString))
            .setter(setter(Builder::problemType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemType").build()).build();

    private static final SdkField<AutoMLJobConfig> AUTO_ML_JOB_CONFIG_FIELD = SdkField
            .<AutoMLJobConfig> builder(MarshallingType.SDK_POJO).memberName("AutoMLJobConfig")
            .getter(getter(DescribeAutoMlJobResponse::autoMLJobConfig)).setter(setter(Builder::autoMLJobConfig))
            .constructor(AutoMLJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobConfig").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeAutoMlJobResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeAutoMlJobResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeAutoMlJobResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeAutoMlJobResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<List<AutoMLPartialFailureReason>> PARTIAL_FAILURE_REASONS_FIELD = SdkField
            .<List<AutoMLPartialFailureReason>> builder(MarshallingType.LIST)
            .memberName("PartialFailureReasons")
            .getter(getter(DescribeAutoMlJobResponse::partialFailureReasons))
            .setter(setter(Builder::partialFailureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialFailureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLPartialFailureReason> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLPartialFailureReason::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoMLCandidate> BEST_CANDIDATE_FIELD = SdkField
            .<AutoMLCandidate> builder(MarshallingType.SDK_POJO).memberName("BestCandidate")
            .getter(getter(DescribeAutoMlJobResponse::bestCandidate)).setter(setter(Builder::bestCandidate))
            .constructor(AutoMLCandidate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestCandidate").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobStatus").getter(getter(DescribeAutoMlJobResponse::autoMLJobStatusAsString))
            .setter(setter(Builder::autoMLJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobStatus").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_SECONDARY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoMLJobSecondaryStatus").getter(getter(DescribeAutoMlJobResponse::autoMLJobSecondaryStatusAsString))
            .setter(setter(Builder::autoMLJobSecondaryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobSecondaryStatus").build())
            .build();

    private static final SdkField<Boolean> GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GenerateCandidateDefinitionsOnly")
            .getter(getter(DescribeAutoMlJobResponse::generateCandidateDefinitionsOnly))
            .setter(setter(Builder::generateCandidateDefinitionsOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerateCandidateDefinitionsOnly")
                    .build()).build();

    private static final SdkField<AutoMLJobArtifacts> AUTO_ML_JOB_ARTIFACTS_FIELD = SdkField
            .<AutoMLJobArtifacts> builder(MarshallingType.SDK_POJO).memberName("AutoMLJobArtifacts")
            .getter(getter(DescribeAutoMlJobResponse::autoMLJobArtifacts)).setter(setter(Builder::autoMLJobArtifacts))
            .constructor(AutoMLJobArtifacts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArtifacts").build())
            .build();

    private static final SdkField<ResolvedAttributes> RESOLVED_ATTRIBUTES_FIELD = SdkField
            .<ResolvedAttributes> builder(MarshallingType.SDK_POJO).memberName("ResolvedAttributes")
            .getter(getter(DescribeAutoMlJobResponse::resolvedAttributes)).setter(setter(Builder::resolvedAttributes))
            .constructor(ResolvedAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD,
            AUTO_ML_JOB_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, ROLE_ARN_FIELD,
            AUTO_ML_JOB_OBJECTIVE_FIELD, PROBLEM_TYPE_FIELD, AUTO_ML_JOB_CONFIG_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, PARTIAL_FAILURE_REASONS_FIELD, BEST_CANDIDATE_FIELD,
            AUTO_ML_JOB_STATUS_FIELD, AUTO_ML_JOB_SECONDARY_STATUS_FIELD, GENERATE_CANDIDATE_DEFINITIONS_ONLY_FIELD,
            AUTO_ML_JOB_ARTIFACTS_FIELD, RESOLVED_ATTRIBUTES_FIELD));

    private final String autoMLJobName;

    private final String autoMLJobArn;

    private final List<AutoMLChannel> inputDataConfig;

    private final AutoMLOutputDataConfig outputDataConfig;

    private final String roleArn;

    private final AutoMLJobObjective autoMLJobObjective;

    private final String problemType;

    private final AutoMLJobConfig autoMLJobConfig;

    private final Instant creationTime;

    private final Instant endTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final List<AutoMLPartialFailureReason> partialFailureReasons;

    private final AutoMLCandidate bestCandidate;

    private final String autoMLJobStatus;

    private final String autoMLJobSecondaryStatus;

    private final Boolean generateCandidateDefinitionsOnly;

    private final AutoMLJobArtifacts autoMLJobArtifacts;

    private final ResolvedAttributes resolvedAttributes;

    private DescribeAutoMlJobResponse(BuilderImpl builder) {
        super(builder);
        this.autoMLJobName = builder.autoMLJobName;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.roleArn = builder.roleArn;
        this.autoMLJobObjective = builder.autoMLJobObjective;
        this.problemType = builder.problemType;
        this.autoMLJobConfig = builder.autoMLJobConfig;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.partialFailureReasons = builder.partialFailureReasons;
        this.bestCandidate = builder.bestCandidate;
        this.autoMLJobStatus = builder.autoMLJobStatus;
        this.autoMLJobSecondaryStatus = builder.autoMLJobSecondaryStatus;
        this.generateCandidateDefinitionsOnly = builder.generateCandidateDefinitionsOnly;
        this.autoMLJobArtifacts = builder.autoMLJobArtifacts;
        this.resolvedAttributes = builder.resolvedAttributes;
    }

    /**
     * <p>
     * Returns the name of the AutoML job.
     * </p>
     * 
     * @return Returns the name of the AutoML job.
     */
    public final String autoMLJobName() {
        return autoMLJobName;
    }

    /**
     * <p>
     * Returns the ARN of the AutoML job.
     * </p>
     * 
     * @return Returns the ARN of the AutoML job.
     */
    public final String autoMLJobArn() {
        return autoMLJobArn;
    }

    /**
     * Returns true if the InputDataConfig property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInputDataConfig() {
        return inputDataConfig != null && !(inputDataConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the input data configuration for the AutoML job..
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputDataConfig()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns the input data configuration for the AutoML job..
     */
    public final List<AutoMLChannel> inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Returns the job's output data config.
     * </p>
     * 
     * @return Returns the job's output data config.
     */
    public final AutoMLOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that has read permission to
     * the input data location and write permission to the output data location in Amazon S3.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that has read
     *         permission to the input data location and write permission to the output data location in Amazon S3.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Returns the job's objective.
     * </p>
     * 
     * @return Returns the job's objective.
     */
    public final AutoMLJobObjective autoMLJobObjective() {
        return autoMLJobObjective;
    }

    /**
     * <p>
     * Returns the job's problem type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #problemType} will
     * return {@link ProblemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #problemTypeAsString}.
     * </p>
     * 
     * @return Returns the job's problem type.
     * @see ProblemType
     */
    public final ProblemType problemType() {
        return ProblemType.fromValue(problemType);
    }

    /**
     * <p>
     * Returns the job's problem type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #problemType} will
     * return {@link ProblemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #problemTypeAsString}.
     * </p>
     * 
     * @return Returns the job's problem type.
     * @see ProblemType
     */
    public final String problemTypeAsString() {
        return problemType;
    }

    /**
     * <p>
     * Returns the configuration for the AutoML job.
     * </p>
     * 
     * @return Returns the configuration for the AutoML job.
     */
    public final AutoMLJobConfig autoMLJobConfig() {
        return autoMLJobConfig;
    }

    /**
     * <p>
     * Returns the creation time of the AutoML job.
     * </p>
     * 
     * @return Returns the creation time of the AutoML job.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Returns the end time of the AutoML job.
     * </p>
     * 
     * @return Returns the end time of the AutoML job.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Returns the job's last modified time.
     * </p>
     * 
     * @return Returns the job's last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Returns the job's FailureReason.
     * </p>
     * 
     * @return Returns the job's FailureReason.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * Returns true if the PartialFailureReasons property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPartialFailureReasons() {
        return partialFailureReasons != null && !(partialFailureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of reasons for partial failures within an AutoML job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPartialFailureReasons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of reasons for partial failures within an AutoML job.
     */
    public final List<AutoMLPartialFailureReason> partialFailureReasons() {
        return partialFailureReasons;
    }

    /**
     * <p>
     * Returns the job's BestCandidate.
     * </p>
     * 
     * @return Returns the job's BestCandidate.
     */
    public final AutoMLCandidate bestCandidate() {
        return bestCandidate;
    }

    /**
     * <p>
     * Returns the status of the AutoML job's AutoMLJobStatus.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoMLJobStatus}
     * will return {@link AutoMLJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoMLJobStatusAsString}.
     * </p>
     * 
     * @return Returns the status of the AutoML job's AutoMLJobStatus.
     * @see AutoMLJobStatus
     */
    public final AutoMLJobStatus autoMLJobStatus() {
        return AutoMLJobStatus.fromValue(autoMLJobStatus);
    }

    /**
     * <p>
     * Returns the status of the AutoML job's AutoMLJobStatus.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoMLJobStatus}
     * will return {@link AutoMLJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoMLJobStatusAsString}.
     * </p>
     * 
     * @return Returns the status of the AutoML job's AutoMLJobStatus.
     * @see AutoMLJobStatus
     */
    public final String autoMLJobStatusAsString() {
        return autoMLJobStatus;
    }

    /**
     * <p>
     * Returns the secondary status of the AutoML job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLJobSecondaryStatus} will return {@link AutoMLJobSecondaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoMLJobSecondaryStatusAsString}.
     * </p>
     * 
     * @return Returns the secondary status of the AutoML job.
     * @see AutoMLJobSecondaryStatus
     */
    public final AutoMLJobSecondaryStatus autoMLJobSecondaryStatus() {
        return AutoMLJobSecondaryStatus.fromValue(autoMLJobSecondaryStatus);
    }

    /**
     * <p>
     * Returns the secondary status of the AutoML job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLJobSecondaryStatus} will return {@link AutoMLJobSecondaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoMLJobSecondaryStatusAsString}.
     * </p>
     * 
     * @return Returns the secondary status of the AutoML job.
     * @see AutoMLJobSecondaryStatus
     */
    public final String autoMLJobSecondaryStatusAsString() {
        return autoMLJobSecondaryStatus;
    }

    /**
     * <p>
     * Returns the job's output from GenerateCandidateDefinitionsOnly.
     * </p>
     * 
     * @return Returns the job's output from GenerateCandidateDefinitionsOnly.
     */
    public final Boolean generateCandidateDefinitionsOnly() {
        return generateCandidateDefinitionsOnly;
    }

    /**
     * <p>
     * Returns information on the job's artifacts found in AutoMLJobArtifacts.
     * </p>
     * 
     * @return Returns information on the job's artifacts found in AutoMLJobArtifacts.
     */
    public final AutoMLJobArtifacts autoMLJobArtifacts() {
        return autoMLJobArtifacts;
    }

    /**
     * <p>
     * This contains ProblemType, AutoMLJobObjective and CompletionCriteria. If you do not provide these values, they
     * are auto-inferred. If you do provide them, they are the values you provide.
     * </p>
     * 
     * @return This contains ProblemType, AutoMLJobObjective and CompletionCriteria. If you do not provide these values,
     *         they are auto-inferred. If you do provide them, they are the values you provide.
     */
    public final ResolvedAttributes resolvedAttributes() {
        return resolvedAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDataConfig() ? inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobObjective());
        hashCode = 31 * hashCode + Objects.hashCode(problemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartialFailureReasons() ? partialFailureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(bestCandidate());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobSecondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(generateCandidateDefinitionsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoMlJobResponse)) {
            return false;
        }
        DescribeAutoMlJobResponse other = (DescribeAutoMlJobResponse) obj;
        return Objects.equals(autoMLJobName(), other.autoMLJobName()) && Objects.equals(autoMLJobArn(), other.autoMLJobArn())
                && hasInputDataConfig() == other.hasInputDataConfig()
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(autoMLJobObjective(), other.autoMLJobObjective())
                && Objects.equals(problemTypeAsString(), other.problemTypeAsString())
                && Objects.equals(autoMLJobConfig(), other.autoMLJobConfig())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason())
                && hasPartialFailureReasons() == other.hasPartialFailureReasons()
                && Objects.equals(partialFailureReasons(), other.partialFailureReasons())
                && Objects.equals(bestCandidate(), other.bestCandidate())
                && Objects.equals(autoMLJobStatusAsString(), other.autoMLJobStatusAsString())
                && Objects.equals(autoMLJobSecondaryStatusAsString(), other.autoMLJobSecondaryStatusAsString())
                && Objects.equals(generateCandidateDefinitionsOnly(), other.generateCandidateDefinitionsOnly())
                && Objects.equals(autoMLJobArtifacts(), other.autoMLJobArtifacts())
                && Objects.equals(resolvedAttributes(), other.resolvedAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAutoMlJobResponse").add("AutoMLJobName", autoMLJobName())
                .add("AutoMLJobArn", autoMLJobArn()).add("InputDataConfig", hasInputDataConfig() ? inputDataConfig() : null)
                .add("OutputDataConfig", outputDataConfig()).add("RoleArn", roleArn())
                .add("AutoMLJobObjective", autoMLJobObjective()).add("ProblemType", problemTypeAsString())
                .add("AutoMLJobConfig", autoMLJobConfig()).add("CreationTime", creationTime()).add("EndTime", endTime())
                .add("LastModifiedTime", lastModifiedTime()).add("FailureReason", failureReason())
                .add("PartialFailureReasons", hasPartialFailureReasons() ? partialFailureReasons() : null)
                .add("BestCandidate", bestCandidate()).add("AutoMLJobStatus", autoMLJobStatusAsString())
                .add("AutoMLJobSecondaryStatus", autoMLJobSecondaryStatusAsString())
                .add("GenerateCandidateDefinitionsOnly", generateCandidateDefinitionsOnly())
                .add("AutoMLJobArtifacts", autoMLJobArtifacts()).add("ResolvedAttributes", resolvedAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMLJobName":
            return Optional.ofNullable(clazz.cast(autoMLJobName()));
        case "AutoMLJobArn":
            return Optional.ofNullable(clazz.cast(autoMLJobArn()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "AutoMLJobObjective":
            return Optional.ofNullable(clazz.cast(autoMLJobObjective()));
        case "ProblemType":
            return Optional.ofNullable(clazz.cast(problemTypeAsString()));
        case "AutoMLJobConfig":
            return Optional.ofNullable(clazz.cast(autoMLJobConfig()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "PartialFailureReasons":
            return Optional.ofNullable(clazz.cast(partialFailureReasons()));
        case "BestCandidate":
            return Optional.ofNullable(clazz.cast(bestCandidate()));
        case "AutoMLJobStatus":
            return Optional.ofNullable(clazz.cast(autoMLJobStatusAsString()));
        case "AutoMLJobSecondaryStatus":
            return Optional.ofNullable(clazz.cast(autoMLJobSecondaryStatusAsString()));
        case "GenerateCandidateDefinitionsOnly":
            return Optional.ofNullable(clazz.cast(generateCandidateDefinitionsOnly()));
        case "AutoMLJobArtifacts":
            return Optional.ofNullable(clazz.cast(autoMLJobArtifacts()));
        case "ResolvedAttributes":
            return Optional.ofNullable(clazz.cast(resolvedAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoMlJobResponse, T> g) {
        return obj -> g.apply((DescribeAutoMlJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAutoMlJobResponse> {
        /**
         * <p>
         * Returns the name of the AutoML job.
         * </p>
         * 
         * @param autoMLJobName
         *        Returns the name of the AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobName(String autoMLJobName);

        /**
         * <p>
         * Returns the ARN of the AutoML job.
         * </p>
         * 
         * @param autoMLJobArn
         *        Returns the ARN of the AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobArn(String autoMLJobArn);

        /**
         * <p>
         * Returns the input data configuration for the AutoML job..
         * </p>
         * 
         * @param inputDataConfig
         *        Returns the input data configuration for the AutoML job..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Collection<AutoMLChannel> inputDataConfig);

        /**
         * <p>
         * Returns the input data configuration for the AutoML job..
         * </p>
         * 
         * @param inputDataConfig
         *        Returns the input data configuration for the AutoML job..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(AutoMLChannel... inputDataConfig);

        /**
         * <p>
         * Returns the input data configuration for the AutoML job..
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoMLChannel>.Builder} avoiding the need
         * to create one manually via {@link List<AutoMLChannel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoMLChannel>.Builder#build()} is called immediately and
         * its result is passed to {@link #inputDataConfig(List<AutoMLChannel>)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link List<AutoMLChannel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(List<AutoMLChannel>)
         */
        Builder inputDataConfig(Consumer<AutoMLChannel.Builder>... inputDataConfig);

        /**
         * <p>
         * Returns the job's output data config.
         * </p>
         * 
         * @param outputDataConfig
         *        Returns the job's output data config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig);

        /**
         * <p>
         * Returns the job's output data config.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoMLOutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link AutoMLOutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLOutputDataConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #outputDataConfig(AutoMLOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link AutoMLOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(AutoMLOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<AutoMLOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(AutoMLOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that has read permission
         * to the input data location and write permission to the output data location in Amazon S3.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that has read
         *        permission to the input data location and write permission to the output data location in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Returns the job's objective.
         * </p>
         * 
         * @param autoMLJobObjective
         *        Returns the job's objective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective);

        /**
         * <p>
         * Returns the job's objective.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoMLJobObjective.Builder} avoiding the need to
         * create one manually via {@link AutoMLJobObjective#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLJobObjective.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLJobObjective(AutoMLJobObjective)}.
         * 
         * @param autoMLJobObjective
         *        a consumer that will call methods on {@link AutoMLJobObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobObjective(AutoMLJobObjective)
         */
        default Builder autoMLJobObjective(Consumer<AutoMLJobObjective.Builder> autoMLJobObjective) {
            return autoMLJobObjective(AutoMLJobObjective.builder().applyMutation(autoMLJobObjective).build());
        }

        /**
         * <p>
         * Returns the job's problem type.
         * </p>
         * 
         * @param problemType
         *        Returns the job's problem type.
         * @see ProblemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProblemType
         */
        Builder problemType(String problemType);

        /**
         * <p>
         * Returns the job's problem type.
         * </p>
         * 
         * @param problemType
         *        Returns the job's problem type.
         * @see ProblemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProblemType
         */
        Builder problemType(ProblemType problemType);

        /**
         * <p>
         * Returns the configuration for the AutoML job.
         * </p>
         * 
         * @param autoMLJobConfig
         *        Returns the configuration for the AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobConfig(AutoMLJobConfig autoMLJobConfig);

        /**
         * <p>
         * Returns the configuration for the AutoML job.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoMLJobConfig.Builder} avoiding the need to
         * create one manually via {@link AutoMLJobConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLJobConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLJobConfig(AutoMLJobConfig)}.
         * 
         * @param autoMLJobConfig
         *        a consumer that will call methods on {@link AutoMLJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobConfig(AutoMLJobConfig)
         */
        default Builder autoMLJobConfig(Consumer<AutoMLJobConfig.Builder> autoMLJobConfig) {
            return autoMLJobConfig(AutoMLJobConfig.builder().applyMutation(autoMLJobConfig).build());
        }

        /**
         * <p>
         * Returns the creation time of the AutoML job.
         * </p>
         * 
         * @param creationTime
         *        Returns the creation time of the AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Returns the end time of the AutoML job.
         * </p>
         * 
         * @param endTime
         *        Returns the end time of the AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Returns the job's last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        Returns the job's last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Returns the job's FailureReason.
         * </p>
         * 
         * @param failureReason
         *        Returns the job's FailureReason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Returns a list of reasons for partial failures within an AutoML job.
         * </p>
         * 
         * @param partialFailureReasons
         *        Returns a list of reasons for partial failures within an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partialFailureReasons(Collection<AutoMLPartialFailureReason> partialFailureReasons);

        /**
         * <p>
         * Returns a list of reasons for partial failures within an AutoML job.
         * </p>
         * 
         * @param partialFailureReasons
         *        Returns a list of reasons for partial failures within an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partialFailureReasons(AutoMLPartialFailureReason... partialFailureReasons);

        /**
         * <p>
         * Returns a list of reasons for partial failures within an AutoML job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoMLPartialFailureReason>.Builder}
         * avoiding the need to create one manually via {@link List<AutoMLPartialFailureReason>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoMLPartialFailureReason>.Builder#build()} is called
         * immediately and its result is passed to {@link #partialFailureReasons(List<AutoMLPartialFailureReason>)}.
         * 
         * @param partialFailureReasons
         *        a consumer that will call methods on {@link List<AutoMLPartialFailureReason>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partialFailureReasons(List<AutoMLPartialFailureReason>)
         */
        Builder partialFailureReasons(Consumer<AutoMLPartialFailureReason.Builder>... partialFailureReasons);

        /**
         * <p>
         * Returns the job's BestCandidate.
         * </p>
         * 
         * @param bestCandidate
         *        Returns the job's BestCandidate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestCandidate(AutoMLCandidate bestCandidate);

        /**
         * <p>
         * Returns the job's BestCandidate.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoMLCandidate.Builder} avoiding the need to
         * create one manually via {@link AutoMLCandidate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLCandidate.Builder#build()} is called immediately and its
         * result is passed to {@link #bestCandidate(AutoMLCandidate)}.
         * 
         * @param bestCandidate
         *        a consumer that will call methods on {@link AutoMLCandidate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bestCandidate(AutoMLCandidate)
         */
        default Builder bestCandidate(Consumer<AutoMLCandidate.Builder> bestCandidate) {
            return bestCandidate(AutoMLCandidate.builder().applyMutation(bestCandidate).build());
        }

        /**
         * <p>
         * Returns the status of the AutoML job's AutoMLJobStatus.
         * </p>
         * 
         * @param autoMLJobStatus
         *        Returns the status of the AutoML job's AutoMLJobStatus.
         * @see AutoMLJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobStatus
         */
        Builder autoMLJobStatus(String autoMLJobStatus);

        /**
         * <p>
         * Returns the status of the AutoML job's AutoMLJobStatus.
         * </p>
         * 
         * @param autoMLJobStatus
         *        Returns the status of the AutoML job's AutoMLJobStatus.
         * @see AutoMLJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobStatus
         */
        Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus);

        /**
         * <p>
         * Returns the secondary status of the AutoML job.
         * </p>
         * 
         * @param autoMLJobSecondaryStatus
         *        Returns the secondary status of the AutoML job.
         * @see AutoMLJobSecondaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobSecondaryStatus
         */
        Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus);

        /**
         * <p>
         * Returns the secondary status of the AutoML job.
         * </p>
         * 
         * @param autoMLJobSecondaryStatus
         *        Returns the secondary status of the AutoML job.
         * @see AutoMLJobSecondaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobSecondaryStatus
         */
        Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus);

        /**
         * <p>
         * Returns the job's output from GenerateCandidateDefinitionsOnly.
         * </p>
         * 
         * @param generateCandidateDefinitionsOnly
         *        Returns the job's output from GenerateCandidateDefinitionsOnly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly);

        /**
         * <p>
         * Returns information on the job's artifacts found in AutoMLJobArtifacts.
         * </p>
         * 
         * @param autoMLJobArtifacts
         *        Returns information on the job's artifacts found in AutoMLJobArtifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobArtifacts(AutoMLJobArtifacts autoMLJobArtifacts);

        /**
         * <p>
         * Returns information on the job's artifacts found in AutoMLJobArtifacts.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoMLJobArtifacts.Builder} avoiding the need to
         * create one manually via {@link AutoMLJobArtifacts#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLJobArtifacts.Builder#build()} is called immediately and its
         * result is passed to {@link #autoMLJobArtifacts(AutoMLJobArtifacts)}.
         * 
         * @param autoMLJobArtifacts
         *        a consumer that will call methods on {@link AutoMLJobArtifacts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMLJobArtifacts(AutoMLJobArtifacts)
         */
        default Builder autoMLJobArtifacts(Consumer<AutoMLJobArtifacts.Builder> autoMLJobArtifacts) {
            return autoMLJobArtifacts(AutoMLJobArtifacts.builder().applyMutation(autoMLJobArtifacts).build());
        }

        /**
         * <p>
         * This contains ProblemType, AutoMLJobObjective and CompletionCriteria. If you do not provide these values,
         * they are auto-inferred. If you do provide them, they are the values you provide.
         * </p>
         * 
         * @param resolvedAttributes
         *        This contains ProblemType, AutoMLJobObjective and CompletionCriteria. If you do not provide these
         *        values, they are auto-inferred. If you do provide them, they are the values you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedAttributes(ResolvedAttributes resolvedAttributes);

        /**
         * <p>
         * This contains ProblemType, AutoMLJobObjective and CompletionCriteria. If you do not provide these values,
         * they are auto-inferred. If you do provide them, they are the values you provide.
         * </p>
         * This is a convenience that creates an instance of the {@link ResolvedAttributes.Builder} avoiding the need to
         * create one manually via {@link ResolvedAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResolvedAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #resolvedAttributes(ResolvedAttributes)}.
         * 
         * @param resolvedAttributes
         *        a consumer that will call methods on {@link ResolvedAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolvedAttributes(ResolvedAttributes)
         */
        default Builder resolvedAttributes(Consumer<ResolvedAttributes.Builder> resolvedAttributes) {
            return resolvedAttributes(ResolvedAttributes.builder().applyMutation(resolvedAttributes).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String autoMLJobName;

        private String autoMLJobArn;

        private List<AutoMLChannel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();

        private AutoMLOutputDataConfig outputDataConfig;

        private String roleArn;

        private AutoMLJobObjective autoMLJobObjective;

        private String problemType;

        private AutoMLJobConfig autoMLJobConfig;

        private Instant creationTime;

        private Instant endTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private List<AutoMLPartialFailureReason> partialFailureReasons = DefaultSdkAutoConstructList.getInstance();

        private AutoMLCandidate bestCandidate;

        private String autoMLJobStatus;

        private String autoMLJobSecondaryStatus;

        private Boolean generateCandidateDefinitionsOnly;

        private AutoMLJobArtifacts autoMLJobArtifacts;

        private ResolvedAttributes resolvedAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoMlJobResponse model) {
            super(model);
            autoMLJobName(model.autoMLJobName);
            autoMLJobArn(model.autoMLJobArn);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            roleArn(model.roleArn);
            autoMLJobObjective(model.autoMLJobObjective);
            problemType(model.problemType);
            autoMLJobConfig(model.autoMLJobConfig);
            creationTime(model.creationTime);
            endTime(model.endTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            partialFailureReasons(model.partialFailureReasons);
            bestCandidate(model.bestCandidate);
            autoMLJobStatus(model.autoMLJobStatus);
            autoMLJobSecondaryStatus(model.autoMLJobSecondaryStatus);
            generateCandidateDefinitionsOnly(model.generateCandidateDefinitionsOnly);
            autoMLJobArtifacts(model.autoMLJobArtifacts);
            resolvedAttributes(model.resolvedAttributes);
        }

        public final String getAutoMLJobName() {
            return autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        public final String getAutoMLJobArn() {
            return autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        public final List<AutoMLChannel.Builder> getInputDataConfig() {
            List<AutoMLChannel.Builder> result = AutoMLInputDataConfigCopier.copyToBuilder(this.inputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder inputDataConfig(Collection<AutoMLChannel> inputDataConfig) {
            this.inputDataConfig = AutoMLInputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(AutoMLChannel... inputDataConfig) {
            inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<AutoMLChannel.Builder>... inputDataConfig) {
            inputDataConfig(Stream.of(inputDataConfig).map(c -> AutoMLChannel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<AutoMLChannel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = AutoMLInputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final AutoMLOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(AutoMLOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(AutoMLOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final AutoMLJobObjective.Builder getAutoMLJobObjective() {
            return autoMLJobObjective != null ? autoMLJobObjective.toBuilder() : null;
        }

        @Override
        public final Builder autoMLJobObjective(AutoMLJobObjective autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective;
            return this;
        }

        public final void setAutoMLJobObjective(AutoMLJobObjective.BuilderImpl autoMLJobObjective) {
            this.autoMLJobObjective = autoMLJobObjective != null ? autoMLJobObjective.build() : null;
        }

        public final String getProblemType() {
            return problemType;
        }

        @Override
        public final Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        @Override
        public final Builder problemType(ProblemType problemType) {
            this.problemType(problemType == null ? null : problemType.toString());
            return this;
        }

        public final void setProblemType(String problemType) {
            this.problemType = problemType;
        }

        public final AutoMLJobConfig.Builder getAutoMLJobConfig() {
            return autoMLJobConfig != null ? autoMLJobConfig.toBuilder() : null;
        }

        @Override
        public final Builder autoMLJobConfig(AutoMLJobConfig autoMLJobConfig) {
            this.autoMLJobConfig = autoMLJobConfig;
            return this;
        }

        public final void setAutoMLJobConfig(AutoMLJobConfig.BuilderImpl autoMLJobConfig) {
            this.autoMLJobConfig = autoMLJobConfig != null ? autoMLJobConfig.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final List<AutoMLPartialFailureReason.Builder> getPartialFailureReasons() {
            List<AutoMLPartialFailureReason.Builder> result = AutoMLPartialFailureReasonsCopier
                    .copyToBuilder(this.partialFailureReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder partialFailureReasons(Collection<AutoMLPartialFailureReason> partialFailureReasons) {
            this.partialFailureReasons = AutoMLPartialFailureReasonsCopier.copy(partialFailureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialFailureReasons(AutoMLPartialFailureReason... partialFailureReasons) {
            partialFailureReasons(Arrays.asList(partialFailureReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partialFailureReasons(Consumer<AutoMLPartialFailureReason.Builder>... partialFailureReasons) {
            partialFailureReasons(Stream.of(partialFailureReasons)
                    .map(c -> AutoMLPartialFailureReason.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartialFailureReasons(Collection<AutoMLPartialFailureReason.BuilderImpl> partialFailureReasons) {
            this.partialFailureReasons = AutoMLPartialFailureReasonsCopier.copyFromBuilder(partialFailureReasons);
        }

        public final AutoMLCandidate.Builder getBestCandidate() {
            return bestCandidate != null ? bestCandidate.toBuilder() : null;
        }

        @Override
        public final Builder bestCandidate(AutoMLCandidate bestCandidate) {
            this.bestCandidate = bestCandidate;
            return this;
        }

        public final void setBestCandidate(AutoMLCandidate.BuilderImpl bestCandidate) {
            this.bestCandidate = bestCandidate != null ? bestCandidate.build() : null;
        }

        public final String getAutoMLJobStatus() {
            return autoMLJobStatus;
        }

        @Override
        public final Builder autoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus) {
            this.autoMLJobStatus(autoMLJobStatus == null ? null : autoMLJobStatus.toString());
            return this;
        }

        public final void setAutoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
        }

        public final String getAutoMLJobSecondaryStatus() {
            return autoMLJobSecondaryStatus;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus(autoMLJobSecondaryStatus == null ? null : autoMLJobSecondaryStatus.toString());
            return this;
        }

        public final void setAutoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
        }

        public final Boolean getGenerateCandidateDefinitionsOnly() {
            return generateCandidateDefinitionsOnly;
        }

        @Override
        public final Builder generateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
            this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
            return this;
        }

        public final void setGenerateCandidateDefinitionsOnly(Boolean generateCandidateDefinitionsOnly) {
            this.generateCandidateDefinitionsOnly = generateCandidateDefinitionsOnly;
        }

        public final AutoMLJobArtifacts.Builder getAutoMLJobArtifacts() {
            return autoMLJobArtifacts != null ? autoMLJobArtifacts.toBuilder() : null;
        }

        @Override
        public final Builder autoMLJobArtifacts(AutoMLJobArtifacts autoMLJobArtifacts) {
            this.autoMLJobArtifacts = autoMLJobArtifacts;
            return this;
        }

        public final void setAutoMLJobArtifacts(AutoMLJobArtifacts.BuilderImpl autoMLJobArtifacts) {
            this.autoMLJobArtifacts = autoMLJobArtifacts != null ? autoMLJobArtifacts.build() : null;
        }

        public final ResolvedAttributes.Builder getResolvedAttributes() {
            return resolvedAttributes != null ? resolvedAttributes.toBuilder() : null;
        }

        @Override
        public final Builder resolvedAttributes(ResolvedAttributes resolvedAttributes) {
            this.resolvedAttributes = resolvedAttributes;
            return this;
        }

        public final void setResolvedAttributes(ResolvedAttributes.BuilderImpl resolvedAttributes) {
            this.resolvedAttributes = resolvedAttributes != null ? resolvedAttributes.build() : null;
        }

        @Override
        public DescribeAutoMlJobResponse build() {
            return new DescribeAutoMlJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
