/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EdgeOutputConfig.Builder, EdgeOutputConfig> {
    private static final SdkField<String> S3_OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3OutputLocation").getter(getter(EdgeOutputConfig::s3OutputLocation))
            .setter(setter(Builder::s3OutputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputLocation").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(EdgeOutputConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_LOCATION_FIELD,
            KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3OutputLocation;

    private final String kmsKeyId;

    private EdgeOutputConfig(BuilderImpl builder) {
        this.s3OutputLocation = builder.s3OutputLocation;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Simple Storage (S3) bucker URI.
     * </p>
     * 
     * @return The Amazon Simple Storage (S3) bucker URI.
     */
    public final String s3OutputLocation() {
        return s3OutputLocation;
    }

    /**
     * <p>
     * The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume
     * after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3
     * for your role's account.
     * </p>
     * 
     * @return The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage
     *         volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS
     *         key for Amazon S3 for your role's account.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeOutputConfig)) {
            return false;
        }
        EdgeOutputConfig other = (EdgeOutputConfig) obj;
        return Objects.equals(s3OutputLocation(), other.s3OutputLocation()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeOutputConfig").add("S3OutputLocation", s3OutputLocation()).add("KmsKeyId", kmsKeyId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3OutputLocation":
            return Optional.ofNullable(clazz.cast(s3OutputLocation()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgeOutputConfig, T> g) {
        return obj -> g.apply((EdgeOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeOutputConfig> {
        /**
         * <p>
         * The Amazon Simple Storage (S3) bucker URI.
         * </p>
         * 
         * @param s3OutputLocation
         *        The Amazon Simple Storage (S3) bucker URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputLocation(String s3OutputLocation);

        /**
         * <p>
         * The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume
         * after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for
         * Amazon S3 for your role's account.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage
         *        volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS
         *        key for Amazon S3 for your role's account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String s3OutputLocation;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeOutputConfig model) {
            s3OutputLocation(model.s3OutputLocation);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getS3OutputLocation() {
            return s3OutputLocation;
        }

        @Override
        public final Builder s3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        public final void setS3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public EdgeOutputConfig build() {
            return new EdgeOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
