/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The security configuration for <code>OnlineStore</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnlineStoreSecurityConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OnlineStoreSecurityConfig.Builder, OnlineStoreSecurityConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(OnlineStoreSecurityConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private OnlineStoreSecurityConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3
     * objects at rest using Amazon S3 server-side encryption.
     * </p>
     * <p>
     * The caller (either IAM user or IAM role) of <code>CreateFeatureGroup</code> must have below permissions to the
     * <code>OnlineStore</code> <code>KmsKeyId</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"kms:Encrypt"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"kms:Decrypt"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"kms:DescribeKey"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"kms:CreateGrant"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"kms:RetireGrant"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"kms:ReEncryptFrom"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"kms:ReEncryptTo"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"kms:GenerateDataKey"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"kms:ListAliases"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"kms:ListGrants"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"kms:RevokeGrant"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The caller (either IAM user or IAM role) to all DataPlane operations (<code>PutRecord</code>,
     * <code>GetRecord</code>, <code>DeleteRecord</code>) must have the following permissions to the
     * <code>KmsKeyId</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"kms:Decrypt"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the
     *         Amazon S3 objects at rest using Amazon S3 server-side encryption.</p>
     *         <p>
     *         The caller (either IAM user or IAM role) of <code>CreateFeatureGroup</code> must have below permissions
     *         to the <code>OnlineStore</code> <code>KmsKeyId</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"kms:Encrypt"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"kms:Decrypt"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"kms:DescribeKey"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"kms:CreateGrant"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"kms:RetireGrant"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"kms:ReEncryptFrom"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"kms:ReEncryptTo"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"kms:GenerateDataKey"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"kms:ListAliases"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"kms:ListGrants"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"kms:RevokeGrant"</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The caller (either IAM user or IAM role) to all DataPlane operations (<code>PutRecord</code>,
     *         <code>GetRecord</code>, <code>DeleteRecord</code>) must have the following permissions to the
     *         <code>KmsKeyId</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"kms:Decrypt"</code>
     *         </p>
     *         </li>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnlineStoreSecurityConfig)) {
            return false;
        }
        OnlineStoreSecurityConfig other = (OnlineStoreSecurityConfig) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnlineStoreSecurityConfig").add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnlineStoreSecurityConfig, T> g) {
        return obj -> g.apply((OnlineStoreSecurityConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnlineStoreSecurityConfig> {
        /**
         * <p>
         * The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the
         * Amazon S3 objects at rest using Amazon S3 server-side encryption.
         * </p>
         * <p>
         * The caller (either IAM user or IAM role) of <code>CreateFeatureGroup</code> must have below permissions to
         * the <code>OnlineStore</code> <code>KmsKeyId</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"kms:Encrypt"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"kms:Decrypt"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"kms:DescribeKey"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"kms:CreateGrant"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"kms:RetireGrant"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"kms:ReEncryptFrom"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"kms:ReEncryptTo"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"kms:GenerateDataKey"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"kms:ListAliases"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"kms:ListGrants"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"kms:RevokeGrant"</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The caller (either IAM user or IAM role) to all DataPlane operations (<code>PutRecord</code>,
         * <code>GetRecord</code>, <code>DeleteRecord</code>) must have the following permissions to the
         * <code>KmsKeyId</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"kms:Decrypt"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyId
         *        The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt
         *        the Amazon S3 objects at rest using Amazon S3 server-side encryption.</p>
         *        <p>
         *        The caller (either IAM user or IAM role) of <code>CreateFeatureGroup</code> must have below
         *        permissions to the <code>OnlineStore</code> <code>KmsKeyId</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"kms:Encrypt"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"kms:Decrypt"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"kms:DescribeKey"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"kms:CreateGrant"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"kms:RetireGrant"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"kms:ReEncryptFrom"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"kms:ReEncryptTo"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"kms:GenerateDataKey"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"kms:ListAliases"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"kms:ListGrants"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"kms:RevokeGrant"</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The caller (either IAM user or IAM role) to all DataPlane operations (<code>PutRecord</code>,
         *        <code>GetRecord</code>, <code>DeleteRecord</code>) must have the following permissions to the
         *        <code>KmsKeyId</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"kms:Decrypt"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(OnlineStoreSecurityConfig model) {
            kmsKeyId(model.kmsKeyId);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public OnlineStoreSecurityConfig build() {
            return new OnlineStoreSecurityConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
