/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the metrics of a trial component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialComponentMetricSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrialComponentMetricSummary.Builder, TrialComponentMetricSummary> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(TrialComponentMetricSummary::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(TrialComponentMetricSummary::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<Instant> TIME_STAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TimeStamp").getter(getter(TrialComponentMetricSummary::timeStamp)).setter(setter(Builder::timeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeStamp").build()).build();

    private static final SdkField<Double> MAX_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Max")
            .getter(getter(TrialComponentMetricSummary::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final SdkField<Double> MIN_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Min")
            .getter(getter(TrialComponentMetricSummary::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Min").build()).build();

    private static final SdkField<Double> LAST_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Last")
            .getter(getter(TrialComponentMetricSummary::last)).setter(setter(Builder::last))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Last").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(TrialComponentMetricSummary::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Double> AVG_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Avg")
            .getter(getter(TrialComponentMetricSummary::avg)).setter(setter(Builder::avg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Avg").build()).build();

    private static final SdkField<Double> STD_DEV_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("StdDev")
            .getter(getter(TrialComponentMetricSummary::stdDev)).setter(setter(Builder::stdDev))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StdDev").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            SOURCE_ARN_FIELD, TIME_STAMP_FIELD, MAX_FIELD, MIN_FIELD, LAST_FIELD, COUNT_FIELD, AVG_FIELD, STD_DEV_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String sourceArn;

    private final Instant timeStamp;

    private final Double max;

    private final Double min;

    private final Double last;

    private final Integer count;

    private final Double avg;

    private final Double stdDev;

    private TrialComponentMetricSummary(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.sourceArn = builder.sourceArn;
        this.timeStamp = builder.timeStamp;
        this.max = builder.max;
        this.min = builder.min;
        this.last = builder.last;
        this.count = builder.count;
        this.avg = builder.avg;
        this.stdDev = builder.stdDev;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * When the metric was last updated.
     * </p>
     * 
     * @return When the metric was last updated.
     */
    public final Instant timeStamp() {
        return timeStamp;
    }

    /**
     * <p>
     * The maximum value of the metric.
     * </p>
     * 
     * @return The maximum value of the metric.
     */
    public final Double max() {
        return max;
    }

    /**
     * <p>
     * The minimum value of the metric.
     * </p>
     * 
     * @return The minimum value of the metric.
     */
    public final Double min() {
        return min;
    }

    /**
     * <p>
     * The most recent value of the metric.
     * </p>
     * 
     * @return The most recent value of the metric.
     */
    public final Double last() {
        return last;
    }

    /**
     * <p>
     * The number of samples used to generate the metric.
     * </p>
     * 
     * @return The number of samples used to generate the metric.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The average value of the metric.
     * </p>
     * 
     * @return The average value of the metric.
     */
    public final Double avg() {
        return avg;
    }

    /**
     * <p>
     * The standard deviation of the metric.
     * </p>
     * 
     * @return The standard deviation of the metric.
     */
    public final Double stdDev() {
        return stdDev;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(timeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(last());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(avg());
        hashCode = 31 * hashCode + Objects.hashCode(stdDev());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentMetricSummary)) {
            return false;
        }
        TrialComponentMetricSummary other = (TrialComponentMetricSummary) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(timeStamp(), other.timeStamp()) && Objects.equals(max(), other.max())
                && Objects.equals(min(), other.min()) && Objects.equals(last(), other.last())
                && Objects.equals(count(), other.count()) && Objects.equals(avg(), other.avg())
                && Objects.equals(stdDev(), other.stdDev());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrialComponentMetricSummary").add("MetricName", metricName()).add("SourceArn", sourceArn())
                .add("TimeStamp", timeStamp()).add("Max", max()).add("Min", min()).add("Last", last()).add("Count", count())
                .add("Avg", avg()).add("StdDev", stdDev()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "TimeStamp":
            return Optional.ofNullable(clazz.cast(timeStamp()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        case "Min":
            return Optional.ofNullable(clazz.cast(min()));
        case "Last":
            return Optional.ofNullable(clazz.cast(last()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "Avg":
            return Optional.ofNullable(clazz.cast(avg()));
        case "StdDev":
            return Optional.ofNullable(clazz.cast(stdDev()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentMetricSummary, T> g) {
        return obj -> g.apply((TrialComponentMetricSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialComponentMetricSummary> {
        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * When the metric was last updated.
         * </p>
         * 
         * @param timeStamp
         *        When the metric was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeStamp(Instant timeStamp);

        /**
         * <p>
         * The maximum value of the metric.
         * </p>
         * 
         * @param max
         *        The maximum value of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Double max);

        /**
         * <p>
         * The minimum value of the metric.
         * </p>
         * 
         * @param min
         *        The minimum value of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Double min);

        /**
         * <p>
         * The most recent value of the metric.
         * </p>
         * 
         * @param last
         *        The most recent value of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder last(Double last);

        /**
         * <p>
         * The number of samples used to generate the metric.
         * </p>
         * 
         * @param count
         *        The number of samples used to generate the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The average value of the metric.
         * </p>
         * 
         * @param avg
         *        The average value of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avg(Double avg);

        /**
         * <p>
         * The standard deviation of the metric.
         * </p>
         * 
         * @param stdDev
         *        The standard deviation of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stdDev(Double stdDev);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String sourceArn;

        private Instant timeStamp;

        private Double max;

        private Double min;

        private Double last;

        private Integer count;

        private Double avg;

        private Double stdDev;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentMetricSummary model) {
            metricName(model.metricName);
            sourceArn(model.sourceArn);
            timeStamp(model.timeStamp);
            max(model.max);
            min(model.min);
            last(model.last);
            count(model.count);
            avg(model.avg);
            stdDev(model.stdDev);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final Instant getTimeStamp() {
            return timeStamp;
        }

        @Override
        public final Builder timeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public final void setTimeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
        }

        public final Double getMax() {
            return max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        public final Double getMin() {
            return min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        public final Double getLast() {
            return last;
        }

        @Override
        public final Builder last(Double last) {
            this.last = last;
            return this;
        }

        public final void setLast(Double last) {
            this.last = last;
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Double getAvg() {
            return avg;
        }

        @Override
        public final Builder avg(Double avg) {
            this.avg = avg;
            return this;
        }

        public final void setAvg(Double avg) {
            this.avg = avg;
        }

        public final Double getStdDev() {
            return stdDev;
        }

        @Override
        public final Builder stdDev(Double stdDev) {
            this.stdDev = stdDev;
            return this;
        }

        public final void setStdDev(Double stdDev) {
            this.stdDev = stdDev;
        }

        @Override
        public TrialComponentMetricSummary build() {
            return new TrialComponentMetricSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
