/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelExplainabilityJobDefinitionRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateModelExplainabilityJobDefinitionRequest.Builder, CreateModelExplainabilityJobDefinitionRequest> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDefinitionName").getter(getter(CreateModelExplainabilityJobDefinitionRequest::jobDefinitionName))
            .setter(setter(Builder::jobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()).build();

    private static final SdkField<ModelExplainabilityBaselineConfig> MODEL_EXPLAINABILITY_BASELINE_CONFIG_FIELD = SdkField
            .<ModelExplainabilityBaselineConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ModelExplainabilityBaselineConfig")
            .getter(getter(CreateModelExplainabilityJobDefinitionRequest::modelExplainabilityBaselineConfig))
            .setter(setter(Builder::modelExplainabilityBaselineConfig))
            .constructor(ModelExplainabilityBaselineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelExplainabilityBaselineConfig")
                    .build()).build();

    private static final SdkField<ModelExplainabilityAppSpecification> MODEL_EXPLAINABILITY_APP_SPECIFICATION_FIELD = SdkField
            .<ModelExplainabilityAppSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("ModelExplainabilityAppSpecification")
            .getter(getter(CreateModelExplainabilityJobDefinitionRequest::modelExplainabilityAppSpecification))
            .setter(setter(Builder::modelExplainabilityAppSpecification))
            .constructor(ModelExplainabilityAppSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ModelExplainabilityAppSpecification").build()).build();

    private static final SdkField<ModelExplainabilityJobInput> MODEL_EXPLAINABILITY_JOB_INPUT_FIELD = SdkField
            .<ModelExplainabilityJobInput> builder(MarshallingType.SDK_POJO)
            .memberName("ModelExplainabilityJobInput")
            .getter(getter(CreateModelExplainabilityJobDefinitionRequest::modelExplainabilityJobInput))
            .setter(setter(Builder::modelExplainabilityJobInput))
            .constructor(ModelExplainabilityJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelExplainabilityJobInput")
                    .build()).build();

    private static final SdkField<MonitoringOutputConfig> MODEL_EXPLAINABILITY_JOB_OUTPUT_CONFIG_FIELD = SdkField
            .<MonitoringOutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ModelExplainabilityJobOutputConfig")
            .getter(getter(CreateModelExplainabilityJobDefinitionRequest::modelExplainabilityJobOutputConfig))
            .setter(setter(Builder::modelExplainabilityJobOutputConfig))
            .constructor(MonitoringOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelExplainabilityJobOutputConfig")
                    .build()).build();

    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField
            .<MonitoringResources> builder(MarshallingType.SDK_POJO).memberName("JobResources")
            .getter(getter(CreateModelExplainabilityJobDefinitionRequest::jobResources)).setter(setter(Builder::jobResources))
            .constructor(MonitoringResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()).build();

    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField
            .<MonitoringNetworkConfig> builder(MarshallingType.SDK_POJO).memberName("NetworkConfig")
            .getter(getter(CreateModelExplainabilityJobDefinitionRequest::networkConfig)).setter(setter(Builder::networkConfig))
            .constructor(MonitoringNetworkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateModelExplainabilityJobDefinitionRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<MonitoringStoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(CreateModelExplainabilityJobDefinitionRequest::stoppingCondition))
            .setter(setter(Builder::stoppingCondition)).constructor(MonitoringStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateModelExplainabilityJobDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD,
            MODEL_EXPLAINABILITY_BASELINE_CONFIG_FIELD, MODEL_EXPLAINABILITY_APP_SPECIFICATION_FIELD,
            MODEL_EXPLAINABILITY_JOB_INPUT_FIELD, MODEL_EXPLAINABILITY_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD,
            NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD));

    private final String jobDefinitionName;

    private final ModelExplainabilityBaselineConfig modelExplainabilityBaselineConfig;

    private final ModelExplainabilityAppSpecification modelExplainabilityAppSpecification;

    private final ModelExplainabilityJobInput modelExplainabilityJobInput;

    private final MonitoringOutputConfig modelExplainabilityJobOutputConfig;

    private final MonitoringResources jobResources;

    private final MonitoringNetworkConfig networkConfig;

    private final String roleArn;

    private final MonitoringStoppingCondition stoppingCondition;

    private final List<Tag> tags;

    private CreateModelExplainabilityJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.modelExplainabilityBaselineConfig = builder.modelExplainabilityBaselineConfig;
        this.modelExplainabilityAppSpecification = builder.modelExplainabilityAppSpecification;
        this.modelExplainabilityJobInput = builder.modelExplainabilityJobInput;
        this.modelExplainabilityJobOutputConfig = builder.modelExplainabilityJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the model explainability job definition. The name must be unique within an AWS Region in the AWS
     * account.
     * </p>
     * 
     * @return The name of the model explainability job definition. The name must be unique within an AWS Region in the
     *         AWS account.
     */
    public final String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The baseline configuration for a model explainability job.
     * </p>
     * 
     * @return The baseline configuration for a model explainability job.
     */
    public final ModelExplainabilityBaselineConfig modelExplainabilityBaselineConfig() {
        return modelExplainabilityBaselineConfig;
    }

    /**
     * <p>
     * Configures the model explainability job to run a specified Docker container image.
     * </p>
     * 
     * @return Configures the model explainability job to run a specified Docker container image.
     */
    public final ModelExplainabilityAppSpecification modelExplainabilityAppSpecification() {
        return modelExplainabilityAppSpecification;
    }

    /**
     * <p>
     * Inputs for the model explainability job.
     * </p>
     * 
     * @return Inputs for the model explainability job.
     */
    public final ModelExplainabilityJobInput modelExplainabilityJobInput() {
        return modelExplainabilityJobInput;
    }

    /**
     * Returns the value of the ModelExplainabilityJobOutputConfig property for this object.
     * 
     * @return The value of the ModelExplainabilityJobOutputConfig property for this object.
     */
    public final MonitoringOutputConfig modelExplainabilityJobOutputConfig() {
        return modelExplainabilityJobOutputConfig;
    }

    /**
     * Returns the value of the JobResources property for this object.
     * 
     * @return The value of the JobResources property for this object.
     */
    public final MonitoringResources jobResources() {
        return jobResources;
    }

    /**
     * <p>
     * Networking options for a model explainability job.
     * </p>
     * 
     * @return Networking options for a model explainability job.
     */
    public final MonitoringNetworkConfig networkConfig() {
        return networkConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the StoppingCondition property for this object.
     * 
     * @return The value of the StoppingCondition property for this object.
     */
    public final MonitoringStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) An array of key-value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using
     * Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Optional) An array of key-value pairs. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
     *         >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(modelExplainabilityBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelExplainabilityAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(modelExplainabilityJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(modelExplainabilityJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelExplainabilityJobDefinitionRequest)) {
            return false;
        }
        CreateModelExplainabilityJobDefinitionRequest other = (CreateModelExplainabilityJobDefinitionRequest) obj;
        return Objects.equals(jobDefinitionName(), other.jobDefinitionName())
                && Objects.equals(modelExplainabilityBaselineConfig(), other.modelExplainabilityBaselineConfig())
                && Objects.equals(modelExplainabilityAppSpecification(), other.modelExplainabilityAppSpecification())
                && Objects.equals(modelExplainabilityJobInput(), other.modelExplainabilityJobInput())
                && Objects.equals(modelExplainabilityJobOutputConfig(), other.modelExplainabilityJobOutputConfig())
                && Objects.equals(jobResources(), other.jobResources()) && Objects.equals(networkConfig(), other.networkConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelExplainabilityJobDefinitionRequest").add("JobDefinitionName", jobDefinitionName())
                .add("ModelExplainabilityBaselineConfig", modelExplainabilityBaselineConfig())
                .add("ModelExplainabilityAppSpecification", modelExplainabilityAppSpecification())
                .add("ModelExplainabilityJobInput", modelExplainabilityJobInput())
                .add("ModelExplainabilityJobOutputConfig", modelExplainabilityJobOutputConfig())
                .add("JobResources", jobResources()).add("NetworkConfig", networkConfig()).add("RoleArn", roleArn())
                .add("StoppingCondition", stoppingCondition()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "ModelExplainabilityBaselineConfig":
            return Optional.ofNullable(clazz.cast(modelExplainabilityBaselineConfig()));
        case "ModelExplainabilityAppSpecification":
            return Optional.ofNullable(clazz.cast(modelExplainabilityAppSpecification()));
        case "ModelExplainabilityJobInput":
            return Optional.ofNullable(clazz.cast(modelExplainabilityJobInput()));
        case "ModelExplainabilityJobOutputConfig":
            return Optional.ofNullable(clazz.cast(modelExplainabilityJobOutputConfig()));
        case "JobResources":
            return Optional.ofNullable(clazz.cast(jobResources()));
        case "NetworkConfig":
            return Optional.ofNullable(clazz.cast(networkConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelExplainabilityJobDefinitionRequest, T> g) {
        return obj -> g.apply((CreateModelExplainabilityJobDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateModelExplainabilityJobDefinitionRequest> {
        /**
         * <p>
         * The name of the model explainability job definition. The name must be unique within an AWS Region in the AWS
         * account.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the model explainability job definition. The name must be unique within an AWS Region in
         *        the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The baseline configuration for a model explainability job.
         * </p>
         * 
         * @param modelExplainabilityBaselineConfig
         *        The baseline configuration for a model explainability job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelExplainabilityBaselineConfig(ModelExplainabilityBaselineConfig modelExplainabilityBaselineConfig);

        /**
         * <p>
         * The baseline configuration for a model explainability job.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelExplainabilityBaselineConfig.Builder}
         * avoiding the need to create one manually via {@link ModelExplainabilityBaselineConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelExplainabilityBaselineConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #modelExplainabilityBaselineConfig(ModelExplainabilityBaselineConfig)}.
         * 
         * @param modelExplainabilityBaselineConfig
         *        a consumer that will call methods on {@link ModelExplainabilityBaselineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelExplainabilityBaselineConfig(ModelExplainabilityBaselineConfig)
         */
        default Builder modelExplainabilityBaselineConfig(
                Consumer<ModelExplainabilityBaselineConfig.Builder> modelExplainabilityBaselineConfig) {
            return modelExplainabilityBaselineConfig(ModelExplainabilityBaselineConfig.builder()
                    .applyMutation(modelExplainabilityBaselineConfig).build());
        }

        /**
         * <p>
         * Configures the model explainability job to run a specified Docker container image.
         * </p>
         * 
         * @param modelExplainabilityAppSpecification
         *        Configures the model explainability job to run a specified Docker container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelExplainabilityAppSpecification(ModelExplainabilityAppSpecification modelExplainabilityAppSpecification);

        /**
         * <p>
         * Configures the model explainability job to run a specified Docker container image.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelExplainabilityAppSpecification.Builder}
         * avoiding the need to create one manually via {@link ModelExplainabilityAppSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelExplainabilityAppSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #modelExplainabilityAppSpecification(ModelExplainabilityAppSpecification)}.
         * 
         * @param modelExplainabilityAppSpecification
         *        a consumer that will call methods on {@link ModelExplainabilityAppSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelExplainabilityAppSpecification(ModelExplainabilityAppSpecification)
         */
        default Builder modelExplainabilityAppSpecification(
                Consumer<ModelExplainabilityAppSpecification.Builder> modelExplainabilityAppSpecification) {
            return modelExplainabilityAppSpecification(ModelExplainabilityAppSpecification.builder()
                    .applyMutation(modelExplainabilityAppSpecification).build());
        }

        /**
         * <p>
         * Inputs for the model explainability job.
         * </p>
         * 
         * @param modelExplainabilityJobInput
         *        Inputs for the model explainability job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelExplainabilityJobInput(ModelExplainabilityJobInput modelExplainabilityJobInput);

        /**
         * <p>
         * Inputs for the model explainability job.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelExplainabilityJobInput.Builder} avoiding
         * the need to create one manually via {@link ModelExplainabilityJobInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelExplainabilityJobInput.Builder#build()} is called
         * immediately and its result is passed to {@link #modelExplainabilityJobInput(ModelExplainabilityJobInput)}.
         * 
         * @param modelExplainabilityJobInput
         *        a consumer that will call methods on {@link ModelExplainabilityJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelExplainabilityJobInput(ModelExplainabilityJobInput)
         */
        default Builder modelExplainabilityJobInput(Consumer<ModelExplainabilityJobInput.Builder> modelExplainabilityJobInput) {
            return modelExplainabilityJobInput(ModelExplainabilityJobInput.builder().applyMutation(modelExplainabilityJobInput)
                    .build());
        }

        /**
         * Sets the value of the ModelExplainabilityJobOutputConfig property for this object.
         *
         * @param modelExplainabilityJobOutputConfig
         *        The new value for the ModelExplainabilityJobOutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelExplainabilityJobOutputConfig(MonitoringOutputConfig modelExplainabilityJobOutputConfig);

        /**
         * Sets the value of the ModelExplainabilityJobOutputConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringOutputConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #modelExplainabilityJobOutputConfig(MonitoringOutputConfig)}.
         * 
         * @param modelExplainabilityJobOutputConfig
         *        a consumer that will call methods on {@link MonitoringOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelExplainabilityJobOutputConfig(MonitoringOutputConfig)
         */
        default Builder modelExplainabilityJobOutputConfig(
                Consumer<MonitoringOutputConfig.Builder> modelExplainabilityJobOutputConfig) {
            return modelExplainabilityJobOutputConfig(MonitoringOutputConfig.builder()
                    .applyMutation(modelExplainabilityJobOutputConfig).build());
        }

        /**
         * Sets the value of the JobResources property for this object.
         *
         * @param jobResources
         *        The new value for the JobResources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobResources(MonitoringResources jobResources);

        /**
         * Sets the value of the JobResources property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringResources.Builder} avoiding the need
         * to create one manually via {@link MonitoringResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringResources.Builder#build()} is called immediately and
         * its result is passed to {@link #jobResources(MonitoringResources)}.
         * 
         * @param jobResources
         *        a consumer that will call methods on {@link MonitoringResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobResources(MonitoringResources)
         */
        default Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return jobResources(MonitoringResources.builder().applyMutation(jobResources).build());
        }

        /**
         * <p>
         * Networking options for a model explainability job.
         * </p>
         * 
         * @param networkConfig
         *        Networking options for a model explainability job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfig(MonitoringNetworkConfig networkConfig);

        /**
         * <p>
         * Networking options for a model explainability job.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringNetworkConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringNetworkConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringNetworkConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #networkConfig(MonitoringNetworkConfig)}.
         * 
         * @param networkConfig
         *        a consumer that will call methods on {@link MonitoringNetworkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfig(MonitoringNetworkConfig)
         */
        default Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return networkConfig(MonitoringNetworkConfig.builder().applyMutation(networkConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
         * behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
         *        your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * @param stoppingCondition
         *        The new value for the StoppingCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringStoppingCondition.Builder} avoiding
         * the need to create one manually via {@link MonitoringStoppingCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringStoppingCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingCondition(MonitoringStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link MonitoringStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(MonitoringStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(MonitoringStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String jobDefinitionName;

        private ModelExplainabilityBaselineConfig modelExplainabilityBaselineConfig;

        private ModelExplainabilityAppSpecification modelExplainabilityAppSpecification;

        private ModelExplainabilityJobInput modelExplainabilityJobInput;

        private MonitoringOutputConfig modelExplainabilityJobOutputConfig;

        private MonitoringResources jobResources;

        private MonitoringNetworkConfig networkConfig;

        private String roleArn;

        private MonitoringStoppingCondition stoppingCondition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelExplainabilityJobDefinitionRequest model) {
            super(model);
            jobDefinitionName(model.jobDefinitionName);
            modelExplainabilityBaselineConfig(model.modelExplainabilityBaselineConfig);
            modelExplainabilityAppSpecification(model.modelExplainabilityAppSpecification);
            modelExplainabilityJobInput(model.modelExplainabilityJobInput);
            modelExplainabilityJobOutputConfig(model.modelExplainabilityJobOutputConfig);
            jobResources(model.jobResources);
            networkConfig(model.networkConfig);
            roleArn(model.roleArn);
            stoppingCondition(model.stoppingCondition);
            tags(model.tags);
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final ModelExplainabilityBaselineConfig.Builder getModelExplainabilityBaselineConfig() {
            return modelExplainabilityBaselineConfig != null ? modelExplainabilityBaselineConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelExplainabilityBaselineConfig(ModelExplainabilityBaselineConfig modelExplainabilityBaselineConfig) {
            this.modelExplainabilityBaselineConfig = modelExplainabilityBaselineConfig;
            return this;
        }

        public final void setModelExplainabilityBaselineConfig(
                ModelExplainabilityBaselineConfig.BuilderImpl modelExplainabilityBaselineConfig) {
            this.modelExplainabilityBaselineConfig = modelExplainabilityBaselineConfig != null ? modelExplainabilityBaselineConfig
                    .build() : null;
        }

        public final ModelExplainabilityAppSpecification.Builder getModelExplainabilityAppSpecification() {
            return modelExplainabilityAppSpecification != null ? modelExplainabilityAppSpecification.toBuilder() : null;
        }

        @Override
        public final Builder modelExplainabilityAppSpecification(
                ModelExplainabilityAppSpecification modelExplainabilityAppSpecification) {
            this.modelExplainabilityAppSpecification = modelExplainabilityAppSpecification;
            return this;
        }

        public final void setModelExplainabilityAppSpecification(
                ModelExplainabilityAppSpecification.BuilderImpl modelExplainabilityAppSpecification) {
            this.modelExplainabilityAppSpecification = modelExplainabilityAppSpecification != null ? modelExplainabilityAppSpecification
                    .build() : null;
        }

        public final ModelExplainabilityJobInput.Builder getModelExplainabilityJobInput() {
            return modelExplainabilityJobInput != null ? modelExplainabilityJobInput.toBuilder() : null;
        }

        @Override
        public final Builder modelExplainabilityJobInput(ModelExplainabilityJobInput modelExplainabilityJobInput) {
            this.modelExplainabilityJobInput = modelExplainabilityJobInput;
            return this;
        }

        public final void setModelExplainabilityJobInput(ModelExplainabilityJobInput.BuilderImpl modelExplainabilityJobInput) {
            this.modelExplainabilityJobInput = modelExplainabilityJobInput != null ? modelExplainabilityJobInput.build() : null;
        }

        public final MonitoringOutputConfig.Builder getModelExplainabilityJobOutputConfig() {
            return modelExplainabilityJobOutputConfig != null ? modelExplainabilityJobOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder modelExplainabilityJobOutputConfig(MonitoringOutputConfig modelExplainabilityJobOutputConfig) {
            this.modelExplainabilityJobOutputConfig = modelExplainabilityJobOutputConfig;
            return this;
        }

        public final void setModelExplainabilityJobOutputConfig(
                MonitoringOutputConfig.BuilderImpl modelExplainabilityJobOutputConfig) {
            this.modelExplainabilityJobOutputConfig = modelExplainabilityJobOutputConfig != null ? modelExplainabilityJobOutputConfig
                    .build() : null;
        }

        public final MonitoringResources.Builder getJobResources() {
            return jobResources != null ? jobResources.toBuilder() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return networkConfig != null ? networkConfig.toBuilder() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelExplainabilityJobDefinitionRequest build() {
            return new CreateModelExplainabilityJobDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
