/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelSummary implements SdkPojo, Serializable, ToCopyableBuilder<ModelSummary.Builder, ModelSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(ModelSummary::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(ModelSummary::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ModelSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final String modelArn;

    private final Instant creationTime;

    private ModelSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the model that you want a summary for.
     * </p>
     * 
     * @return The name of the model that you want a summary for.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * A timestamp that indicates when the model was created.
     * </p>
     * 
     * @return A timestamp that indicates when the model was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelSummary)) {
            return false;
        }
        ModelSummary other = (ModelSummary) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelSummary").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelSummary, T> g) {
        return obj -> g.apply((ModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelSummary> {
        /**
         * <p>
         * The name of the model that you want a summary for.
         * </p>
         * 
         * @param modelName
         *        The name of the model that you want a summary for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * A timestamp that indicates when the model was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that indicates when the model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelSummary model) {
            modelName(model.modelName);
            modelArn(model.modelArn);
            creationTime(model.creationTime);
        }

        public final String getModelName() {
            return modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final String getModelArn() {
            return modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public ModelSummary build() {
            return new ModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
