/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of storage locations for the Debugger TensorBoard output data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TensorBoardOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TensorBoardOutputConfig.Builder, TensorBoardOutputConfig> {
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalPath").getter(getter(TensorBoardOutputConfig::localPath)).setter(setter(Builder::localPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()).build();

    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3OutputPath").getter(getter(TensorBoardOutputConfig::s3OutputPath))
            .setter(setter(Builder::s3OutputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_PATH_FIELD,
            S3_OUTPUT_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String localPath;

    private final String s3OutputPath;

    private TensorBoardOutputConfig(BuilderImpl builder) {
        this.localPath = builder.localPath;
        this.s3OutputPath = builder.s3OutputPath;
    }

    /**
     * <p>
     * Path to local storage location for tensorBoard output. Defaults to <code>/opt/ml/output/tensorboard</code>.
     * </p>
     * 
     * @return Path to local storage location for tensorBoard output. Defaults to
     *         <code>/opt/ml/output/tensorboard</code>.
     */
    public final String localPath() {
        return localPath;
    }

    /**
     * <p>
     * Path to Amazon S3 storage location for TensorBoard output.
     * </p>
     * 
     * @return Path to Amazon S3 storage location for TensorBoard output.
     */
    public final String s3OutputPath() {
        return s3OutputPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TensorBoardOutputConfig)) {
            return false;
        }
        TensorBoardOutputConfig other = (TensorBoardOutputConfig) obj;
        return Objects.equals(localPath(), other.localPath()) && Objects.equals(s3OutputPath(), other.s3OutputPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TensorBoardOutputConfig").add("LocalPath", localPath()).add("S3OutputPath", s3OutputPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalPath":
            return Optional.ofNullable(clazz.cast(localPath()));
        case "S3OutputPath":
            return Optional.ofNullable(clazz.cast(s3OutputPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TensorBoardOutputConfig, T> g) {
        return obj -> g.apply((TensorBoardOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TensorBoardOutputConfig> {
        /**
         * <p>
         * Path to local storage location for tensorBoard output. Defaults to <code>/opt/ml/output/tensorboard</code>.
         * </p>
         * 
         * @param localPath
         *        Path to local storage location for tensorBoard output. Defaults to
         *        <code>/opt/ml/output/tensorboard</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPath(String localPath);

        /**
         * <p>
         * Path to Amazon S3 storage location for TensorBoard output.
         * </p>
         * 
         * @param s3OutputPath
         *        Path to Amazon S3 storage location for TensorBoard output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputPath(String s3OutputPath);
    }

    static final class BuilderImpl implements Builder {
        private String localPath;

        private String s3OutputPath;

        private BuilderImpl() {
        }

        private BuilderImpl(TensorBoardOutputConfig model) {
            localPath(model.localPath);
            s3OutputPath(model.s3OutputPath);
        }

        public final String getLocalPath() {
            return localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public final String getS3OutputPath() {
            return s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        public TensorBoardOutputConfig build() {
            return new TensorBoardOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
