/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an algorithm that was used to create the model package. The algorithm must be either an algorithm resource
 * in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceAlgorithm implements SdkPojo, Serializable, ToCopyableBuilder<SourceAlgorithm.Builder, SourceAlgorithm> {
    private static final SdkField<String> MODEL_DATA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelDataUrl").getter(getter(SourceAlgorithm::modelDataUrl)).setter(setter(Builder::modelDataUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataUrl").build()).build();

    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmName").getter(getter(SourceAlgorithm::algorithmName)).setter(setter(Builder::algorithmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_DATA_URL_FIELD,
            ALGORITHM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelDataUrl;

    private final String algorithmName;

    private SourceAlgorithm(BuilderImpl builder) {
        this.modelDataUrl = builder.modelDataUrl;
        this.algorithmName = builder.algorithmName;
    }

    /**
     * <p>
     * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point
     * to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).
     * </p>
     * <note>
     * <p>
     * The model artifacts must be in an S3 bucket that is in the same region as the algorithm.
     * </p>
     * </note>
     * 
     * @return The Amazon S3 path where the model artifacts, which result from model training, are stored. This path
     *         must point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).</p> <note>
     *         <p>
     *         The model artifacts must be in an S3 bucket that is in the same region as the algorithm.
     *         </p>
     */
    public final String modelDataUrl() {
        return modelDataUrl;
    }

    /**
     * <p>
     * The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm
     * resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
     * </p>
     * 
     * @return The name of an algorithm that was used to create the model package. The algorithm must be either an
     *         algorithm resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are
     *         subscribed to.
     */
    public final String algorithmName() {
        return algorithmName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAlgorithm)) {
            return false;
        }
        SourceAlgorithm other = (SourceAlgorithm) obj;
        return Objects.equals(modelDataUrl(), other.modelDataUrl()) && Objects.equals(algorithmName(), other.algorithmName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceAlgorithm").add("ModelDataUrl", modelDataUrl()).add("AlgorithmName", algorithmName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelDataUrl":
            return Optional.ofNullable(clazz.cast(modelDataUrl()));
        case "AlgorithmName":
            return Optional.ofNullable(clazz.cast(algorithmName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceAlgorithm, T> g) {
        return obj -> g.apply((SourceAlgorithm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceAlgorithm> {
        /**
         * <p>
         * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must
         * point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).
         * </p>
         * <note>
         * <p>
         * The model artifacts must be in an S3 bucket that is in the same region as the algorithm.
         * </p>
         * </note>
         * 
         * @param modelDataUrl
         *        The Amazon S3 path where the model artifacts, which result from model training, are stored. This path
         *        must point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).</p>
         *        <note>
         *        <p>
         *        The model artifacts must be in an S3 bucket that is in the same region as the algorithm.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDataUrl(String modelDataUrl);

        /**
         * <p>
         * The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm
         * resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.
         * </p>
         * 
         * @param algorithmName
         *        The name of an algorithm that was used to create the model package. The algorithm must be either an
         *        algorithm resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are
         *        subscribed to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmName(String algorithmName);
    }

    static final class BuilderImpl implements Builder {
        private String modelDataUrl;

        private String algorithmName;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAlgorithm model) {
            modelDataUrl(model.modelDataUrl);
            algorithmName(model.algorithmName);
        }

        public final String getModelDataUrl() {
            return modelDataUrl;
        }

        @Override
        public final Builder modelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }

        public final void setModelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
        }

        public final String getAlgorithmName() {
            return algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public SourceAlgorithm build() {
            return new SourceAlgorithm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
