/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes the monitoring schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringScheduleSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringScheduleSummary.Builder, MonitoringScheduleSummary> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleName").getter(getter(MonitoringScheduleSummary::monitoringScheduleName))
            .setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<String> MONITORING_SCHEDULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleArn").getter(getter(MonitoringScheduleSummary::monitoringScheduleArn))
            .setter(setter(Builder::monitoringScheduleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleArn").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(MonitoringScheduleSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(MonitoringScheduleSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> MONITORING_SCHEDULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleStatus").getter(getter(MonitoringScheduleSummary::monitoringScheduleStatusAsString))
            .setter(setter(Builder::monitoringScheduleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleStatus").build())
            .build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(MonitoringScheduleSummary::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> MONITORING_JOB_DEFINITION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MonitoringJobDefinitionName")
            .getter(getter(MonitoringScheduleSummary::monitoringJobDefinitionName))
            .setter(setter(Builder::monitoringJobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringJobDefinitionName")
                    .build()).build();

    private static final SdkField<String> MONITORING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringType").getter(getter(MonitoringScheduleSummary::monitoringTypeAsString))
            .setter(setter(Builder::monitoringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_SCHEDULE_NAME_FIELD, MONITORING_SCHEDULE_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            MONITORING_SCHEDULE_STATUS_FIELD, ENDPOINT_NAME_FIELD, MONITORING_JOB_DEFINITION_NAME_FIELD, MONITORING_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String monitoringScheduleName;

    private final String monitoringScheduleArn;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String monitoringScheduleStatus;

    private final String endpointName;

    private final String monitoringJobDefinitionName;

    private final String monitoringType;

    private MonitoringScheduleSummary(BuilderImpl builder) {
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringScheduleArn = builder.monitoringScheduleArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringScheduleStatus = builder.monitoringScheduleStatus;
        this.endpointName = builder.endpointName;
        this.monitoringJobDefinitionName = builder.monitoringJobDefinitionName;
        this.monitoringType = builder.monitoringType;
    }

    /**
     * <p>
     * The name of the monitoring schedule.
     * </p>
     * 
     * @return The name of the monitoring schedule.
     */
    public final String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitoring schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitoring schedule.
     */
    public final String monitoringScheduleArn() {
        return monitoringScheduleArn;
    }

    /**
     * <p>
     * The creation time of the monitoring schedule.
     * </p>
     * 
     * @return The creation time of the monitoring schedule.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the monitoring schedule was modified.
     * </p>
     * 
     * @return The last time the monitoring schedule was modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The status of the monitoring schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringScheduleStatus} will return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringScheduleStatusAsString}.
     * </p>
     * 
     * @return The status of the monitoring schedule.
     * @see ScheduleStatus
     */
    public final ScheduleStatus monitoringScheduleStatus() {
        return ScheduleStatus.fromValue(monitoringScheduleStatus);
    }

    /**
     * <p>
     * The status of the monitoring schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringScheduleStatus} will return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringScheduleStatusAsString}.
     * </p>
     * 
     * @return The status of the monitoring schedule.
     * @see ScheduleStatus
     */
    public final String monitoringScheduleStatusAsString() {
        return monitoringScheduleStatus;
    }

    /**
     * <p>
     * The name of the endpoint using the monitoring schedule.
     * </p>
     * 
     * @return The name of the endpoint using the monitoring schedule.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The name of the monitoring job definition that the schedule is for.
     * </p>
     * 
     * @return The name of the monitoring job definition that the schedule is for.
     */
    public final String monitoringJobDefinitionName() {
        return monitoringJobDefinitionName;
    }

    /**
     * <p>
     * The type of the monitoring job definition that the schedule is for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitoringType}
     * will return {@link MonitoringType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #monitoringTypeAsString}.
     * </p>
     * 
     * @return The type of the monitoring job definition that the schedule is for.
     * @see MonitoringType
     */
    public final MonitoringType monitoringType() {
        return MonitoringType.fromValue(monitoringType);
    }

    /**
     * <p>
     * The type of the monitoring job definition that the schedule is for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monitoringType}
     * will return {@link MonitoringType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #monitoringTypeAsString}.
     * </p>
     * 
     * @return The type of the monitoring job definition that the schedule is for.
     * @see MonitoringType
     */
    public final String monitoringTypeAsString() {
        return monitoringType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringJobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringScheduleSummary)) {
            return false;
        }
        MonitoringScheduleSummary other = (MonitoringScheduleSummary) obj;
        return Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(monitoringScheduleArn(), other.monitoringScheduleArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(monitoringScheduleStatusAsString(), other.monitoringScheduleStatusAsString())
                && Objects.equals(endpointName(), other.endpointName())
                && Objects.equals(monitoringJobDefinitionName(), other.monitoringJobDefinitionName())
                && Objects.equals(monitoringTypeAsString(), other.monitoringTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringScheduleSummary").add("MonitoringScheduleName", monitoringScheduleName())
                .add("MonitoringScheduleArn", monitoringScheduleArn()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("MonitoringScheduleStatus", monitoringScheduleStatusAsString())
                .add("EndpointName", endpointName()).add("MonitoringJobDefinitionName", monitoringJobDefinitionName())
                .add("MonitoringType", monitoringTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "MonitoringScheduleArn":
            return Optional.ofNullable(clazz.cast(monitoringScheduleArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "MonitoringScheduleStatus":
            return Optional.ofNullable(clazz.cast(monitoringScheduleStatusAsString()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "MonitoringJobDefinitionName":
            return Optional.ofNullable(clazz.cast(monitoringJobDefinitionName()));
        case "MonitoringType":
            return Optional.ofNullable(clazz.cast(monitoringTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringScheduleSummary, T> g) {
        return obj -> g.apply((MonitoringScheduleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringScheduleSummary> {
        /**
         * <p>
         * The name of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleName
         *        The name of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleArn
         *        The Amazon Resource Name (ARN) of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleArn(String monitoringScheduleArn);

        /**
         * <p>
         * The creation time of the monitoring schedule.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the monitoring schedule was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time the monitoring schedule was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The status of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleStatus
         *        The status of the monitoring schedule.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder monitoringScheduleStatus(String monitoringScheduleStatus);

        /**
         * <p>
         * The status of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleStatus
         *        The status of the monitoring schedule.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus);

        /**
         * <p>
         * The name of the endpoint using the monitoring schedule.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint using the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The name of the monitoring job definition that the schedule is for.
         * </p>
         * 
         * @param monitoringJobDefinitionName
         *        The name of the monitoring job definition that the schedule is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringJobDefinitionName(String monitoringJobDefinitionName);

        /**
         * <p>
         * The type of the monitoring job definition that the schedule is for.
         * </p>
         * 
         * @param monitoringType
         *        The type of the monitoring job definition that the schedule is for.
         * @see MonitoringType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringType
         */
        Builder monitoringType(String monitoringType);

        /**
         * <p>
         * The type of the monitoring job definition that the schedule is for.
         * </p>
         * 
         * @param monitoringType
         *        The type of the monitoring job definition that the schedule is for.
         * @see MonitoringType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringType
         */
        Builder monitoringType(MonitoringType monitoringType);
    }

    static final class BuilderImpl implements Builder {
        private String monitoringScheduleName;

        private String monitoringScheduleArn;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String monitoringScheduleStatus;

        private String endpointName;

        private String monitoringJobDefinitionName;

        private String monitoringType;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringScheduleSummary model) {
            monitoringScheduleName(model.monitoringScheduleName);
            monitoringScheduleArn(model.monitoringScheduleArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            monitoringScheduleStatus(model.monitoringScheduleStatus);
            endpointName(model.endpointName);
            monitoringJobDefinitionName(model.monitoringJobDefinitionName);
            monitoringType(model.monitoringType);
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        public final String getMonitoringScheduleArn() {
            return monitoringScheduleArn;
        }

        @Override
        public final Builder monitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
            return this;
        }

        public final void setMonitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getMonitoringScheduleStatus() {
            return monitoringScheduleStatus;
        }

        @Override
        public final Builder monitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
            return this;
        }

        @Override
        public final Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus) {
            this.monitoringScheduleStatus(monitoringScheduleStatus == null ? null : monitoringScheduleStatus.toString());
            return this;
        }

        public final void setMonitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getMonitoringJobDefinitionName() {
            return monitoringJobDefinitionName;
        }

        @Override
        public final Builder monitoringJobDefinitionName(String monitoringJobDefinitionName) {
            this.monitoringJobDefinitionName = monitoringJobDefinitionName;
            return this;
        }

        public final void setMonitoringJobDefinitionName(String monitoringJobDefinitionName) {
            this.monitoringJobDefinitionName = monitoringJobDefinitionName;
        }

        public final String getMonitoringType() {
            return monitoringType;
        }

        @Override
        public final Builder monitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
            return this;
        }

        @Override
        public final Builder monitoringType(MonitoringType monitoringType) {
            this.monitoringType(monitoringType == null ? null : monitoringType.toString());
            return this;
        }

        public final void setMonitoringType(String monitoringType) {
            this.monitoringType = monitoringType;
        }

        @Override
        public MonitoringScheduleSummary build() {
            return new MonitoringScheduleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
