/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The artifacts that are generated during an AutoML job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLJobArtifacts implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLJobArtifacts.Builder, AutoMLJobArtifacts> {
    private static final SdkField<String> CANDIDATE_DEFINITION_NOTEBOOK_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CandidateDefinitionNotebookLocation")
            .getter(getter(AutoMLJobArtifacts::candidateDefinitionNotebookLocation))
            .setter(setter(Builder::candidateDefinitionNotebookLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CandidateDefinitionNotebookLocation").build()).build();

    private static final SdkField<String> DATA_EXPLORATION_NOTEBOOK_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataExplorationNotebookLocation")
            .getter(getter(AutoMLJobArtifacts::dataExplorationNotebookLocation))
            .setter(setter(Builder::dataExplorationNotebookLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExplorationNotebookLocation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CANDIDATE_DEFINITION_NOTEBOOK_LOCATION_FIELD, DATA_EXPLORATION_NOTEBOOK_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String candidateDefinitionNotebookLocation;

    private final String dataExplorationNotebookLocation;

    private AutoMLJobArtifacts(BuilderImpl builder) {
        this.candidateDefinitionNotebookLocation = builder.candidateDefinitionNotebookLocation;
        this.dataExplorationNotebookLocation = builder.dataExplorationNotebookLocation;
    }

    /**
     * <p>
     * The URL of the notebook location.
     * </p>
     * 
     * @return The URL of the notebook location.
     */
    public final String candidateDefinitionNotebookLocation() {
        return candidateDefinitionNotebookLocation;
    }

    /**
     * <p>
     * The URL of the notebook location.
     * </p>
     * 
     * @return The URL of the notebook location.
     */
    public final String dataExplorationNotebookLocation() {
        return dataExplorationNotebookLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(candidateDefinitionNotebookLocation());
        hashCode = 31 * hashCode + Objects.hashCode(dataExplorationNotebookLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobArtifacts)) {
            return false;
        }
        AutoMLJobArtifacts other = (AutoMLJobArtifacts) obj;
        return Objects.equals(candidateDefinitionNotebookLocation(), other.candidateDefinitionNotebookLocation())
                && Objects.equals(dataExplorationNotebookLocation(), other.dataExplorationNotebookLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLJobArtifacts")
                .add("CandidateDefinitionNotebookLocation", candidateDefinitionNotebookLocation())
                .add("DataExplorationNotebookLocation", dataExplorationNotebookLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CandidateDefinitionNotebookLocation":
            return Optional.ofNullable(clazz.cast(candidateDefinitionNotebookLocation()));
        case "DataExplorationNotebookLocation":
            return Optional.ofNullable(clazz.cast(dataExplorationNotebookLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobArtifacts, T> g) {
        return obj -> g.apply((AutoMLJobArtifacts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLJobArtifacts> {
        /**
         * <p>
         * The URL of the notebook location.
         * </p>
         * 
         * @param candidateDefinitionNotebookLocation
         *        The URL of the notebook location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateDefinitionNotebookLocation(String candidateDefinitionNotebookLocation);

        /**
         * <p>
         * The URL of the notebook location.
         * </p>
         * 
         * @param dataExplorationNotebookLocation
         *        The URL of the notebook location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExplorationNotebookLocation(String dataExplorationNotebookLocation);
    }

    static final class BuilderImpl implements Builder {
        private String candidateDefinitionNotebookLocation;

        private String dataExplorationNotebookLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobArtifacts model) {
            candidateDefinitionNotebookLocation(model.candidateDefinitionNotebookLocation);
            dataExplorationNotebookLocation(model.dataExplorationNotebookLocation);
        }

        public final String getCandidateDefinitionNotebookLocation() {
            return candidateDefinitionNotebookLocation;
        }

        @Override
        public final Builder candidateDefinitionNotebookLocation(String candidateDefinitionNotebookLocation) {
            this.candidateDefinitionNotebookLocation = candidateDefinitionNotebookLocation;
            return this;
        }

        public final void setCandidateDefinitionNotebookLocation(String candidateDefinitionNotebookLocation) {
            this.candidateDefinitionNotebookLocation = candidateDefinitionNotebookLocation;
        }

        public final String getDataExplorationNotebookLocation() {
            return dataExplorationNotebookLocation;
        }

        @Override
        public final Builder dataExplorationNotebookLocation(String dataExplorationNotebookLocation) {
            this.dataExplorationNotebookLocation = dataExplorationNotebookLocation;
            return this;
        }

        public final void setDataExplorationNotebookLocation(String dataExplorationNotebookLocation) {
            this.dataExplorationNotebookLocation = dataExplorationNotebookLocation;
        }

        @Override
        public AutoMLJobArtifacts build() {
            return new AutoMLJobArtifacts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
