/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AthenaDatasetDefinition;
import software.amazon.awssdk.services.sagemaker.model.DataDistributionType;
import software.amazon.awssdk.services.sagemaker.model.InputMode;
import software.amazon.awssdk.services.sagemaker.model.RedshiftDatasetDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetDefinition> {
    private static final SdkField<AthenaDatasetDefinition> ATHENA_DATASET_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AthenaDatasetDefinition").getter(DatasetDefinition.getter(DatasetDefinition::athenaDatasetDefinition)).setter(DatasetDefinition.setter(Builder::athenaDatasetDefinition)).constructor(AthenaDatasetDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaDatasetDefinition").build()}).build();
    private static final SdkField<RedshiftDatasetDefinition> REDSHIFT_DATASET_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedshiftDatasetDefinition").getter(DatasetDefinition.getter(DatasetDefinition::redshiftDatasetDefinition)).setter(DatasetDefinition.setter(Builder::redshiftDatasetDefinition)).constructor(RedshiftDatasetDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDatasetDefinition").build()}).build();
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalPath").getter(DatasetDefinition.getter(DatasetDefinition::localPath)).setter(DatasetDefinition.setter(Builder::localPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()}).build();
    private static final SdkField<String> DATA_DISTRIBUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataDistributionType").getter(DatasetDefinition.getter(DatasetDefinition::dataDistributionTypeAsString)).setter(DatasetDefinition.setter(Builder::dataDistributionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDistributionType").build()}).build();
    private static final SdkField<String> INPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputMode").getter(DatasetDefinition.getter(DatasetDefinition::inputModeAsString)).setter(DatasetDefinition.setter(Builder::inputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_DATASET_DEFINITION_FIELD, REDSHIFT_DATASET_DEFINITION_FIELD, LOCAL_PATH_FIELD, DATA_DISTRIBUTION_TYPE_FIELD, INPUT_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final AthenaDatasetDefinition athenaDatasetDefinition;
    private final RedshiftDatasetDefinition redshiftDatasetDefinition;
    private final String localPath;
    private final String dataDistributionType;
    private final String inputMode;

    private DatasetDefinition(BuilderImpl builder) {
        this.athenaDatasetDefinition = builder.athenaDatasetDefinition;
        this.redshiftDatasetDefinition = builder.redshiftDatasetDefinition;
        this.localPath = builder.localPath;
        this.dataDistributionType = builder.dataDistributionType;
        this.inputMode = builder.inputMode;
    }

    public final AthenaDatasetDefinition athenaDatasetDefinition() {
        return this.athenaDatasetDefinition;
    }

    public final RedshiftDatasetDefinition redshiftDatasetDefinition() {
        return this.redshiftDatasetDefinition;
    }

    public final String localPath() {
        return this.localPath;
    }

    public final DataDistributionType dataDistributionType() {
        return DataDistributionType.fromValue(this.dataDistributionType);
    }

    public final String dataDistributionTypeAsString() {
        return this.dataDistributionType;
    }

    public final InputMode inputMode() {
        return InputMode.fromValue(this.inputMode);
    }

    public final String inputModeAsString() {
        return this.inputMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.athenaDatasetDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDatasetDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataDistributionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetDefinition)) {
            return false;
        }
        DatasetDefinition other = (DatasetDefinition)obj;
        return Objects.equals(this.athenaDatasetDefinition(), other.athenaDatasetDefinition()) && Objects.equals(this.redshiftDatasetDefinition(), other.redshiftDatasetDefinition()) && Objects.equals(this.localPath(), other.localPath()) && Objects.equals(this.dataDistributionTypeAsString(), other.dataDistributionTypeAsString()) && Objects.equals(this.inputModeAsString(), other.inputModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetDefinition").add("AthenaDatasetDefinition", (Object)this.athenaDatasetDefinition()).add("RedshiftDatasetDefinition", (Object)this.redshiftDatasetDefinition()).add("LocalPath", (Object)this.localPath()).add("DataDistributionType", (Object)this.dataDistributionTypeAsString()).add("InputMode", (Object)this.inputModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AthenaDatasetDefinition": {
                return Optional.ofNullable(clazz.cast(this.athenaDatasetDefinition()));
            }
            case "RedshiftDatasetDefinition": {
                return Optional.ofNullable(clazz.cast(this.redshiftDatasetDefinition()));
            }
            case "LocalPath": {
                return Optional.ofNullable(clazz.cast(this.localPath()));
            }
            case "DataDistributionType": {
                return Optional.ofNullable(clazz.cast(this.dataDistributionTypeAsString()));
            }
            case "InputMode": {
                return Optional.ofNullable(clazz.cast(this.inputModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetDefinition, T> g) {
        return obj -> g.apply((DatasetDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AthenaDatasetDefinition athenaDatasetDefinition;
        private RedshiftDatasetDefinition redshiftDatasetDefinition;
        private String localPath;
        private String dataDistributionType;
        private String inputMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetDefinition model) {
            this.athenaDatasetDefinition(model.athenaDatasetDefinition);
            this.redshiftDatasetDefinition(model.redshiftDatasetDefinition);
            this.localPath(model.localPath);
            this.dataDistributionType(model.dataDistributionType);
            this.inputMode(model.inputMode);
        }

        public final AthenaDatasetDefinition.Builder getAthenaDatasetDefinition() {
            return this.athenaDatasetDefinition != null ? this.athenaDatasetDefinition.toBuilder() : null;
        }

        @Override
        public final Builder athenaDatasetDefinition(AthenaDatasetDefinition athenaDatasetDefinition) {
            this.athenaDatasetDefinition = athenaDatasetDefinition;
            return this;
        }

        public final void setAthenaDatasetDefinition(AthenaDatasetDefinition.BuilderImpl athenaDatasetDefinition) {
            this.athenaDatasetDefinition = athenaDatasetDefinition != null ? athenaDatasetDefinition.build() : null;
        }

        public final RedshiftDatasetDefinition.Builder getRedshiftDatasetDefinition() {
            return this.redshiftDatasetDefinition != null ? this.redshiftDatasetDefinition.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDatasetDefinition(RedshiftDatasetDefinition redshiftDatasetDefinition) {
            this.redshiftDatasetDefinition = redshiftDatasetDefinition;
            return this;
        }

        public final void setRedshiftDatasetDefinition(RedshiftDatasetDefinition.BuilderImpl redshiftDatasetDefinition) {
            this.redshiftDatasetDefinition = redshiftDatasetDefinition != null ? redshiftDatasetDefinition.build() : null;
        }

        public final String getLocalPath() {
            return this.localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public final String getDataDistributionType() {
            return this.dataDistributionType;
        }

        @Override
        public final Builder dataDistributionType(String dataDistributionType) {
            this.dataDistributionType = dataDistributionType;
            return this;
        }

        @Override
        public final Builder dataDistributionType(DataDistributionType dataDistributionType) {
            this.dataDistributionType(dataDistributionType == null ? null : dataDistributionType.toString());
            return this;
        }

        public final void setDataDistributionType(String dataDistributionType) {
            this.dataDistributionType = dataDistributionType;
        }

        public final String getInputMode() {
            return this.inputMode;
        }

        @Override
        public final Builder inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        @Override
        public final Builder inputMode(InputMode inputMode) {
            this.inputMode(inputMode == null ? null : inputMode.toString());
            return this;
        }

        public final void setInputMode(String inputMode) {
            this.inputMode = inputMode;
        }

        public DatasetDefinition build() {
            return new DatasetDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetDefinition> {
        public Builder athenaDatasetDefinition(AthenaDatasetDefinition var1);

        default public Builder athenaDatasetDefinition(Consumer<AthenaDatasetDefinition.Builder> athenaDatasetDefinition) {
            return this.athenaDatasetDefinition((AthenaDatasetDefinition)((AthenaDatasetDefinition.Builder)AthenaDatasetDefinition.builder().applyMutation(athenaDatasetDefinition)).build());
        }

        public Builder redshiftDatasetDefinition(RedshiftDatasetDefinition var1);

        default public Builder redshiftDatasetDefinition(Consumer<RedshiftDatasetDefinition.Builder> redshiftDatasetDefinition) {
            return this.redshiftDatasetDefinition((RedshiftDatasetDefinition)((RedshiftDatasetDefinition.Builder)RedshiftDatasetDefinition.builder().applyMutation(redshiftDatasetDefinition)).build());
        }

        public Builder localPath(String var1);

        public Builder dataDistributionType(String var1);

        public Builder dataDistributionType(DataDistributionType var1);

        public Builder inputMode(String var1);

        public Builder inputMode(InputMode var1);
    }
}

