/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An execution of a step in a pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineExecutionStep implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineExecutionStep.Builder, PipelineExecutionStep> {
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepName").getter(getter(PipelineExecutionStep::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(PipelineExecutionStep::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(PipelineExecutionStep::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> STEP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepStatus").getter(getter(PipelineExecutionStep::stepStatusAsString))
            .setter(setter(Builder::stepStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepStatus").build()).build();

    private static final SdkField<CacheHitResult> CACHE_HIT_RESULT_FIELD = SdkField
            .<CacheHitResult> builder(MarshallingType.SDK_POJO).memberName("CacheHitResult")
            .getter(getter(PipelineExecutionStep::cacheHitResult)).setter(setter(Builder::cacheHitResult))
            .constructor(CacheHitResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheHitResult").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(PipelineExecutionStep::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<PipelineExecutionStepMetadata> METADATA_FIELD = SdkField
            .<PipelineExecutionStepMetadata> builder(MarshallingType.SDK_POJO).memberName("Metadata")
            .getter(getter(PipelineExecutionStep::metadata)).setter(setter(Builder::metadata))
            .constructor(PipelineExecutionStepMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_NAME_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, STEP_STATUS_FIELD, CACHE_HIT_RESULT_FIELD, FAILURE_REASON_FIELD, METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stepName;

    private final Instant startTime;

    private final Instant endTime;

    private final String stepStatus;

    private final CacheHitResult cacheHitResult;

    private final String failureReason;

    private final PipelineExecutionStepMetadata metadata;

    private PipelineExecutionStep(BuilderImpl builder) {
        this.stepName = builder.stepName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.stepStatus = builder.stepStatus;
        this.cacheHitResult = builder.cacheHitResult;
        this.failureReason = builder.failureReason;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The name of the step that is executed.
     * </p>
     * 
     * @return The name of the step that is executed.
     */
    public final String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The time that the step started executing.
     * </p>
     * 
     * @return The time that the step started executing.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time that the step stopped executing.
     * </p>
     * 
     * @return The time that the step stopped executing.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The status of the step execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepStatus} will
     * return {@link StepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stepStatusAsString}.
     * </p>
     * 
     * @return The status of the step execution.
     * @see StepStatus
     */
    public final StepStatus stepStatus() {
        return StepStatus.fromValue(stepStatus);
    }

    /**
     * <p>
     * The status of the step execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepStatus} will
     * return {@link StepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stepStatusAsString}.
     * </p>
     * 
     * @return The status of the step execution.
     * @see StepStatus
     */
    public final String stepStatusAsString() {
        return stepStatus;
    }

    /**
     * <p>
     * If this pipeline execution step was cached, details on the cache hit.
     * </p>
     * 
     * @return If this pipeline execution step was cached, details on the cache hit.
     */
    public final CacheHitResult cacheHitResult() {
        return cacheHitResult;
    }

    /**
     * <p>
     * The reason why the step failed execution. This is only returned if the step failed its execution.
     * </p>
     * 
     * @return The reason why the step failed execution. This is only returned if the step failed its execution.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The metadata for the step execution.
     * </p>
     * 
     * @return The metadata for the step execution.
     */
    public final PipelineExecutionStepMetadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(stepStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cacheHitResult());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionStep)) {
            return false;
        }
        PipelineExecutionStep other = (PipelineExecutionStep) obj;
        return Objects.equals(stepName(), other.stepName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(stepStatusAsString(), other.stepStatusAsString())
                && Objects.equals(cacheHitResult(), other.cacheHitResult())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineExecutionStep").add("StepName", stepName()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("StepStatus", stepStatusAsString()).add("CacheHitResult", cacheHitResult())
                .add("FailureReason", failureReason()).add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "StepStatus":
            return Optional.ofNullable(clazz.cast(stepStatusAsString()));
        case "CacheHitResult":
            return Optional.ofNullable(clazz.cast(cacheHitResult()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecutionStep, T> g) {
        return obj -> g.apply((PipelineExecutionStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineExecutionStep> {
        /**
         * <p>
         * The name of the step that is executed.
         * </p>
         * 
         * @param stepName
         *        The name of the step that is executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The time that the step started executing.
         * </p>
         * 
         * @param startTime
         *        The time that the step started executing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time that the step stopped executing.
         * </p>
         * 
         * @param endTime
         *        The time that the step stopped executing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The status of the step execution.
         * </p>
         * 
         * @param stepStatus
         *        The status of the step execution.
         * @see StepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepStatus
         */
        Builder stepStatus(String stepStatus);

        /**
         * <p>
         * The status of the step execution.
         * </p>
         * 
         * @param stepStatus
         *        The status of the step execution.
         * @see StepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepStatus
         */
        Builder stepStatus(StepStatus stepStatus);

        /**
         * <p>
         * If this pipeline execution step was cached, details on the cache hit.
         * </p>
         * 
         * @param cacheHitResult
         *        If this pipeline execution step was cached, details on the cache hit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheHitResult(CacheHitResult cacheHitResult);

        /**
         * <p>
         * If this pipeline execution step was cached, details on the cache hit.
         * </p>
         * This is a convenience that creates an instance of the {@link CacheHitResult.Builder} avoiding the need to
         * create one manually via {@link CacheHitResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheHitResult.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheHitResult(CacheHitResult)}.
         * 
         * @param cacheHitResult
         *        a consumer that will call methods on {@link CacheHitResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheHitResult(CacheHitResult)
         */
        default Builder cacheHitResult(Consumer<CacheHitResult.Builder> cacheHitResult) {
            return cacheHitResult(CacheHitResult.builder().applyMutation(cacheHitResult).build());
        }

        /**
         * <p>
         * The reason why the step failed execution. This is only returned if the step failed its execution.
         * </p>
         * 
         * @param failureReason
         *        The reason why the step failed execution. This is only returned if the step failed its execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The metadata for the step execution.
         * </p>
         * 
         * @param metadata
         *        The metadata for the step execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(PipelineExecutionStepMetadata metadata);

        /**
         * <p>
         * The metadata for the step execution.
         * </p>
         * This is a convenience that creates an instance of the {@link PipelineExecutionStepMetadata.Builder} avoiding
         * the need to create one manually via {@link PipelineExecutionStepMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineExecutionStepMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(PipelineExecutionStepMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link PipelineExecutionStepMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(PipelineExecutionStepMetadata)
         */
        default Builder metadata(Consumer<PipelineExecutionStepMetadata.Builder> metadata) {
            return metadata(PipelineExecutionStepMetadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stepName;

        private Instant startTime;

        private Instant endTime;

        private String stepStatus;

        private CacheHitResult cacheHitResult;

        private String failureReason;

        private PipelineExecutionStepMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionStep model) {
            stepName(model.stepName);
            startTime(model.startTime);
            endTime(model.endTime);
            stepStatus(model.stepStatus);
            cacheHitResult(model.cacheHitResult);
            failureReason(model.failureReason);
            metadata(model.metadata);
        }

        public final String getStepName() {
            return stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getStepStatus() {
            return stepStatus;
        }

        @Override
        public final Builder stepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
            return this;
        }

        @Override
        public final Builder stepStatus(StepStatus stepStatus) {
            this.stepStatus(stepStatus == null ? null : stepStatus.toString());
            return this;
        }

        public final void setStepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
        }

        public final CacheHitResult.Builder getCacheHitResult() {
            return cacheHitResult != null ? cacheHitResult.toBuilder() : null;
        }

        @Override
        public final Builder cacheHitResult(CacheHitResult cacheHitResult) {
            this.cacheHitResult = cacheHitResult;
            return this;
        }

        public final void setCacheHitResult(CacheHitResult.BuilderImpl cacheHitResult) {
            this.cacheHitResult = cacheHitResult != null ? cacheHitResult.build() : null;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final PipelineExecutionStepMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(PipelineExecutionStepMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(PipelineExecutionStepMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public PipelineExecutionStep build() {
            return new PipelineExecutionStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
