/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenderUiTemplateRequest extends SageMakerRequest implements
        ToCopyableBuilder<RenderUiTemplateRequest.Builder, RenderUiTemplateRequest> {
    private static final SdkField<UiTemplate> UI_TEMPLATE_FIELD = SdkField.<UiTemplate> builder(MarshallingType.SDK_POJO)
            .memberName("UiTemplate").getter(getter(RenderUiTemplateRequest::uiTemplate)).setter(setter(Builder::uiTemplate))
            .constructor(UiTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UiTemplate").build()).build();

    private static final SdkField<RenderableTask> TASK_FIELD = SdkField.<RenderableTask> builder(MarshallingType.SDK_POJO)
            .memberName("Task").getter(getter(RenderUiTemplateRequest::task)).setter(setter(Builder::task))
            .constructor(RenderableTask::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Task").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(RenderUiTemplateRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> HUMAN_TASK_UI_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanTaskUiArn").getter(getter(RenderUiTemplateRequest::humanTaskUiArn))
            .setter(setter(Builder::humanTaskUiArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UI_TEMPLATE_FIELD, TASK_FIELD,
            ROLE_ARN_FIELD, HUMAN_TASK_UI_ARN_FIELD));

    private final UiTemplate uiTemplate;

    private final RenderableTask task;

    private final String roleArn;

    private final String humanTaskUiArn;

    private RenderUiTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.uiTemplate = builder.uiTemplate;
        this.task = builder.task;
        this.roleArn = builder.roleArn;
        this.humanTaskUiArn = builder.humanTaskUiArn;
    }

    /**
     * <p>
     * A <code>Template</code> object containing the worker UI template to render.
     * </p>
     * 
     * @return A <code>Template</code> object containing the worker UI template to render.
     */
    public final UiTemplate uiTemplate() {
        return uiTemplate;
    }

    /**
     * <p>
     * A <code>RenderableTask</code> object containing a representative task to render.
     * </p>
     * 
     * @return A <code>RenderableTask</code> object containing a representative task to render.
     */
    public final RenderableTask task() {
        return task;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that has access to the S3 objects that are used by the template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that has access to the S3 objects that are used by the template.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The <code>HumanTaskUiArn</code> of the worker UI that you want to render. Do not provide a
     * <code>HumanTaskUiArn</code> if you use the <code>UiTemplate</code> parameter.
     * </p>
     * <p>
     * See a list of available Human Ui Amazon Resource Names (ARNs) in <a>UiConfig</a>.
     * </p>
     * 
     * @return The <code>HumanTaskUiArn</code> of the worker UI that you want to render. Do not provide a
     *         <code>HumanTaskUiArn</code> if you use the <code>UiTemplate</code> parameter.</p>
     *         <p>
     *         See a list of available Human Ui Amazon Resource Names (ARNs) in <a>UiConfig</a>.
     */
    public final String humanTaskUiArn() {
        return humanTaskUiArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(uiTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(task());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenderUiTemplateRequest)) {
            return false;
        }
        RenderUiTemplateRequest other = (RenderUiTemplateRequest) obj;
        return Objects.equals(uiTemplate(), other.uiTemplate()) && Objects.equals(task(), other.task())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(humanTaskUiArn(), other.humanTaskUiArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenderUiTemplateRequest").add("UiTemplate", uiTemplate()).add("Task", task())
                .add("RoleArn", roleArn()).add("HumanTaskUiArn", humanTaskUiArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UiTemplate":
            return Optional.ofNullable(clazz.cast(uiTemplate()));
        case "Task":
            return Optional.ofNullable(clazz.cast(task()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "HumanTaskUiArn":
            return Optional.ofNullable(clazz.cast(humanTaskUiArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenderUiTemplateRequest, T> g) {
        return obj -> g.apply((RenderUiTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, RenderUiTemplateRequest> {
        /**
         * <p>
         * A <code>Template</code> object containing the worker UI template to render.
         * </p>
         * 
         * @param uiTemplate
         *        A <code>Template</code> object containing the worker UI template to render.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uiTemplate(UiTemplate uiTemplate);

        /**
         * <p>
         * A <code>Template</code> object containing the worker UI template to render.
         * </p>
         * This is a convenience that creates an instance of the {@link UiTemplate.Builder} avoiding the need to create
         * one manually via {@link UiTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link UiTemplate.Builder#build()} is called immediately and its result
         * is passed to {@link #uiTemplate(UiTemplate)}.
         * 
         * @param uiTemplate
         *        a consumer that will call methods on {@link UiTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uiTemplate(UiTemplate)
         */
        default Builder uiTemplate(Consumer<UiTemplate.Builder> uiTemplate) {
            return uiTemplate(UiTemplate.builder().applyMutation(uiTemplate).build());
        }

        /**
         * <p>
         * A <code>RenderableTask</code> object containing a representative task to render.
         * </p>
         * 
         * @param task
         *        A <code>RenderableTask</code> object containing a representative task to render.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(RenderableTask task);

        /**
         * <p>
         * A <code>RenderableTask</code> object containing a representative task to render.
         * </p>
         * This is a convenience that creates an instance of the {@link RenderableTask.Builder} avoiding the need to
         * create one manually via {@link RenderableTask#builder()}.
         *
         * When the {@link Consumer} completes, {@link RenderableTask.Builder#build()} is called immediately and its
         * result is passed to {@link #task(RenderableTask)}.
         * 
         * @param task
         *        a consumer that will call methods on {@link RenderableTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #task(RenderableTask)
         */
        default Builder task(Consumer<RenderableTask.Builder> task) {
            return task(RenderableTask.builder().applyMutation(task).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) that has access to the S3 objects that are used by the template.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) that has access to the S3 objects that are used by the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The <code>HumanTaskUiArn</code> of the worker UI that you want to render. Do not provide a
         * <code>HumanTaskUiArn</code> if you use the <code>UiTemplate</code> parameter.
         * </p>
         * <p>
         * See a list of available Human Ui Amazon Resource Names (ARNs) in <a>UiConfig</a>.
         * </p>
         * 
         * @param humanTaskUiArn
         *        The <code>HumanTaskUiArn</code> of the worker UI that you want to render. Do not provide a
         *        <code>HumanTaskUiArn</code> if you use the <code>UiTemplate</code> parameter.</p>
         *        <p>
         *        See a list of available Human Ui Amazon Resource Names (ARNs) in <a>UiConfig</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiArn(String humanTaskUiArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private UiTemplate uiTemplate;

        private RenderableTask task;

        private String roleArn;

        private String humanTaskUiArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RenderUiTemplateRequest model) {
            super(model);
            uiTemplate(model.uiTemplate);
            task(model.task);
            roleArn(model.roleArn);
            humanTaskUiArn(model.humanTaskUiArn);
        }

        public final UiTemplate.Builder getUiTemplate() {
            return uiTemplate != null ? uiTemplate.toBuilder() : null;
        }

        @Override
        public final Builder uiTemplate(UiTemplate uiTemplate) {
            this.uiTemplate = uiTemplate;
            return this;
        }

        public final void setUiTemplate(UiTemplate.BuilderImpl uiTemplate) {
            this.uiTemplate = uiTemplate != null ? uiTemplate.build() : null;
        }

        public final RenderableTask.Builder getTask() {
            return task != null ? task.toBuilder() : null;
        }

        @Override
        public final Builder task(RenderableTask task) {
            this.task = task;
            return this;
        }

        public final void setTask(RenderableTask.BuilderImpl task) {
            this.task = task != null ? task.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getHumanTaskUiArn() {
            return humanTaskUiArn;
        }

        @Override
        public final Builder humanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
            return this;
        }

        public final void setHumanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RenderUiTemplateRequest build() {
            return new RenderUiTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
