/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelQualityJobDefinitionsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListModelQualityJobDefinitionsResponse> {
    private static final SdkField<List<MonitoringJobDefinitionSummary>> JOB_DEFINITION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobDefinitionSummaries").getter(ListModelQualityJobDefinitionsResponse.getter(ListModelQualityJobDefinitionsResponse::jobDefinitionSummaries)).setter(ListModelQualityJobDefinitionsResponse.setter(Builder::jobDefinitionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitoringJobDefinitionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelQualityJobDefinitionsResponse.getter(ListModelQualityJobDefinitionsResponse::nextToken)).setter(ListModelQualityJobDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<MonitoringJobDefinitionSummary> jobDefinitionSummaries;
    private final String nextToken;

    private ListModelQualityJobDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionSummaries = builder.jobDefinitionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobDefinitionSummaries() {
        return this.jobDefinitionSummaries != null && !(this.jobDefinitionSummaries instanceof SdkAutoConstructList);
    }

    public final List<MonitoringJobDefinitionSummary> jobDefinitionSummaries() {
        return this.jobDefinitionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobDefinitionSummaries() ? this.jobDefinitionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelQualityJobDefinitionsResponse)) {
            return false;
        }
        ListModelQualityJobDefinitionsResponse other = (ListModelQualityJobDefinitionsResponse)((Object)obj);
        return this.hasJobDefinitionSummaries() == other.hasJobDefinitionSummaries() && Objects.equals(this.jobDefinitionSummaries(), other.jobDefinitionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelQualityJobDefinitionsResponse").add("JobDefinitionSummaries", this.hasJobDefinitionSummaries() ? this.jobDefinitionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobDefinitionSummaries": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelQualityJobDefinitionsResponse, T> g) {
        return obj -> g.apply((ListModelQualityJobDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<MonitoringJobDefinitionSummary> jobDefinitionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelQualityJobDefinitionsResponse model) {
            super(model);
            this.jobDefinitionSummaries(model.jobDefinitionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<MonitoringJobDefinitionSummary.Builder> getJobDefinitionSummaries() {
            List<MonitoringJobDefinitionSummary.Builder> result = MonitoringJobDefinitionSummaryListCopier.copyToBuilder(this.jobDefinitionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder jobDefinitionSummaries(Collection<MonitoringJobDefinitionSummary> jobDefinitionSummaries) {
            this.jobDefinitionSummaries = MonitoringJobDefinitionSummaryListCopier.copy(jobDefinitionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitionSummaries(MonitoringJobDefinitionSummary ... jobDefinitionSummaries) {
            this.jobDefinitionSummaries(Arrays.asList(jobDefinitionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitionSummaries(Consumer<MonitoringJobDefinitionSummary.Builder> ... jobDefinitionSummaries) {
            this.jobDefinitionSummaries(Stream.of(jobDefinitionSummaries).map(c -> (MonitoringJobDefinitionSummary)((MonitoringJobDefinitionSummary.Builder)MonitoringJobDefinitionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobDefinitionSummaries(Collection<MonitoringJobDefinitionSummary.BuilderImpl> jobDefinitionSummaries) {
            this.jobDefinitionSummaries = MonitoringJobDefinitionSummaryListCopier.copyFromBuilder(jobDefinitionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListModelQualityJobDefinitionsResponse build() {
            return new ListModelQualityJobDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelQualityJobDefinitionsResponse> {
        public Builder jobDefinitionSummaries(Collection<MonitoringJobDefinitionSummary> var1);

        public Builder jobDefinitionSummaries(MonitoringJobDefinitionSummary ... var1);

        public Builder jobDefinitionSummaries(Consumer<MonitoringJobDefinitionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

