/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListAppsResponse.Builder, ListAppsResponse> {
    private static final SdkField<List<AppDetails>> APPS_FIELD = SdkField
            .<List<AppDetails>> builder(MarshallingType.LIST)
            .memberName("Apps")
            .getter(getter(ListAppsResponse::apps))
            .setter(setter(Builder::apps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Apps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAppsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_FIELD, NEXT_TOKEN_FIELD));

    private final List<AppDetails> apps;

    private final String nextToken;

    private ListAppsResponse(BuilderImpl builder) {
        super(builder);
        this.apps = builder.apps;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Apps property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasApps() {
        return apps != null && !(apps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of apps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of apps.
     */
    public final List<AppDetails> apps() {
        return apps;
    }

    /**
     * <p>
     * If the previous response was truncated, you will receive this token. Use it in your next request to receive the
     * next set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you will receive this token. Use it in your next request to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApps() ? apps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsResponse)) {
            return false;
        }
        ListAppsResponse other = (ListAppsResponse) obj;
        return hasApps() == other.hasApps() && Objects.equals(apps(), other.apps())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppsResponse").add("Apps", hasApps() ? apps() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Apps":
            return Optional.ofNullable(clazz.cast(apps()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppsResponse, T> g) {
        return obj -> g.apply((ListAppsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAppsResponse> {
        /**
         * <p>
         * The list of apps.
         * </p>
         * 
         * @param apps
         *        The list of apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apps(Collection<AppDetails> apps);

        /**
         * <p>
         * The list of apps.
         * </p>
         * 
         * @param apps
         *        The list of apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apps(AppDetails... apps);

        /**
         * <p>
         * The list of apps.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AppDetails>.Builder} avoiding the need to
         * create one manually via {@link List<AppDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AppDetails>.Builder#build()} is called immediately and its
         * result is passed to {@link #apps(List<AppDetails>)}.
         * 
         * @param apps
         *        a consumer that will call methods on {@link List<AppDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apps(List<AppDetails>)
         */
        Builder apps(Consumer<AppDetails.Builder>... apps);

        /**
         * <p>
         * If the previous response was truncated, you will receive this token. Use it in your next request to receive
         * the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you will receive this token. Use it in your next request to
         *        receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<AppDetails> apps = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppsResponse model) {
            super(model);
            apps(model.apps);
            nextToken(model.nextToken);
        }

        public final List<AppDetails.Builder> getApps() {
            List<AppDetails.Builder> result = AppListCopier.copyToBuilder(this.apps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder apps(Collection<AppDetails> apps) {
            this.apps = AppListCopier.copy(apps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(AppDetails... apps) {
            apps(Arrays.asList(apps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(Consumer<AppDetails.Builder>... apps) {
            apps(Stream.of(apps).map(c -> AppDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApps(Collection<AppDetails.BuilderImpl> apps) {
            this.apps = AppListCopier.copyFromBuilder(apps);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAppsResponse build() {
            return new ListAppsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
