/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImagesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListImagesResponse.Builder, ListImagesResponse> {
    private static final SdkField<List<Image>> IMAGES_FIELD = SdkField
            .<List<Image>> builder(MarshallingType.LIST)
            .memberName("Images")
            .getter(getter(ListImagesResponse::images))
            .setter(setter(Builder::images))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Images").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Image> builder(MarshallingType.SDK_POJO)
                                            .constructor(Image::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListImagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IMAGES_FIELD, NEXT_TOKEN_FIELD));

    private final List<Image> images;

    private final String nextToken;

    private ListImagesResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Images property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasImages() {
        return images != null && !(images instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of images and their properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of images and their properties.
     */
    public final List<Image> images() {
        return images;
    }

    /**
     * <p>
     * A token for getting the next set of images, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of images, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImages() ? images() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesResponse)) {
            return false;
        }
        ListImagesResponse other = (ListImagesResponse) obj;
        return hasImages() == other.hasImages() && Objects.equals(images(), other.images())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImagesResponse").add("Images", hasImages() ? images() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Images":
            return Optional.ofNullable(clazz.cast(images()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImagesResponse, T> g) {
        return obj -> g.apply((ListImagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListImagesResponse> {
        /**
         * <p>
         * A list of images and their properties.
         * </p>
         * 
         * @param images
         *        A list of images and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Collection<Image> images);

        /**
         * <p>
         * A list of images and their properties.
         * </p>
         * 
         * @param images
         *        A list of images and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Image... images);

        /**
         * <p>
         * A list of images and their properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Image>.Builder} avoiding the need to create
         * one manually via {@link List<Image>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Image>.Builder#build()} is called immediately and its result
         * is passed to {@link #images(List<Image>)}.
         * 
         * @param images
         *        a consumer that will call methods on {@link List<Image>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(List<Image>)
         */
        Builder images(Consumer<Image.Builder>... images);

        /**
         * <p>
         * A token for getting the next set of images, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of images, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<Image> images = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagesResponse model) {
            super(model);
            images(model.images);
            nextToken(model.nextToken);
        }

        public final List<Image.Builder> getImages() {
            List<Image.Builder> result = ImagesCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder images(Collection<Image> images) {
            this.images = ImagesCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Image... images) {
            images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<Image.Builder>... images) {
            images(Stream.of(images).map(c -> Image.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImages(Collection<Image.BuilderImpl> images) {
            this.images = ImagesCopier.copyFromBuilder(images);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListImagesResponse build() {
            return new ListImagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
