/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of features. You must include <code>FeatureName</code> and <code>FeatureType</code>. Valid feature
 * <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FeatureDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<FeatureDefinition.Builder, FeatureDefinition> {
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureName").getter(getter(FeatureDefinition::featureName)).setter(setter(Builder::featureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()).build();

    private static final SdkField<String> FEATURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureType").getter(getter(FeatureDefinition::featureTypeAsString))
            .setter(setter(Builder::featureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_NAME_FIELD,
            FEATURE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String featureName;

    private final String featureType;

    private FeatureDefinition(BuilderImpl builder) {
        this.featureName = builder.featureName;
        this.featureType = builder.featureType;
    }

    /**
     * <p>
     * The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any of the following:
     * <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code>.
     * </p>
     * 
     * @return The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any of the
     *         following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code>.
     */
    public final String featureName() {
        return featureName;
    }

    /**
     * <p>
     * The value type of a feature. Valid values are Integral, Fractional, or String.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureType} will
     * return {@link FeatureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureTypeAsString}.
     * </p>
     * 
     * @return The value type of a feature. Valid values are Integral, Fractional, or String.
     * @see FeatureType
     */
    public final FeatureType featureType() {
        return FeatureType.fromValue(featureType);
    }

    /**
     * <p>
     * The value type of a feature. Valid values are Integral, Fractional, or String.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureType} will
     * return {@link FeatureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureTypeAsString}.
     * </p>
     * 
     * @return The value type of a feature. Valid values are Integral, Fractional, or String.
     * @see FeatureType
     */
    public final String featureTypeAsString() {
        return featureType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureName());
        hashCode = 31 * hashCode + Objects.hashCode(featureTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureDefinition)) {
            return false;
        }
        FeatureDefinition other = (FeatureDefinition) obj;
        return Objects.equals(featureName(), other.featureName())
                && Objects.equals(featureTypeAsString(), other.featureTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FeatureDefinition").add("FeatureName", featureName()).add("FeatureType", featureTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureName":
            return Optional.ofNullable(clazz.cast(featureName()));
        case "FeatureType":
            return Optional.ofNullable(clazz.cast(featureTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FeatureDefinition, T> g) {
        return obj -> g.apply((FeatureDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FeatureDefinition> {
        /**
         * <p>
         * The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any of the following:
         * <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code>.
         * </p>
         * 
         * @param featureName
         *        The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any of the
         *        following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureName(String featureName);

        /**
         * <p>
         * The value type of a feature. Valid values are Integral, Fractional, or String.
         * </p>
         * 
         * @param featureType
         *        The value type of a feature. Valid values are Integral, Fractional, or String.
         * @see FeatureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureType
         */
        Builder featureType(String featureType);

        /**
         * <p>
         * The value type of a feature. Valid values are Integral, Fractional, or String.
         * </p>
         * 
         * @param featureType
         *        The value type of a feature. Valid values are Integral, Fractional, or String.
         * @see FeatureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureType
         */
        Builder featureType(FeatureType featureType);
    }

    static final class BuilderImpl implements Builder {
        private String featureName;

        private String featureType;

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureDefinition model) {
            featureName(model.featureName);
            featureType(model.featureType);
        }

        public final String getFeatureName() {
            return featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        public final String getFeatureType() {
            return featureType;
        }

        @Override
        public final Builder featureType(String featureType) {
            this.featureType = featureType;
            return this;
        }

        @Override
        public final Builder featureType(FeatureType featureType) {
            this.featureType(featureType == null ? null : featureType.toString());
            return this;
        }

        public final void setFeatureType(String featureType) {
            this.featureType = featureType;
        }

        @Override
        public FeatureDefinition build() {
            return new FeatureDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
