/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata for a step execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineExecutionStepMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineExecutionStepMetadata.Builder, PipelineExecutionStepMetadata> {
    private static final SdkField<TrainingJobStepMetadata> TRAINING_JOB_FIELD = SdkField
            .<TrainingJobStepMetadata> builder(MarshallingType.SDK_POJO).memberName("TrainingJob")
            .getter(getter(PipelineExecutionStepMetadata::trainingJob)).setter(setter(Builder::trainingJob))
            .constructor(TrainingJobStepMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJob").build()).build();

    private static final SdkField<ProcessingJobStepMetadata> PROCESSING_JOB_FIELD = SdkField
            .<ProcessingJobStepMetadata> builder(MarshallingType.SDK_POJO).memberName("ProcessingJob")
            .getter(getter(PipelineExecutionStepMetadata::processingJob)).setter(setter(Builder::processingJob))
            .constructor(ProcessingJobStepMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJob").build()).build();

    private static final SdkField<TransformJobStepMetadata> TRANSFORM_JOB_FIELD = SdkField
            .<TransformJobStepMetadata> builder(MarshallingType.SDK_POJO).memberName("TransformJob")
            .getter(getter(PipelineExecutionStepMetadata::transformJob)).setter(setter(Builder::transformJob))
            .constructor(TransformJobStepMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJob").build()).build();

    private static final SdkField<TuningJobStepMetaData> TUNING_JOB_FIELD = SdkField
            .<TuningJobStepMetaData> builder(MarshallingType.SDK_POJO).memberName("TuningJob")
            .getter(getter(PipelineExecutionStepMetadata::tuningJob)).setter(setter(Builder::tuningJob))
            .constructor(TuningJobStepMetaData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningJob").build()).build();

    private static final SdkField<ModelStepMetadata> MODEL_FIELD = SdkField.<ModelStepMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("Model").getter(getter(PipelineExecutionStepMetadata::model)).setter(setter(Builder::model))
            .constructor(ModelStepMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<RegisterModelStepMetadata> REGISTER_MODEL_FIELD = SdkField
            .<RegisterModelStepMetadata> builder(MarshallingType.SDK_POJO).memberName("RegisterModel")
            .getter(getter(PipelineExecutionStepMetadata::registerModel)).setter(setter(Builder::registerModel))
            .constructor(RegisterModelStepMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisterModel").build()).build();

    private static final SdkField<ConditionStepMetadata> CONDITION_FIELD = SdkField
            .<ConditionStepMetadata> builder(MarshallingType.SDK_POJO).memberName("Condition")
            .getter(getter(PipelineExecutionStepMetadata::condition)).setter(setter(Builder::condition))
            .constructor(ConditionStepMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<CallbackStepMetadata> CALLBACK_FIELD = SdkField
            .<CallbackStepMetadata> builder(MarshallingType.SDK_POJO).memberName("Callback")
            .getter(getter(PipelineExecutionStepMetadata::callback)).setter(setter(Builder::callback))
            .constructor(CallbackStepMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Callback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_FIELD,
            PROCESSING_JOB_FIELD, TRANSFORM_JOB_FIELD, TUNING_JOB_FIELD, MODEL_FIELD, REGISTER_MODEL_FIELD, CONDITION_FIELD,
            CALLBACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final TrainingJobStepMetadata trainingJob;

    private final ProcessingJobStepMetadata processingJob;

    private final TransformJobStepMetadata transformJob;

    private final TuningJobStepMetaData tuningJob;

    private final ModelStepMetadata model;

    private final RegisterModelStepMetadata registerModel;

    private final ConditionStepMetadata condition;

    private final CallbackStepMetadata callback;

    private PipelineExecutionStepMetadata(BuilderImpl builder) {
        this.trainingJob = builder.trainingJob;
        this.processingJob = builder.processingJob;
        this.transformJob = builder.transformJob;
        this.tuningJob = builder.tuningJob;
        this.model = builder.model;
        this.registerModel = builder.registerModel;
        this.condition = builder.condition;
        this.callback = builder.callback;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the training job that was run by this step execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the training job that was run by this step execution.
     */
    public final TrainingJobStepMetadata trainingJob() {
        return trainingJob;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the processing job that was run by this step execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the processing job that was run by this step execution.
     */
    public final ProcessingJobStepMetadata processingJob() {
        return processingJob;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the transform job that was run by this step execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the transform job that was run by this step execution.
     */
    public final TransformJobStepMetadata transformJob() {
        return transformJob;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the tuning job that was run by this step execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the tuning job that was run by this step execution.
     */
    public final TuningJobStepMetaData tuningJob() {
        return tuningJob;
    }

    /**
     * <p>
     * Metadata for the Model step.
     * </p>
     * 
     * @return Metadata for the Model step.
     */
    public final ModelStepMetadata model() {
        return model;
    }

    /**
     * <p>
     * Metadata for the RegisterModel step.
     * </p>
     * 
     * @return Metadata for the RegisterModel step.
     */
    public final RegisterModelStepMetadata registerModel() {
        return registerModel;
    }

    /**
     * <p>
     * If this is a Condition step metadata object, details on the condition.
     * </p>
     * 
     * @return If this is a Condition step metadata object, details on the condition.
     */
    public final ConditionStepMetadata condition() {
        return condition;
    }

    /**
     * Returns the value of the Callback property for this object.
     * 
     * @return The value of the Callback property for this object.
     */
    public final CallbackStepMetadata callback() {
        return callback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(processingJob());
        hashCode = 31 * hashCode + Objects.hashCode(transformJob());
        hashCode = 31 * hashCode + Objects.hashCode(tuningJob());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(registerModel());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(callback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionStepMetadata)) {
            return false;
        }
        PipelineExecutionStepMetadata other = (PipelineExecutionStepMetadata) obj;
        return Objects.equals(trainingJob(), other.trainingJob()) && Objects.equals(processingJob(), other.processingJob())
                && Objects.equals(transformJob(), other.transformJob()) && Objects.equals(tuningJob(), other.tuningJob())
                && Objects.equals(model(), other.model()) && Objects.equals(registerModel(), other.registerModel())
                && Objects.equals(condition(), other.condition()) && Objects.equals(callback(), other.callback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineExecutionStepMetadata").add("TrainingJob", trainingJob())
                .add("ProcessingJob", processingJob()).add("TransformJob", transformJob()).add("TuningJob", tuningJob())
                .add("Model", model()).add("RegisterModel", registerModel()).add("Condition", condition())
                .add("Callback", callback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingJob":
            return Optional.ofNullable(clazz.cast(trainingJob()));
        case "ProcessingJob":
            return Optional.ofNullable(clazz.cast(processingJob()));
        case "TransformJob":
            return Optional.ofNullable(clazz.cast(transformJob()));
        case "TuningJob":
            return Optional.ofNullable(clazz.cast(tuningJob()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "RegisterModel":
            return Optional.ofNullable(clazz.cast(registerModel()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "Callback":
            return Optional.ofNullable(clazz.cast(callback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecutionStepMetadata, T> g) {
        return obj -> g.apply((PipelineExecutionStepMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineExecutionStepMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training job that was run by this step execution.
         * </p>
         * 
         * @param trainingJob
         *        The Amazon Resource Name (ARN) of the training job that was run by this step execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJob(TrainingJobStepMetadata trainingJob);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training job that was run by this step execution.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingJobStepMetadata.Builder} avoiding the
         * need to create one manually via {@link TrainingJobStepMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingJobStepMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #trainingJob(TrainingJobStepMetadata)}.
         * 
         * @param trainingJob
         *        a consumer that will call methods on {@link TrainingJobStepMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJob(TrainingJobStepMetadata)
         */
        default Builder trainingJob(Consumer<TrainingJobStepMetadata.Builder> trainingJob) {
            return trainingJob(TrainingJobStepMetadata.builder().applyMutation(trainingJob).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the processing job that was run by this step execution.
         * </p>
         * 
         * @param processingJob
         *        The Amazon Resource Name (ARN) of the processing job that was run by this step execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJob(ProcessingJobStepMetadata processingJob);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the processing job that was run by this step execution.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingJobStepMetadata.Builder} avoiding the
         * need to create one manually via {@link ProcessingJobStepMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingJobStepMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #processingJob(ProcessingJobStepMetadata)}.
         * 
         * @param processingJob
         *        a consumer that will call methods on {@link ProcessingJobStepMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingJob(ProcessingJobStepMetadata)
         */
        default Builder processingJob(Consumer<ProcessingJobStepMetadata.Builder> processingJob) {
            return processingJob(ProcessingJobStepMetadata.builder().applyMutation(processingJob).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the transform job that was run by this step execution.
         * </p>
         * 
         * @param transformJob
         *        The Amazon Resource Name (ARN) of the transform job that was run by this step execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformJob(TransformJobStepMetadata transformJob);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the transform job that was run by this step execution.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformJobStepMetadata.Builder} avoiding the
         * need to create one manually via {@link TransformJobStepMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformJobStepMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #transformJob(TransformJobStepMetadata)}.
         * 
         * @param transformJob
         *        a consumer that will call methods on {@link TransformJobStepMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformJob(TransformJobStepMetadata)
         */
        default Builder transformJob(Consumer<TransformJobStepMetadata.Builder> transformJob) {
            return transformJob(TransformJobStepMetadata.builder().applyMutation(transformJob).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the tuning job that was run by this step execution.
         * </p>
         * 
         * @param tuningJob
         *        The Amazon Resource Name (ARN) of the tuning job that was run by this step execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tuningJob(TuningJobStepMetaData tuningJob);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the tuning job that was run by this step execution.
         * </p>
         * This is a convenience that creates an instance of the {@link TuningJobStepMetaData.Builder} avoiding the need
         * to create one manually via {@link TuningJobStepMetaData#builder()}.
         *
         * When the {@link Consumer} completes, {@link TuningJobStepMetaData.Builder#build()} is called immediately and
         * its result is passed to {@link #tuningJob(TuningJobStepMetaData)}.
         * 
         * @param tuningJob
         *        a consumer that will call methods on {@link TuningJobStepMetaData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tuningJob(TuningJobStepMetaData)
         */
        default Builder tuningJob(Consumer<TuningJobStepMetaData.Builder> tuningJob) {
            return tuningJob(TuningJobStepMetaData.builder().applyMutation(tuningJob).build());
        }

        /**
         * <p>
         * Metadata for the Model step.
         * </p>
         * 
         * @param model
         *        Metadata for the Model step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(ModelStepMetadata model);

        /**
         * <p>
         * Metadata for the Model step.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelStepMetadata.Builder} avoiding the need to
         * create one manually via {@link ModelStepMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelStepMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #model(ModelStepMetadata)}.
         * 
         * @param model
         *        a consumer that will call methods on {@link ModelStepMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #model(ModelStepMetadata)
         */
        default Builder model(Consumer<ModelStepMetadata.Builder> model) {
            return model(ModelStepMetadata.builder().applyMutation(model).build());
        }

        /**
         * <p>
         * Metadata for the RegisterModel step.
         * </p>
         * 
         * @param registerModel
         *        Metadata for the RegisterModel step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registerModel(RegisterModelStepMetadata registerModel);

        /**
         * <p>
         * Metadata for the RegisterModel step.
         * </p>
         * This is a convenience that creates an instance of the {@link RegisterModelStepMetadata.Builder} avoiding the
         * need to create one manually via {@link RegisterModelStepMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegisterModelStepMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #registerModel(RegisterModelStepMetadata)}.
         * 
         * @param registerModel
         *        a consumer that will call methods on {@link RegisterModelStepMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registerModel(RegisterModelStepMetadata)
         */
        default Builder registerModel(Consumer<RegisterModelStepMetadata.Builder> registerModel) {
            return registerModel(RegisterModelStepMetadata.builder().applyMutation(registerModel).build());
        }

        /**
         * <p>
         * If this is a Condition step metadata object, details on the condition.
         * </p>
         * 
         * @param condition
         *        If this is a Condition step metadata object, details on the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(ConditionStepMetadata condition);

        /**
         * <p>
         * If this is a Condition step metadata object, details on the condition.
         * </p>
         * This is a convenience that creates an instance of the {@link ConditionStepMetadata.Builder} avoiding the need
         * to create one manually via {@link ConditionStepMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConditionStepMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #condition(ConditionStepMetadata)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link ConditionStepMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(ConditionStepMetadata)
         */
        default Builder condition(Consumer<ConditionStepMetadata.Builder> condition) {
            return condition(ConditionStepMetadata.builder().applyMutation(condition).build());
        }

        /**
         * Sets the value of the Callback property for this object.
         *
         * @param callback
         *        The new value for the Callback property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callback(CallbackStepMetadata callback);

        /**
         * Sets the value of the Callback property for this object.
         *
         * This is a convenience that creates an instance of the {@link CallbackStepMetadata.Builder} avoiding the need
         * to create one manually via {@link CallbackStepMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link CallbackStepMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #callback(CallbackStepMetadata)}.
         * 
         * @param callback
         *        a consumer that will call methods on {@link CallbackStepMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callback(CallbackStepMetadata)
         */
        default Builder callback(Consumer<CallbackStepMetadata.Builder> callback) {
            return callback(CallbackStepMetadata.builder().applyMutation(callback).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TrainingJobStepMetadata trainingJob;

        private ProcessingJobStepMetadata processingJob;

        private TransformJobStepMetadata transformJob;

        private TuningJobStepMetaData tuningJob;

        private ModelStepMetadata model;

        private RegisterModelStepMetadata registerModel;

        private ConditionStepMetadata condition;

        private CallbackStepMetadata callback;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionStepMetadata model) {
            trainingJob(model.trainingJob);
            processingJob(model.processingJob);
            transformJob(model.transformJob);
            tuningJob(model.tuningJob);
            model(model.model);
            registerModel(model.registerModel);
            condition(model.condition);
            callback(model.callback);
        }

        public final TrainingJobStepMetadata.Builder getTrainingJob() {
            return trainingJob != null ? trainingJob.toBuilder() : null;
        }

        @Override
        public final Builder trainingJob(TrainingJobStepMetadata trainingJob) {
            this.trainingJob = trainingJob;
            return this;
        }

        public final void setTrainingJob(TrainingJobStepMetadata.BuilderImpl trainingJob) {
            this.trainingJob = trainingJob != null ? trainingJob.build() : null;
        }

        public final ProcessingJobStepMetadata.Builder getProcessingJob() {
            return processingJob != null ? processingJob.toBuilder() : null;
        }

        @Override
        public final Builder processingJob(ProcessingJobStepMetadata processingJob) {
            this.processingJob = processingJob;
            return this;
        }

        public final void setProcessingJob(ProcessingJobStepMetadata.BuilderImpl processingJob) {
            this.processingJob = processingJob != null ? processingJob.build() : null;
        }

        public final TransformJobStepMetadata.Builder getTransformJob() {
            return transformJob != null ? transformJob.toBuilder() : null;
        }

        @Override
        public final Builder transformJob(TransformJobStepMetadata transformJob) {
            this.transformJob = transformJob;
            return this;
        }

        public final void setTransformJob(TransformJobStepMetadata.BuilderImpl transformJob) {
            this.transformJob = transformJob != null ? transformJob.build() : null;
        }

        public final TuningJobStepMetaData.Builder getTuningJob() {
            return tuningJob != null ? tuningJob.toBuilder() : null;
        }

        @Override
        public final Builder tuningJob(TuningJobStepMetaData tuningJob) {
            this.tuningJob = tuningJob;
            return this;
        }

        public final void setTuningJob(TuningJobStepMetaData.BuilderImpl tuningJob) {
            this.tuningJob = tuningJob != null ? tuningJob.build() : null;
        }

        public final ModelStepMetadata.Builder getModel() {
            return model != null ? model.toBuilder() : null;
        }

        @Override
        public final Builder model(ModelStepMetadata model) {
            this.model = model;
            return this;
        }

        public final void setModel(ModelStepMetadata.BuilderImpl model) {
            this.model = model != null ? model.build() : null;
        }

        public final RegisterModelStepMetadata.Builder getRegisterModel() {
            return registerModel != null ? registerModel.toBuilder() : null;
        }

        @Override
        public final Builder registerModel(RegisterModelStepMetadata registerModel) {
            this.registerModel = registerModel;
            return this;
        }

        public final void setRegisterModel(RegisterModelStepMetadata.BuilderImpl registerModel) {
            this.registerModel = registerModel != null ? registerModel.build() : null;
        }

        public final ConditionStepMetadata.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        @Override
        public final Builder condition(ConditionStepMetadata condition) {
            this.condition = condition;
            return this;
        }

        public final void setCondition(ConditionStepMetadata.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        public final CallbackStepMetadata.Builder getCallback() {
            return callback != null ? callback.toBuilder() : null;
        }

        @Override
        public final Builder callback(CallbackStepMetadata callback) {
            this.callback = callback;
            return this;
        }

        public final void setCallback(CallbackStepMetadata.BuilderImpl callback) {
            this.callback = callback != null ? callback.build() : null;
        }

        @Override
        public PipelineExecutionStepMetadata build() {
            return new PipelineExecutionStepMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
