/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.Parameter;
import software.amazon.awssdk.services.sagemaker.model.ParameterListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipelineParametersForExecutionResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListPipelineParametersForExecutionResponse> {
    private static final SdkField<List<Parameter>> PIPELINE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineParameters").getter(ListPipelineParametersForExecutionResponse.getter(ListPipelineParametersForExecutionResponse::pipelineParameters)).setter(ListPipelineParametersForExecutionResponse.setter(Builder::pipelineParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPipelineParametersForExecutionResponse.getter(ListPipelineParametersForExecutionResponse::nextToken)).setter(ListPipelineParametersForExecutionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_PARAMETERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Parameter> pipelineParameters;
    private final String nextToken;

    private ListPipelineParametersForExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineParameters = builder.pipelineParameters;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPipelineParameters() {
        return this.pipelineParameters != null && !(this.pipelineParameters instanceof SdkAutoConstructList);
    }

    public final List<Parameter> pipelineParameters() {
        return this.pipelineParameters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineParameters() ? this.pipelineParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineParametersForExecutionResponse)) {
            return false;
        }
        ListPipelineParametersForExecutionResponse other = (ListPipelineParametersForExecutionResponse)((Object)obj);
        return this.hasPipelineParameters() == other.hasPipelineParameters() && Objects.equals(this.pipelineParameters(), other.pipelineParameters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipelineParametersForExecutionResponse").add("PipelineParameters", this.hasPipelineParameters() ? this.pipelineParameters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineParameters": {
                return Optional.ofNullable(clazz.cast(this.pipelineParameters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineParametersForExecutionResponse, T> g) {
        return obj -> g.apply((ListPipelineParametersForExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<Parameter> pipelineParameters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineParametersForExecutionResponse model) {
            super(model);
            this.pipelineParameters(model.pipelineParameters);
            this.nextToken(model.nextToken);
        }

        public final List<Parameter.Builder> getPipelineParameters() {
            List<Parameter.Builder> result = ParameterListCopier.copyToBuilder(this.pipelineParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder pipelineParameters(Collection<Parameter> pipelineParameters) {
            this.pipelineParameters = ParameterListCopier.copy(pipelineParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineParameters(Parameter ... pipelineParameters) {
            this.pipelineParameters(Arrays.asList(pipelineParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineParameters(Consumer<Parameter.Builder> ... pipelineParameters) {
            this.pipelineParameters(Stream.of(pipelineParameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineParameters(Collection<Parameter.BuilderImpl> pipelineParameters) {
            this.pipelineParameters = ParameterListCopier.copyFromBuilder(pipelineParameters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPipelineParametersForExecutionResponse build() {
            return new ListPipelineParametersForExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipelineParametersForExecutionResponse> {
        public Builder pipelineParameters(Collection<Parameter> var1);

        public Builder pipelineParameters(Parameter ... var1);

        public Builder pipelineParameters(Consumer<Parameter.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

