/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists a summary of the properties of a lineage group. A lineage group provides a group of shareable lineage entity
 * resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineageGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LineageGroupSummary.Builder, LineageGroupSummary> {
    private static final SdkField<String> LINEAGE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineageGroupArn").getter(getter(LineageGroupSummary::lineageGroupArn))
            .setter(setter(Builder::lineageGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageGroupArn").build()).build();

    private static final SdkField<String> LINEAGE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineageGroupName").getter(getter(LineageGroupSummary::lineageGroupName))
            .setter(setter(Builder::lineageGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageGroupName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(LineageGroupSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(LineageGroupSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(LineageGroupSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINEAGE_GROUP_ARN_FIELD,
            LINEAGE_GROUP_NAME_FIELD, DISPLAY_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lineageGroupArn;

    private final String lineageGroupName;

    private final String displayName;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private LineageGroupSummary(BuilderImpl builder) {
        this.lineageGroupArn = builder.lineageGroupArn;
        this.lineageGroupName = builder.lineageGroupName;
        this.displayName = builder.displayName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lineage group resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lineage group resource.
     */
    public final String lineageGroupArn() {
        return lineageGroupArn;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the lineage group.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the lineage group.
     */
    public final String lineageGroupName() {
        return lineageGroupName;
    }

    /**
     * <p>
     * The display name of the lineage group summary.
     * </p>
     * 
     * @return The display name of the lineage group summary.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The creation time of the lineage group summary.
     * </p>
     * 
     * @return The creation time of the lineage group summary.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last modified time of the lineage group summary.
     * </p>
     * 
     * @return The last modified time of the lineage group summary.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lineageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(lineageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageGroupSummary)) {
            return false;
        }
        LineageGroupSummary other = (LineageGroupSummary) obj;
        return Objects.equals(lineageGroupArn(), other.lineageGroupArn())
                && Objects.equals(lineageGroupName(), other.lineageGroupName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineageGroupSummary").add("LineageGroupArn", lineageGroupArn())
                .add("LineageGroupName", lineageGroupName()).add("DisplayName", displayName())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LineageGroupArn":
            return Optional.ofNullable(clazz.cast(lineageGroupArn()));
        case "LineageGroupName":
            return Optional.ofNullable(clazz.cast(lineageGroupName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineageGroupSummary, T> g) {
        return obj -> g.apply((LineageGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineageGroupSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lineage group resource.
         * </p>
         * 
         * @param lineageGroupArn
         *        The Amazon Resource Name (ARN) of the lineage group resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageGroupArn(String lineageGroupArn);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the lineage group.
         * </p>
         * 
         * @param lineageGroupName
         *        The name or Amazon Resource Name (ARN) of the lineage group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageGroupName(String lineageGroupName);

        /**
         * <p>
         * The display name of the lineage group summary.
         * </p>
         * 
         * @param displayName
         *        The display name of the lineage group summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The creation time of the lineage group summary.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the lineage group summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last modified time of the lineage group summary.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last modified time of the lineage group summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String lineageGroupArn;

        private String lineageGroupName;

        private String displayName;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageGroupSummary model) {
            lineageGroupArn(model.lineageGroupArn);
            lineageGroupName(model.lineageGroupName);
            displayName(model.displayName);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getLineageGroupArn() {
            return lineageGroupArn;
        }

        public final void setLineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
        }

        @Override
        @Transient
        public final Builder lineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
            return this;
        }

        public final String getLineageGroupName() {
            return lineageGroupName;
        }

        public final void setLineageGroupName(String lineageGroupName) {
            this.lineageGroupName = lineageGroupName;
        }

        @Override
        @Transient
        public final Builder lineageGroupName(String lineageGroupName) {
            this.lineageGroupName = lineageGroupName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public LineageGroupSummary build() {
            return new LineageGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
