/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartPipelineExecutionRequest extends SageMakerRequest implements
        ToCopyableBuilder<StartPipelineExecutionRequest.Builder, StartPipelineExecutionRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineName").getter(getter(StartPipelineExecutionRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionDisplayName")
            .getter(getter(StartPipelineExecutionRequest::pipelineExecutionDisplayName))
            .setter(setter(Builder::pipelineExecutionDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDisplayName")
                    .build()).build();

    private static final SdkField<List<Parameter>> PIPELINE_PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("PipelineParameters")
            .getter(getter(StartPipelineExecutionRequest::pipelineParameters))
            .setter(setter(Builder::pipelineParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionDescription")
            .getter(getter(StartPipelineExecutionRequest::pipelineExecutionDescription))
            .setter(setter(Builder::pipelineExecutionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDescription")
                    .build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(StartPipelineExecutionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ParallelismConfiguration> PARALLELISM_CONFIGURATION_FIELD = SdkField
            .<ParallelismConfiguration> builder(MarshallingType.SDK_POJO).memberName("ParallelismConfiguration")
            .getter(getter(StartPipelineExecutionRequest::parallelismConfiguration))
            .setter(setter(Builder::parallelismConfiguration)).constructor(ParallelismConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            PIPELINE_EXECUTION_DISPLAY_NAME_FIELD, PIPELINE_PARAMETERS_FIELD, PIPELINE_EXECUTION_DESCRIPTION_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, PARALLELISM_CONFIGURATION_FIELD));

    private final String pipelineName;

    private final String pipelineExecutionDisplayName;

    private final List<Parameter> pipelineParameters;

    private final String pipelineExecutionDescription;

    private final String clientRequestToken;

    private final ParallelismConfiguration parallelismConfiguration;

    private StartPipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineExecutionDisplayName = builder.pipelineExecutionDisplayName;
        this.pipelineParameters = builder.pipelineParameters;
        this.pipelineExecutionDescription = builder.pipelineExecutionDescription;
        this.clientRequestToken = builder.clientRequestToken;
        this.parallelismConfiguration = builder.parallelismConfiguration;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The display name of the pipeline execution.
     * </p>
     * 
     * @return The display name of the pipeline execution.
     */
    public final String pipelineExecutionDisplayName() {
        return pipelineExecutionDisplayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the PipelineParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPipelineParameters() {
        return pipelineParameters != null && !(pipelineParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of pipeline parameters. This list can be empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelineParameters} method.
     * </p>
     * 
     * @return Contains a list of pipeline parameters. This list can be empty.
     */
    public final List<Parameter> pipelineParameters() {
        return pipelineParameters;
    }

    /**
     * <p>
     * The description of the pipeline execution.
     * </p>
     * 
     * @return The description of the pipeline execution.
     */
    public final String pipelineExecutionDescription() {
        return pipelineExecutionDescription;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent
     * operation completes no more than once.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
     *         idempotent operation completes no more than once.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this
     * specific run.
     * </p>
     * 
     * @return This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this
     *         specific run.
     */
    public final ParallelismConfiguration parallelismConfiguration() {
        return parallelismConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineParameters() ? pipelineParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPipelineExecutionRequest)) {
            return false;
        }
        StartPipelineExecutionRequest other = (StartPipelineExecutionRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName())
                && Objects.equals(pipelineExecutionDisplayName(), other.pipelineExecutionDisplayName())
                && hasPipelineParameters() == other.hasPipelineParameters()
                && Objects.equals(pipelineParameters(), other.pipelineParameters())
                && Objects.equals(pipelineExecutionDescription(), other.pipelineExecutionDescription())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(parallelismConfiguration(), other.parallelismConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartPipelineExecutionRequest").add("PipelineName", pipelineName())
                .add("PipelineExecutionDisplayName", pipelineExecutionDisplayName())
                .add("PipelineParameters", hasPipelineParameters() ? pipelineParameters() : null)
                .add("PipelineExecutionDescription", pipelineExecutionDescription())
                .add("ClientRequestToken", clientRequestToken()).add("ParallelismConfiguration", parallelismConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "PipelineExecutionDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineExecutionDisplayName()));
        case "PipelineParameters":
            return Optional.ofNullable(clazz.cast(pipelineParameters()));
        case "PipelineExecutionDescription":
            return Optional.ofNullable(clazz.cast(pipelineExecutionDescription()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "ParallelismConfiguration":
            return Optional.ofNullable(clazz.cast(parallelismConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartPipelineExecutionRequest, T> g) {
        return obj -> g.apply((StartPipelineExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartPipelineExecutionRequest> {
        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The display name of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionDisplayName
         *        The display name of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName);

        /**
         * <p>
         * Contains a list of pipeline parameters. This list can be empty.
         * </p>
         * 
         * @param pipelineParameters
         *        Contains a list of pipeline parameters. This list can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineParameters(Collection<Parameter> pipelineParameters);

        /**
         * <p>
         * Contains a list of pipeline parameters. This list can be empty.
         * </p>
         * 
         * @param pipelineParameters
         *        Contains a list of pipeline parameters. This list can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineParameters(Parameter... pipelineParameters);

        /**
         * <p>
         * Contains a list of pipeline parameters. This list can be empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Parameter>.Builder} avoiding the need to
         * create one manually via {@link List<Parameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Parameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #pipelineParameters(List<Parameter>)}.
         * 
         * @param pipelineParameters
         *        a consumer that will call methods on {@link List<Parameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineParameters(List<Parameter>)
         */
        Builder pipelineParameters(Consumer<Parameter.Builder>... pipelineParameters);

        /**
         * <p>
         * The description of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionDescription
         *        The description of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionDescription(String pipelineExecutionDescription);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         * idempotent operation completes no more than once.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         *        idempotent operation completes no more than once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this
         * specific run.
         * </p>
         * 
         * @param parallelismConfiguration
         *        This configuration, if specified, overrides the parallelism configuration of the parent pipeline for
         *        this specific run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration);

        /**
         * <p>
         * This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this
         * specific run.
         * </p>
         * This is a convenience that creates an instance of the {@link ParallelismConfiguration.Builder} avoiding the
         * need to create one manually via {@link ParallelismConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParallelismConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #parallelismConfiguration(ParallelismConfiguration)}.
         * 
         * @param parallelismConfiguration
         *        a consumer that will call methods on {@link ParallelismConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelismConfiguration(ParallelismConfiguration)
         */
        default Builder parallelismConfiguration(Consumer<ParallelismConfiguration.Builder> parallelismConfiguration) {
            return parallelismConfiguration(ParallelismConfiguration.builder().applyMutation(parallelismConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String pipelineExecutionDisplayName;

        private List<Parameter> pipelineParameters = DefaultSdkAutoConstructList.getInstance();

        private String pipelineExecutionDescription;

        private String clientRequestToken;

        private ParallelismConfiguration parallelismConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPipelineExecutionRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            pipelineExecutionDisplayName(model.pipelineExecutionDisplayName);
            pipelineParameters(model.pipelineParameters);
            pipelineExecutionDescription(model.pipelineExecutionDescription);
            clientRequestToken(model.clientRequestToken);
            parallelismConfiguration(model.parallelismConfiguration);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        @Transient
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineExecutionDisplayName() {
            return pipelineExecutionDisplayName;
        }

        public final void setPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
        }

        @Override
        @Transient
        public final Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
            return this;
        }

        public final List<Parameter.Builder> getPipelineParameters() {
            List<Parameter.Builder> result = ParameterListCopier.copyToBuilder(this.pipelineParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineParameters(Collection<Parameter.BuilderImpl> pipelineParameters) {
            this.pipelineParameters = ParameterListCopier.copyFromBuilder(pipelineParameters);
        }

        @Override
        @Transient
        public final Builder pipelineParameters(Collection<Parameter> pipelineParameters) {
            this.pipelineParameters = ParameterListCopier.copy(pipelineParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pipelineParameters(Parameter... pipelineParameters) {
            pipelineParameters(Arrays.asList(pipelineParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pipelineParameters(Consumer<Parameter.Builder>... pipelineParameters) {
            pipelineParameters(Stream.of(pipelineParameters).map(c -> Parameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPipelineExecutionDescription() {
            return pipelineExecutionDescription;
        }

        public final void setPipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
        }

        @Override
        @Transient
        public final Builder pipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final ParallelismConfiguration.Builder getParallelismConfiguration() {
            return parallelismConfiguration != null ? parallelismConfiguration.toBuilder() : null;
        }

        public final void setParallelismConfiguration(ParallelismConfiguration.BuilderImpl parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration != null ? parallelismConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPipelineExecutionRequest build() {
            return new StartPipelineExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
