/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata properties of the tracking entity, trial, or trial component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataProperties.Builder, MetadataProperties> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommitId").getter(getter(MetadataProperties::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitId").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Repository").getter(getter(MetadataProperties::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Repository").build()).build();

    private static final SdkField<String> GENERATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedBy").getter(getter(MetadataProperties::generatedBy)).setter(setter(Builder::generatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedBy").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectId").getter(getter(MetadataProperties::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD,
            REPOSITORY_FIELD, GENERATED_BY_FIELD, PROJECT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String commitId;

    private final String repository;

    private final String generatedBy;

    private final String projectId;

    private MetadataProperties(BuilderImpl builder) {
        this.commitId = builder.commitId;
        this.repository = builder.repository;
        this.generatedBy = builder.generatedBy;
        this.projectId = builder.projectId;
    }

    /**
     * <p>
     * The commit ID.
     * </p>
     * 
     * @return The commit ID.
     */
    public final String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The repository.
     * </p>
     * 
     * @return The repository.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * The entity this entity was generated by.
     * </p>
     * 
     * @return The entity this entity was generated by.
     */
    public final String generatedBy() {
        return generatedBy;
    }

    /**
     * <p>
     * The project ID.
     * </p>
     * 
     * @return The project ID.
     */
    public final String projectId() {
        return projectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(generatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataProperties)) {
            return false;
        }
        MetadataProperties other = (MetadataProperties) obj;
        return Objects.equals(commitId(), other.commitId()) && Objects.equals(repository(), other.repository())
                && Objects.equals(generatedBy(), other.generatedBy()) && Objects.equals(projectId(), other.projectId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataProperties").add("CommitId", commitId()).add("Repository", repository())
                .add("GeneratedBy", generatedBy()).add("ProjectId", projectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "Repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "GeneratedBy":
            return Optional.ofNullable(clazz.cast(generatedBy()));
        case "ProjectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetadataProperties, T> g) {
        return obj -> g.apply((MetadataProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataProperties> {
        /**
         * <p>
         * The commit ID.
         * </p>
         * 
         * @param commitId
         *        The commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The repository.
         * </p>
         * 
         * @param repository
         *        The repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The entity this entity was generated by.
         * </p>
         * 
         * @param generatedBy
         *        The entity this entity was generated by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedBy(String generatedBy);

        /**
         * <p>
         * The project ID.
         * </p>
         * 
         * @param projectId
         *        The project ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);
    }

    static final class BuilderImpl implements Builder {
        private String commitId;

        private String repository;

        private String generatedBy;

        private String projectId;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataProperties model) {
            commitId(model.commitId);
            repository(model.repository);
            generatedBy(model.generatedBy);
            projectId(model.projectId);
        }

        public final String getCommitId() {
            return commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        @Transient
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getRepository() {
            return repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        @Transient
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getGeneratedBy() {
            return generatedBy;
        }

        public final void setGeneratedBy(String generatedBy) {
            this.generatedBy = generatedBy;
        }

        @Override
        @Transient
        public final Builder generatedBy(String generatedBy) {
            this.generatedBy = generatedBy;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        @Transient
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public MetadataProperties build() {
            return new MetadataProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
