/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configurations for one or more training jobs that Amazon SageMaker runs to test the algorithm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlgorithmValidationSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<AlgorithmValidationSpecification.Builder, AlgorithmValidationSpecification> {
    private static final SdkField<String> VALIDATION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationRole").getter(getter(AlgorithmValidationSpecification::validationRole))
            .setter(setter(Builder::validationRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationRole").build()).build();

    private static final SdkField<List<AlgorithmValidationProfile>> VALIDATION_PROFILES_FIELD = SdkField
            .<List<AlgorithmValidationProfile>> builder(MarshallingType.LIST)
            .memberName("ValidationProfiles")
            .getter(getter(AlgorithmValidationSpecification::validationProfiles))
            .setter(setter(Builder::validationProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlgorithmValidationProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlgorithmValidationProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ROLE_FIELD,
            VALIDATION_PROFILES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String validationRole;

    private final List<AlgorithmValidationProfile> validationProfiles;

    private AlgorithmValidationSpecification(BuilderImpl builder) {
        this.validationRole = builder.validationRole;
        this.validationProfiles = builder.validationProfiles;
    }

    /**
     * <p>
     * The IAM roles that Amazon SageMaker uses to run the training jobs.
     * </p>
     * 
     * @return The IAM roles that Amazon SageMaker uses to run the training jobs.
     */
    public final String validationRole() {
        return validationRole;
    }

    /**
     * Returns true if the ValidationProfiles property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasValidationProfiles() {
        return validationProfiles != null && !(validationProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job and batch
     * transform job that Amazon SageMaker runs to validate your algorithm.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidationProfiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job and
     *         batch transform job that Amazon SageMaker runs to validate your algorithm.
     */
    public final List<AlgorithmValidationProfile> validationProfiles() {
        return validationProfiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(validationRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationProfiles() ? validationProfiles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmValidationSpecification)) {
            return false;
        }
        AlgorithmValidationSpecification other = (AlgorithmValidationSpecification) obj;
        return Objects.equals(validationRole(), other.validationRole())
                && hasValidationProfiles() == other.hasValidationProfiles()
                && Objects.equals(validationProfiles(), other.validationProfiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlgorithmValidationSpecification").add("ValidationRole", validationRole())
                .add("ValidationProfiles", hasValidationProfiles() ? validationProfiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValidationRole":
            return Optional.ofNullable(clazz.cast(validationRole()));
        case "ValidationProfiles":
            return Optional.ofNullable(clazz.cast(validationProfiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmValidationSpecification, T> g) {
        return obj -> g.apply((AlgorithmValidationSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlgorithmValidationSpecification> {
        /**
         * <p>
         * The IAM roles that Amazon SageMaker uses to run the training jobs.
         * </p>
         * 
         * @param validationRole
         *        The IAM roles that Amazon SageMaker uses to run the training jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationRole(String validationRole);

        /**
         * <p>
         * An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job and batch
         * transform job that Amazon SageMaker runs to validate your algorithm.
         * </p>
         * 
         * @param validationProfiles
         *        An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job
         *        and batch transform job that Amazon SageMaker runs to validate your algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationProfiles(Collection<AlgorithmValidationProfile> validationProfiles);

        /**
         * <p>
         * An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job and batch
         * transform job that Amazon SageMaker runs to validate your algorithm.
         * </p>
         * 
         * @param validationProfiles
         *        An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job
         *        and batch transform job that Amazon SageMaker runs to validate your algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationProfiles(AlgorithmValidationProfile... validationProfiles);

        /**
         * <p>
         * An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job and batch
         * transform job that Amazon SageMaker runs to validate your algorithm.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AlgorithmValidationProfile>.Builder}
         * avoiding the need to create one manually via {@link List<AlgorithmValidationProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AlgorithmValidationProfile>.Builder#build()} is called
         * immediately and its result is passed to {@link #validationProfiles(List<AlgorithmValidationProfile>)}.
         * 
         * @param validationProfiles
         *        a consumer that will call methods on {@link List<AlgorithmValidationProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationProfiles(List<AlgorithmValidationProfile>)
         */
        Builder validationProfiles(Consumer<AlgorithmValidationProfile.Builder>... validationProfiles);
    }

    static final class BuilderImpl implements Builder {
        private String validationRole;

        private List<AlgorithmValidationProfile> validationProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmValidationSpecification model) {
            validationRole(model.validationRole);
            validationProfiles(model.validationProfiles);
        }

        public final String getValidationRole() {
            return validationRole;
        }

        @Override
        public final Builder validationRole(String validationRole) {
            this.validationRole = validationRole;
            return this;
        }

        public final void setValidationRole(String validationRole) {
            this.validationRole = validationRole;
        }

        public final List<AlgorithmValidationProfile.Builder> getValidationProfiles() {
            List<AlgorithmValidationProfile.Builder> result = AlgorithmValidationProfilesCopier
                    .copyToBuilder(this.validationProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder validationProfiles(Collection<AlgorithmValidationProfile> validationProfiles) {
            this.validationProfiles = AlgorithmValidationProfilesCopier.copy(validationProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationProfiles(AlgorithmValidationProfile... validationProfiles) {
            validationProfiles(Arrays.asList(validationProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationProfiles(Consumer<AlgorithmValidationProfile.Builder>... validationProfiles) {
            validationProfiles(Stream.of(validationProfiles)
                    .map(c -> AlgorithmValidationProfile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidationProfiles(Collection<AlgorithmValidationProfile.BuilderImpl> validationProfiles) {
            this.validationProfiles = AlgorithmValidationProfilesCopier.copyFromBuilder(validationProfiles);
        }

        @Override
        public AlgorithmValidationSpecification build() {
            return new AlgorithmValidationSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
