/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of an AutoML candidate job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CandidateProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CandidateProperties.Builder, CandidateProperties> {
    private static final SdkField<CandidateArtifactLocations> CANDIDATE_ARTIFACT_LOCATIONS_FIELD = SdkField
            .<CandidateArtifactLocations> builder(MarshallingType.SDK_POJO)
            .memberName("CandidateArtifactLocations")
            .getter(getter(CandidateProperties::candidateArtifactLocations))
            .setter(setter(Builder::candidateArtifactLocations))
            .constructor(CandidateArtifactLocations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateArtifactLocations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CANDIDATE_ARTIFACT_LOCATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final CandidateArtifactLocations candidateArtifactLocations;

    private CandidateProperties(BuilderImpl builder) {
        this.candidateArtifactLocations = builder.candidateArtifactLocations;
    }

    /**
     * <p>
     * The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     * </p>
     * 
     * @return The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
     */
    public final CandidateArtifactLocations candidateArtifactLocations() {
        return candidateArtifactLocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(candidateArtifactLocations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CandidateProperties)) {
            return false;
        }
        CandidateProperties other = (CandidateProperties) obj;
        return Objects.equals(candidateArtifactLocations(), other.candidateArtifactLocations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CandidateProperties").add("CandidateArtifactLocations", candidateArtifactLocations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CandidateArtifactLocations":
            return Optional.ofNullable(clazz.cast(candidateArtifactLocations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CandidateProperties, T> g) {
        return obj -> g.apply((CandidateProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CandidateProperties> {
        /**
         * <p>
         * The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
         * </p>
         * 
         * @param candidateArtifactLocations
         *        The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidateArtifactLocations(CandidateArtifactLocations candidateArtifactLocations);

        /**
         * <p>
         * The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
         * </p>
         * This is a convenience that creates an instance of the {@link CandidateArtifactLocations.Builder} avoiding the
         * need to create one manually via {@link CandidateArtifactLocations#builder()}.
         *
         * When the {@link Consumer} completes, {@link CandidateArtifactLocations.Builder#build()} is called immediately
         * and its result is passed to {@link #candidateArtifactLocations(CandidateArtifactLocations)}.
         * 
         * @param candidateArtifactLocations
         *        a consumer that will call methods on {@link CandidateArtifactLocations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #candidateArtifactLocations(CandidateArtifactLocations)
         */
        default Builder candidateArtifactLocations(Consumer<CandidateArtifactLocations.Builder> candidateArtifactLocations) {
            return candidateArtifactLocations(CandidateArtifactLocations.builder().applyMutation(candidateArtifactLocations)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CandidateArtifactLocations candidateArtifactLocations;

        private BuilderImpl() {
        }

        private BuilderImpl(CandidateProperties model) {
            candidateArtifactLocations(model.candidateArtifactLocations);
        }

        public final CandidateArtifactLocations.Builder getCandidateArtifactLocations() {
            return candidateArtifactLocations != null ? candidateArtifactLocations.toBuilder() : null;
        }

        @Override
        public final Builder candidateArtifactLocations(CandidateArtifactLocations candidateArtifactLocations) {
            this.candidateArtifactLocations = candidateArtifactLocations;
            return this;
        }

        public final void setCandidateArtifactLocations(CandidateArtifactLocations.BuilderImpl candidateArtifactLocations) {
            this.candidateArtifactLocations = candidateArtifactLocations != null ? candidateArtifactLocations.build() : null;
        }

        @Override
        public CandidateProperties build() {
            return new CandidateProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
