/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEndpointConfigRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateEndpointConfigRequest.Builder, CreateEndpointConfigRequest> {
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointConfigName").getter(getter(CreateEndpointConfigRequest::endpointConfigName))
            .setter(setter(Builder::endpointConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build())
            .build();

    private static final SdkField<List<ProductionVariant>> PRODUCTION_VARIANTS_FIELD = SdkField
            .<List<ProductionVariant>> builder(MarshallingType.LIST)
            .memberName("ProductionVariants")
            .getter(getter(CreateEndpointConfigRequest::productionVariants))
            .setter(setter(Builder::productionVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductionVariant> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductionVariant::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataCaptureConfig> DATA_CAPTURE_CONFIG_FIELD = SdkField
            .<DataCaptureConfig> builder(MarshallingType.SDK_POJO).memberName("DataCaptureConfig")
            .getter(getter(CreateEndpointConfigRequest::dataCaptureConfig)).setter(setter(Builder::dataCaptureConfig))
            .constructor(DataCaptureConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCaptureConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateEndpointConfigRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateEndpointConfigRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIG_NAME_FIELD,
            PRODUCTION_VARIANTS_FIELD, DATA_CAPTURE_CONFIG_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD));

    private final String endpointConfigName;

    private final List<ProductionVariant> productionVariants;

    private final DataCaptureConfig dataCaptureConfig;

    private final List<Tag> tags;

    private final String kmsKeyId;

    private CreateEndpointConfigRequest(BuilderImpl builder) {
        super(builder);
        this.endpointConfigName = builder.endpointConfigName;
        this.productionVariants = builder.productionVariants;
        this.dataCaptureConfig = builder.dataCaptureConfig;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The name of the endpoint configuration. You specify this name in a <a>CreateEndpoint</a> request.
     * </p>
     * 
     * @return The name of the endpoint configuration. You specify this name in a <a>CreateEndpoint</a> request.
     */
    public final String endpointConfigName() {
        return endpointConfigName;
    }

    /**
     * Returns true if the ProductionVariants property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProductionVariants() {
        return productionVariants != null && !(productionVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductionVariants()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this
     *         endpoint.
     */
    public final List<ProductionVariant> productionVariants() {
        return productionVariants;
    }

    /**
     * Returns the value of the DataCaptureConfig property for this object.
     * 
     * @return The value of the DataCaptureConfig property for this object.
     */
    public final DataCaptureConfig dataCaptureConfig() {
        return dataCaptureConfig;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * for example, by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, for example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to
     * encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     * </p>
     * <p>
     * The KmsKeyId can be any of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias name: <code>alias/ExampleAlias</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code>,
     * <code>UpdateEndpoint</code> requests. For more information, refer to the Amazon Web Services Key Management
     * Service section<a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key
     * Policies in Amazon Web Services KMS </a>
     * </p>
     * <note>
     * <p>
     * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are
     * encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code> when using an
     * instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code>
     * parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code>
     * parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local
     * storage, the call to <code>CreateEndpointConfig</code> fails.
     * </p>
     * <p>
     * For a list of instance types that support local instance storage, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance
     * Store Volumes</a>.
     * </p>
     * <p>
     * For more information about local instance storage encryption, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store
     * Volumes</a>.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker
     *         uses to encrypt data on the storage volume attached to the ML compute instance that hosts the
     *         endpoint.</p>
     *         <p>
     *         The KmsKeyId can be any of the following formats:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias name: <code>alias/ExampleAlias</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The KMS key policy must grant permission to the IAM role that you specify in your
     *         <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more information, refer to the
     *         Amazon Web Services Key Management Service section<a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key Policies in
     *         Amazon Web Services KMS </a>
     *         </p>
     *         <note>
     *         <p>
     *         Certain Nitro-based instances include local storage, dependent on the instance type. Local storage
     *         volumes are encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code>
     *         when using an instance type with local storage. If any of the models that you specify in the
     *         <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a
     *         value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when
     *         using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.
     *         </p>
     *         <p>
     *         For a list of instance types that support local instance storage, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes"
     *         >Instance Store Volumes</a>.
     *         </p>
     *         <p>
     *         For more information about local instance storage encryption, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store
     *         Volumes</a>.
     *         </p>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductionVariants() ? productionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataCaptureConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointConfigRequest)) {
            return false;
        }
        CreateEndpointConfigRequest other = (CreateEndpointConfigRequest) obj;
        return Objects.equals(endpointConfigName(), other.endpointConfigName())
                && hasProductionVariants() == other.hasProductionVariants()
                && Objects.equals(productionVariants(), other.productionVariants())
                && Objects.equals(dataCaptureConfig(), other.dataCaptureConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEndpointConfigRequest").add("EndpointConfigName", endpointConfigName())
                .add("ProductionVariants", hasProductionVariants() ? productionVariants() : null)
                .add("DataCaptureConfig", dataCaptureConfig()).add("Tags", hasTags() ? tags() : null).add("KmsKeyId", kmsKeyId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointConfigName":
            return Optional.ofNullable(clazz.cast(endpointConfigName()));
        case "ProductionVariants":
            return Optional.ofNullable(clazz.cast(productionVariants()));
        case "DataCaptureConfig":
            return Optional.ofNullable(clazz.cast(dataCaptureConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointConfigRequest, T> g) {
        return obj -> g.apply((CreateEndpointConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEndpointConfigRequest> {
        /**
         * <p>
         * The name of the endpoint configuration. You specify this name in a <a>CreateEndpoint</a> request.
         * </p>
         * 
         * @param endpointConfigName
         *        The name of the endpoint configuration. You specify this name in a <a>CreateEndpoint</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigName(String endpointConfigName);

        /**
         * <p>
         * An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
         * </p>
         * 
         * @param productionVariants
         *        An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(Collection<ProductionVariant> productionVariants);

        /**
         * <p>
         * An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
         * </p>
         * 
         * @param productionVariants
         *        An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionVariants(ProductionVariant... productionVariants);

        /**
         * <p>
         * An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductionVariant>.Builder} avoiding the
         * need to create one manually via {@link List<ProductionVariant>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductionVariant>.Builder#build()} is called immediately
         * and its result is passed to {@link #productionVariants(List<ProductionVariant>)}.
         * 
         * @param productionVariants
         *        a consumer that will call methods on {@link List<ProductionVariant>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productionVariants(List<ProductionVariant>)
         */
        Builder productionVariants(Consumer<ProductionVariant.Builder>... productionVariants);

        /**
         * Sets the value of the DataCaptureConfig property for this object.
         *
         * @param dataCaptureConfig
         *        The new value for the DataCaptureConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCaptureConfig(DataCaptureConfig dataCaptureConfig);

        /**
         * Sets the value of the DataCaptureConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link DataCaptureConfig.Builder} avoiding the need to
         * create one manually via {@link DataCaptureConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataCaptureConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dataCaptureConfig(DataCaptureConfig)}.
         * 
         * @param dataCaptureConfig
         *        a consumer that will call methods on {@link DataCaptureConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCaptureConfig(DataCaptureConfig)
         */
        default Builder dataCaptureConfig(Consumer<DataCaptureConfig.Builder> dataCaptureConfig) {
            return dataCaptureConfig(DataCaptureConfig.builder().applyMutation(dataCaptureConfig).build());
        }

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses
         * to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
         * </p>
         * <p>
         * The KmsKeyId can be any of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias name: <code>alias/ExampleAlias</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more information, refer to the Amazon Web Services Key Management
         * Service section<a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key
         * Policies in Amazon Web Services KMS </a>
         * </p>
         * <note>
         * <p>
         * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes
         * are encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code> when using
         * an instance type with local storage. If any of the models that you specify in the
         * <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a
         * value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using
         * any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.
         * </p>
         * <p>
         * For a list of instance types that support local instance storage, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes"
         * >Instance Store Volumes</a>.
         * </p>
         * <p>
         * For more information about local instance storage encryption, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store
         * Volumes</a>.
         * </p>
         * </note>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon
         *        SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts
         *        the endpoint.</p>
         *        <p>
         *        The KmsKeyId can be any of the following formats:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias name: <code>alias/ExampleAlias</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The KMS key policy must grant permission to the IAM role that you specify in your
         *        <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more information, refer to the
         *        Amazon Web Services Key Management Service section<a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key Policies in
         *        Amazon Web Services KMS </a>
         *        </p>
         *        <note>
         *        <p>
         *        Certain Nitro-based instances include local storage, dependent on the instance type. Local storage
         *        volumes are encrypted using a hardware module on the instance. You can't request a
         *        <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you
         *        specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage,
         *        do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for
         *        <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to
         *        <code>CreateEndpointConfig</code> fails.
         *        </p>
         *        <p>
         *        For a list of instance types that support local instance storage, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes"
         *        >Instance Store Volumes</a>.
         *        </p>
         *        <p>
         *        For more information about local instance storage encryption, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store
         *        Volumes</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String endpointConfigName;

        private List<ProductionVariant> productionVariants = DefaultSdkAutoConstructList.getInstance();

        private DataCaptureConfig dataCaptureConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointConfigRequest model) {
            super(model);
            endpointConfigName(model.endpointConfigName);
            productionVariants(model.productionVariants);
            dataCaptureConfig(model.dataCaptureConfig);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getEndpointConfigName() {
            return endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        public final List<ProductionVariant.Builder> getProductionVariants() {
            List<ProductionVariant.Builder> result = ProductionVariantListCopier.copyToBuilder(this.productionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder productionVariants(Collection<ProductionVariant> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(ProductionVariant... productionVariants) {
            productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(Consumer<ProductionVariant.Builder>... productionVariants) {
            productionVariants(Stream.of(productionVariants).map(c -> ProductionVariant.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductionVariants(Collection<ProductionVariant.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantListCopier.copyFromBuilder(productionVariants);
        }

        public final DataCaptureConfig.Builder getDataCaptureConfig() {
            return dataCaptureConfig != null ? dataCaptureConfig.toBuilder() : null;
        }

        @Override
        public final Builder dataCaptureConfig(DataCaptureConfig dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        public final void setDataCaptureConfig(DataCaptureConfig.BuilderImpl dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig != null ? dataCaptureConfig.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointConfigRequest build() {
            return new CreateEndpointConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
