/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHumanTaskUiResponse extends SageMakerResponse implements
        ToCopyableBuilder<CreateHumanTaskUiResponse.Builder, CreateHumanTaskUiResponse> {
    private static final SdkField<String> HUMAN_TASK_UI_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanTaskUiArn").getter(getter(CreateHumanTaskUiResponse::humanTaskUiArn))
            .setter(setter(Builder::humanTaskUiArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_TASK_UI_ARN_FIELD));

    private final String humanTaskUiArn;

    private CreateHumanTaskUiResponse(BuilderImpl builder) {
        super(builder);
        this.humanTaskUiArn = builder.humanTaskUiArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the human review workflow user interface you create.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the human review workflow user interface you create.
     */
    public final String humanTaskUiArn() {
        return humanTaskUiArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHumanTaskUiResponse)) {
            return false;
        }
        CreateHumanTaskUiResponse other = (CreateHumanTaskUiResponse) obj;
        return Objects.equals(humanTaskUiArn(), other.humanTaskUiArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHumanTaskUiResponse").add("HumanTaskUiArn", humanTaskUiArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanTaskUiArn":
            return Optional.ofNullable(clazz.cast(humanTaskUiArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHumanTaskUiResponse, T> g) {
        return obj -> g.apply((CreateHumanTaskUiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateHumanTaskUiResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the human review workflow user interface you create.
         * </p>
         * 
         * @param humanTaskUiArn
         *        The Amazon Resource Name (ARN) of the human review workflow user interface you create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiArn(String humanTaskUiArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String humanTaskUiArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHumanTaskUiResponse model) {
            super(model);
            humanTaskUiArn(model.humanTaskUiArn);
        }

        public final String getHumanTaskUiArn() {
            return humanTaskUiArn;
        }

        @Override
        public final Builder humanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
            return this;
        }

        public final void setHumanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
        }

        @Override
        public CreateHumanTaskUiResponse build() {
            return new CreateHumanTaskUiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
