/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkforceResponse extends SageMakerResponse implements
        ToCopyableBuilder<CreateWorkforceResponse.Builder, CreateWorkforceResponse> {
    private static final SdkField<String> WORKFORCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkforceArn").getter(getter(CreateWorkforceResponse::workforceArn))
            .setter(setter(Builder::workforceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFORCE_ARN_FIELD));

    private final String workforceArn;

    private CreateWorkforceResponse(BuilderImpl builder) {
        super(builder);
        this.workforceArn = builder.workforceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workforce.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workforce.
     */
    public final String workforceArn() {
        return workforceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workforceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkforceResponse)) {
            return false;
        }
        CreateWorkforceResponse other = (CreateWorkforceResponse) obj;
        return Objects.equals(workforceArn(), other.workforceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkforceResponse").add("WorkforceArn", workforceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkforceArn":
            return Optional.ofNullable(clazz.cast(workforceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkforceResponse, T> g) {
        return obj -> g.apply((CreateWorkforceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkforceResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workforce.
         * </p>
         * 
         * @param workforceArn
         *        The Amazon Resource Name (ARN) of the workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforceArn(String workforceArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String workforceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkforceResponse model) {
            super(model);
            workforceArn(model.workforceArn);
        }

        public final String getWorkforceArn() {
            return workforceArn;
        }

        @Override
        public final Builder workforceArn(String workforceArn) {
            this.workforceArn = workforceArn;
            return this;
        }

        public final void setWorkforceArn(String workforceArn) {
            this.workforceArn = workforceArn;
        }

        @Override
        public CreateWorkforceResponse build() {
            return new CreateWorkforceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
