/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model on the edge device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeModel implements SdkPojo, Serializable, ToCopyableBuilder<EdgeModel.Builder, EdgeModel> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(EdgeModel::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(EdgeModel::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<Instant> LATEST_SAMPLE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestSampleTime").getter(getter(EdgeModel::latestSampleTime)).setter(setter(Builder::latestSampleTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSampleTime").build()).build();

    private static final SdkField<Instant> LATEST_INFERENCE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestInference").getter(getter(EdgeModel::latestInference)).setter(setter(Builder::latestInference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestInference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_VERSION_FIELD, LATEST_SAMPLE_TIME_FIELD, LATEST_INFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final String modelVersion;

    private final Instant latestSampleTime;

    private final Instant latestInference;

    private EdgeModel(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.latestSampleTime = builder.latestSampleTime;
        this.latestInference = builder.latestInference;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The model version.
     * </p>
     * 
     * @return The model version.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The timestamp of the last data sample taken.
     * </p>
     * 
     * @return The timestamp of the last data sample taken.
     */
    public final Instant latestSampleTime() {
        return latestSampleTime;
    }

    /**
     * <p>
     * The timestamp of the last inference that was made.
     * </p>
     * 
     * @return The timestamp of the last inference that was made.
     */
    public final Instant latestInference() {
        return latestInference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestSampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestInference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeModel)) {
            return false;
        }
        EdgeModel other = (EdgeModel) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(latestSampleTime(), other.latestSampleTime())
                && Objects.equals(latestInference(), other.latestInference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeModel").add("ModelName", modelName()).add("ModelVersion", modelVersion())
                .add("LatestSampleTime", latestSampleTime()).add("LatestInference", latestInference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "LatestSampleTime":
            return Optional.ofNullable(clazz.cast(latestSampleTime()));
        case "LatestInference":
            return Optional.ofNullable(clazz.cast(latestInference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgeModel, T> g) {
        return obj -> g.apply((EdgeModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeModel> {
        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param modelName
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The model version.
         * </p>
         * 
         * @param modelVersion
         *        The model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The timestamp of the last data sample taken.
         * </p>
         * 
         * @param latestSampleTime
         *        The timestamp of the last data sample taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestSampleTime(Instant latestSampleTime);

        /**
         * <p>
         * The timestamp of the last inference that was made.
         * </p>
         * 
         * @param latestInference
         *        The timestamp of the last inference that was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestInference(Instant latestInference);
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private String modelVersion;

        private Instant latestSampleTime;

        private Instant latestInference;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeModel model) {
            modelName(model.modelName);
            modelVersion(model.modelVersion);
            latestSampleTime(model.latestSampleTime);
            latestInference(model.latestInference);
        }

        public final String getModelName() {
            return modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        public final Instant getLatestSampleTime() {
            return latestSampleTime;
        }

        @Override
        public final Builder latestSampleTime(Instant latestSampleTime) {
            this.latestSampleTime = latestSampleTime;
            return this;
        }

        public final void setLatestSampleTime(Instant latestSampleTime) {
            this.latestSampleTime = latestSampleTime;
        }

        public final Instant getLatestInference() {
            return latestInference;
        }

        @Override
        public final Builder latestInference(Instant latestInference) {
            this.latestInference = latestInference;
            return this;
        }

        public final void setLatestInference(Instant latestInference) {
            this.latestInference = latestInference;
        }

        @Override
        public EdgeModel build() {
            return new EdgeModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
