/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KernelGatewayImageConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<KernelGatewayImageConfig.Builder, KernelGatewayImageConfig> {
    private static final SdkField<List<KernelSpec>> KERNEL_SPECS_FIELD = SdkField
            .<List<KernelSpec>> builder(MarshallingType.LIST)
            .memberName("KernelSpecs")
            .getter(getter(KernelGatewayImageConfig::kernelSpecs))
            .setter(setter(Builder::kernelSpecs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelSpecs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KernelSpec> builder(MarshallingType.SDK_POJO)
                                            .constructor(KernelSpec::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FileSystemConfig> FILE_SYSTEM_CONFIG_FIELD = SdkField
            .<FileSystemConfig> builder(MarshallingType.SDK_POJO).memberName("FileSystemConfig")
            .getter(getter(KernelGatewayImageConfig::fileSystemConfig)).setter(setter(Builder::fileSystemConfig))
            .constructor(FileSystemConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KERNEL_SPECS_FIELD,
            FILE_SYSTEM_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<KernelSpec> kernelSpecs;

    private final FileSystemConfig fileSystemConfig;

    private KernelGatewayImageConfig(BuilderImpl builder) {
        this.kernelSpecs = builder.kernelSpecs;
        this.fileSystemConfig = builder.fileSystemConfig;
    }

    /**
     * Returns true if the KernelSpecs property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasKernelSpecs() {
        return kernelSpecs != null && !(kernelSpecs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specification of the Jupyter kernels in the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKernelSpecs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The specification of the Jupyter kernels in the image.
     */
    public final List<KernelSpec> kernelSpecs() {
        return kernelSpecs;
    }

    /**
     * <p>
     * The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
     * </p>
     * 
     * @return The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
     */
    public final FileSystemConfig fileSystemConfig() {
        return fileSystemConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKernelSpecs() ? kernelSpecs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KernelGatewayImageConfig)) {
            return false;
        }
        KernelGatewayImageConfig other = (KernelGatewayImageConfig) obj;
        return hasKernelSpecs() == other.hasKernelSpecs() && Objects.equals(kernelSpecs(), other.kernelSpecs())
                && Objects.equals(fileSystemConfig(), other.fileSystemConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KernelGatewayImageConfig").add("KernelSpecs", hasKernelSpecs() ? kernelSpecs() : null)
                .add("FileSystemConfig", fileSystemConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KernelSpecs":
            return Optional.ofNullable(clazz.cast(kernelSpecs()));
        case "FileSystemConfig":
            return Optional.ofNullable(clazz.cast(fileSystemConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KernelGatewayImageConfig, T> g) {
        return obj -> g.apply((KernelGatewayImageConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KernelGatewayImageConfig> {
        /**
         * <p>
         * The specification of the Jupyter kernels in the image.
         * </p>
         * 
         * @param kernelSpecs
         *        The specification of the Jupyter kernels in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelSpecs(Collection<KernelSpec> kernelSpecs);

        /**
         * <p>
         * The specification of the Jupyter kernels in the image.
         * </p>
         * 
         * @param kernelSpecs
         *        The specification of the Jupyter kernels in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelSpecs(KernelSpec... kernelSpecs);

        /**
         * <p>
         * The specification of the Jupyter kernels in the image.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KernelSpec>.Builder} avoiding the need to
         * create one manually via {@link List<KernelSpec>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KernelSpec>.Builder#build()} is called immediately and its
         * result is passed to {@link #kernelSpecs(List<KernelSpec>)}.
         * 
         * @param kernelSpecs
         *        a consumer that will call methods on {@link List<KernelSpec>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelSpecs(List<KernelSpec>)
         */
        Builder kernelSpecs(Consumer<KernelSpec.Builder>... kernelSpecs);

        /**
         * <p>
         * The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
         * </p>
         * 
         * @param fileSystemConfig
         *        The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemConfig(FileSystemConfig fileSystemConfig);

        /**
         * <p>
         * The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
         * </p>
         * This is a convenience that creates an instance of the {@link FileSystemConfig.Builder} avoiding the need to
         * create one manually via {@link FileSystemConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FileSystemConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #fileSystemConfig(FileSystemConfig)}.
         * 
         * @param fileSystemConfig
         *        a consumer that will call methods on {@link FileSystemConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemConfig(FileSystemConfig)
         */
        default Builder fileSystemConfig(Consumer<FileSystemConfig.Builder> fileSystemConfig) {
            return fileSystemConfig(FileSystemConfig.builder().applyMutation(fileSystemConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<KernelSpec> kernelSpecs = DefaultSdkAutoConstructList.getInstance();

        private FileSystemConfig fileSystemConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(KernelGatewayImageConfig model) {
            kernelSpecs(model.kernelSpecs);
            fileSystemConfig(model.fileSystemConfig);
        }

        public final List<KernelSpec.Builder> getKernelSpecs() {
            List<KernelSpec.Builder> result = KernelSpecsCopier.copyToBuilder(this.kernelSpecs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder kernelSpecs(Collection<KernelSpec> kernelSpecs) {
            this.kernelSpecs = KernelSpecsCopier.copy(kernelSpecs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kernelSpecs(KernelSpec... kernelSpecs) {
            kernelSpecs(Arrays.asList(kernelSpecs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kernelSpecs(Consumer<KernelSpec.Builder>... kernelSpecs) {
            kernelSpecs(Stream.of(kernelSpecs).map(c -> KernelSpec.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setKernelSpecs(Collection<KernelSpec.BuilderImpl> kernelSpecs) {
            this.kernelSpecs = KernelSpecsCopier.copyFromBuilder(kernelSpecs);
        }

        public final FileSystemConfig.Builder getFileSystemConfig() {
            return fileSystemConfig != null ? fileSystemConfig.toBuilder() : null;
        }

        @Override
        public final Builder fileSystemConfig(FileSystemConfig fileSystemConfig) {
            this.fileSystemConfig = fileSystemConfig;
            return this;
        }

        public final void setFileSystemConfig(FileSystemConfig.BuilderImpl fileSystemConfig) {
            this.fileSystemConfig = fileSystemConfig != null ? fileSystemConfig.build() : null;
        }

        @Override
        public KernelGatewayImageConfig build() {
            return new KernelGatewayImageConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
