/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An execution of a pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineExecution.Builder, PipelineExecution> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(PipelineExecution::pipelineArn)).setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionArn").getter(getter(PipelineExecution::pipelineExecutionArn))
            .setter(setter(Builder::pipelineExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionArn").build())
            .build();

    private static final SdkField<String> PIPELINE_EXECUTION_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionDisplayName")
            .getter(getter(PipelineExecution::pipelineExecutionDisplayName))
            .setter(setter(Builder::pipelineExecutionDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDisplayName")
                    .build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionStatus").getter(getter(PipelineExecution::pipelineExecutionStatusAsString))
            .setter(setter(Builder::pipelineExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionStatus").build())
            .build();

    private static final SdkField<String> PIPELINE_EXECUTION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionDescription")
            .getter(getter(PipelineExecution::pipelineExecutionDescription))
            .setter(setter(Builder::pipelineExecutionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionDescription")
                    .build()).build();

    private static final SdkField<PipelineExperimentConfig> PIPELINE_EXPERIMENT_CONFIG_FIELD = SdkField
            .<PipelineExperimentConfig> builder(MarshallingType.SDK_POJO).memberName("PipelineExperimentConfig")
            .getter(getter(PipelineExecution::pipelineExperimentConfig)).setter(setter(Builder::pipelineExperimentConfig))
            .constructor(PipelineExperimentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExperimentConfig").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(PipelineExecution::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(PipelineExecution::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(PipelineExecution::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(PipelineExecution::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(PipelineExecution::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<List<Parameter>> PIPELINE_PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .memberName("PipelineParameters")
            .getter(getter(PipelineExecution::pipelineParameters))
            .setter(setter(Builder::pipelineParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            PIPELINE_EXECUTION_ARN_FIELD, PIPELINE_EXECUTION_DISPLAY_NAME_FIELD, PIPELINE_EXECUTION_STATUS_FIELD,
            PIPELINE_EXECUTION_DESCRIPTION_FIELD, PIPELINE_EXPERIMENT_CONFIG_FIELD, FAILURE_REASON_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_BY_FIELD, PIPELINE_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineArn;

    private final String pipelineExecutionArn;

    private final String pipelineExecutionDisplayName;

    private final String pipelineExecutionStatus;

    private final String pipelineExecutionDescription;

    private final PipelineExperimentConfig pipelineExperimentConfig;

    private final String failureReason;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final UserContext createdBy;

    private final UserContext lastModifiedBy;

    private final List<Parameter> pipelineParameters;

    private PipelineExecution(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.pipelineExecutionArn = builder.pipelineExecutionArn;
        this.pipelineExecutionDisplayName = builder.pipelineExecutionDisplayName;
        this.pipelineExecutionStatus = builder.pipelineExecutionStatus;
        this.pipelineExecutionDescription = builder.pipelineExecutionDescription;
        this.pipelineExperimentConfig = builder.pipelineExperimentConfig;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.pipelineParameters = builder.pipelineParameters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline that was executed.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline that was executed.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline execution.
     */
    public final String pipelineExecutionArn() {
        return pipelineExecutionArn;
    }

    /**
     * <p>
     * The display name of the pipeline execution.
     * </p>
     * 
     * @return The display name of the pipeline execution.
     */
    public final String pipelineExecutionDisplayName() {
        return pipelineExecutionDisplayName;
    }

    /**
     * <p>
     * The status of the pipeline status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pipelineExecutionStatus} will return {@link PipelineExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pipelineExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the pipeline status.
     * @see PipelineExecutionStatus
     */
    public final PipelineExecutionStatus pipelineExecutionStatus() {
        return PipelineExecutionStatus.fromValue(pipelineExecutionStatus);
    }

    /**
     * <p>
     * The status of the pipeline status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pipelineExecutionStatus} will return {@link PipelineExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pipelineExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the pipeline status.
     * @see PipelineExecutionStatus
     */
    public final String pipelineExecutionStatusAsString() {
        return pipelineExecutionStatus;
    }

    /**
     * <p>
     * The description of the pipeline execution.
     * </p>
     * 
     * @return The description of the pipeline execution.
     */
    public final String pipelineExecutionDescription() {
        return pipelineExecutionDescription;
    }

    /**
     * Returns the value of the PipelineExperimentConfig property for this object.
     * 
     * @return The value of the PipelineExperimentConfig property for this object.
     */
    public final PipelineExperimentConfig pipelineExperimentConfig() {
        return pipelineExperimentConfig;
    }

    /**
     * <p>
     * If the execution failed, a message describing why.
     * </p>
     * 
     * @return If the execution failed, a message describing why.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The creation time of the pipeline execution.
     * </p>
     * 
     * @return The creation time of the pipeline execution.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time that the pipeline execution was last modified.
     * </p>
     * 
     * @return The time that the pipeline execution was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * Returns true if the PipelineParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPipelineParameters() {
        return pipelineParameters != null && !(pipelineParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of pipeline parameters. This list can be empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelineParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains a list of pipeline parameters. This list can be empty.
     */
    public final List<Parameter> pipelineParameters() {
        return pipelineParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExperimentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineParameters() ? pipelineParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecution)) {
            return false;
        }
        PipelineExecution other = (PipelineExecution) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn())
                && Objects.equals(pipelineExecutionArn(), other.pipelineExecutionArn())
                && Objects.equals(pipelineExecutionDisplayName(), other.pipelineExecutionDisplayName())
                && Objects.equals(pipelineExecutionStatusAsString(), other.pipelineExecutionStatusAsString())
                && Objects.equals(pipelineExecutionDescription(), other.pipelineExecutionDescription())
                && Objects.equals(pipelineExperimentConfig(), other.pipelineExperimentConfig())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && hasPipelineParameters() == other.hasPipelineParameters()
                && Objects.equals(pipelineParameters(), other.pipelineParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineExecution").add("PipelineArn", pipelineArn())
                .add("PipelineExecutionArn", pipelineExecutionArn())
                .add("PipelineExecutionDisplayName", pipelineExecutionDisplayName())
                .add("PipelineExecutionStatus", pipelineExecutionStatusAsString())
                .add("PipelineExecutionDescription", pipelineExecutionDescription())
                .add("PipelineExperimentConfig", pipelineExperimentConfig()).add("FailureReason", failureReason())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime()).add("CreatedBy", createdBy())
                .add("LastModifiedBy", lastModifiedBy())
                .add("PipelineParameters", hasPipelineParameters() ? pipelineParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "PipelineExecutionArn":
            return Optional.ofNullable(clazz.cast(pipelineExecutionArn()));
        case "PipelineExecutionDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineExecutionDisplayName()));
        case "PipelineExecutionStatus":
            return Optional.ofNullable(clazz.cast(pipelineExecutionStatusAsString()));
        case "PipelineExecutionDescription":
            return Optional.ofNullable(clazz.cast(pipelineExecutionDescription()));
        case "PipelineExperimentConfig":
            return Optional.ofNullable(clazz.cast(pipelineExperimentConfig()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "PipelineParameters":
            return Optional.ofNullable(clazz.cast(pipelineParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecution, T> g) {
        return obj -> g.apply((PipelineExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineExecution> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline that was executed.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline that was executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionArn
         *        The Amazon Resource Name (ARN) of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionArn(String pipelineExecutionArn);

        /**
         * <p>
         * The display name of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionDisplayName
         *        The display name of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName);

        /**
         * <p>
         * The status of the pipeline status.
         * </p>
         * 
         * @param pipelineExecutionStatus
         *        The status of the pipeline status.
         * @see PipelineExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineExecutionStatus
         */
        Builder pipelineExecutionStatus(String pipelineExecutionStatus);

        /**
         * <p>
         * The status of the pipeline status.
         * </p>
         * 
         * @param pipelineExecutionStatus
         *        The status of the pipeline status.
         * @see PipelineExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineExecutionStatus
         */
        Builder pipelineExecutionStatus(PipelineExecutionStatus pipelineExecutionStatus);

        /**
         * <p>
         * The description of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionDescription
         *        The description of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionDescription(String pipelineExecutionDescription);

        /**
         * Sets the value of the PipelineExperimentConfig property for this object.
         *
         * @param pipelineExperimentConfig
         *        The new value for the PipelineExperimentConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExperimentConfig(PipelineExperimentConfig pipelineExperimentConfig);

        /**
         * Sets the value of the PipelineExperimentConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link PipelineExperimentConfig.Builder} avoiding the
         * need to create one manually via {@link PipelineExperimentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineExperimentConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #pipelineExperimentConfig(PipelineExperimentConfig)}.
         * 
         * @param pipelineExperimentConfig
         *        a consumer that will call methods on {@link PipelineExperimentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineExperimentConfig(PipelineExperimentConfig)
         */
        default Builder pipelineExperimentConfig(Consumer<PipelineExperimentConfig.Builder> pipelineExperimentConfig) {
            return pipelineExperimentConfig(PipelineExperimentConfig.builder().applyMutation(pipelineExperimentConfig).build());
        }

        /**
         * <p>
         * If the execution failed, a message describing why.
         * </p>
         * 
         * @param failureReason
         *        If the execution failed, a message describing why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The creation time of the pipeline execution.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time that the pipeline execution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time that the pipeline execution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * Contains a list of pipeline parameters. This list can be empty.
         * </p>
         * 
         * @param pipelineParameters
         *        Contains a list of pipeline parameters. This list can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineParameters(Collection<Parameter> pipelineParameters);

        /**
         * <p>
         * Contains a list of pipeline parameters. This list can be empty.
         * </p>
         * 
         * @param pipelineParameters
         *        Contains a list of pipeline parameters. This list can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineParameters(Parameter... pipelineParameters);

        /**
         * <p>
         * Contains a list of pipeline parameters. This list can be empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Parameter>.Builder} avoiding the need to
         * create one manually via {@link List<Parameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Parameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #pipelineParameters(List<Parameter>)}.
         * 
         * @param pipelineParameters
         *        a consumer that will call methods on {@link List<Parameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineParameters(List<Parameter>)
         */
        Builder pipelineParameters(Consumer<Parameter.Builder>... pipelineParameters);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineArn;

        private String pipelineExecutionArn;

        private String pipelineExecutionDisplayName;

        private String pipelineExecutionStatus;

        private String pipelineExecutionDescription;

        private PipelineExperimentConfig pipelineExperimentConfig;

        private String failureReason;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private UserContext createdBy;

        private UserContext lastModifiedBy;

        private List<Parameter> pipelineParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecution model) {
            pipelineArn(model.pipelineArn);
            pipelineExecutionArn(model.pipelineExecutionArn);
            pipelineExecutionDisplayName(model.pipelineExecutionDisplayName);
            pipelineExecutionStatus(model.pipelineExecutionStatus);
            pipelineExecutionDescription(model.pipelineExecutionDescription);
            pipelineExperimentConfig(model.pipelineExperimentConfig);
            failureReason(model.failureReason);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            createdBy(model.createdBy);
            lastModifiedBy(model.lastModifiedBy);
            pipelineParameters(model.pipelineParameters);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        public final String getPipelineExecutionArn() {
            return pipelineExecutionArn;
        }

        @Override
        public final Builder pipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
            return this;
        }

        public final void setPipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
        }

        public final String getPipelineExecutionDisplayName() {
            return pipelineExecutionDisplayName;
        }

        @Override
        public final Builder pipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
            return this;
        }

        public final void setPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
            this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
        }

        public final String getPipelineExecutionStatus() {
            return pipelineExecutionStatus;
        }

        @Override
        public final Builder pipelineExecutionStatus(String pipelineExecutionStatus) {
            this.pipelineExecutionStatus = pipelineExecutionStatus;
            return this;
        }

        @Override
        public final Builder pipelineExecutionStatus(PipelineExecutionStatus pipelineExecutionStatus) {
            this.pipelineExecutionStatus(pipelineExecutionStatus == null ? null : pipelineExecutionStatus.toString());
            return this;
        }

        public final void setPipelineExecutionStatus(String pipelineExecutionStatus) {
            this.pipelineExecutionStatus = pipelineExecutionStatus;
        }

        public final String getPipelineExecutionDescription() {
            return pipelineExecutionDescription;
        }

        @Override
        public final Builder pipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
            return this;
        }

        public final void setPipelineExecutionDescription(String pipelineExecutionDescription) {
            this.pipelineExecutionDescription = pipelineExecutionDescription;
        }

        public final PipelineExperimentConfig.Builder getPipelineExperimentConfig() {
            return pipelineExperimentConfig != null ? pipelineExperimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder pipelineExperimentConfig(PipelineExperimentConfig pipelineExperimentConfig) {
            this.pipelineExperimentConfig = pipelineExperimentConfig;
            return this;
        }

        public final void setPipelineExperimentConfig(PipelineExperimentConfig.BuilderImpl pipelineExperimentConfig) {
            this.pipelineExperimentConfig = pipelineExperimentConfig != null ? pipelineExperimentConfig.build() : null;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        public final List<Parameter.Builder> getPipelineParameters() {
            List<Parameter.Builder> result = ParameterListCopier.copyToBuilder(this.pipelineParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder pipelineParameters(Collection<Parameter> pipelineParameters) {
            this.pipelineParameters = ParameterListCopier.copy(pipelineParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineParameters(Parameter... pipelineParameters) {
            pipelineParameters(Arrays.asList(pipelineParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineParameters(Consumer<Parameter.Builder>... pipelineParameters) {
            pipelineParameters(Stream.of(pipelineParameters).map(c -> Parameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineParameters(Collection<Parameter.BuilderImpl> pipelineParameters) {
            this.pipelineParameters = ParameterListCopier.copyFromBuilder(pipelineParameters);
        }

        @Override
        public PipelineExecution build() {
            return new PipelineExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
