/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an input or output artifact of a trial component. You specify <code>TrialComponentArtifact</code> as part
 * of the <code>InputArtifacts</code> and <code>OutputArtifacts</code> parameters in the <a>CreateTrialComponent</a>
 * request.
 * </p>
 * <p>
 * Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types. Examples of
 * output artifacts are metrics, snapshots, logs, and images.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialComponentArtifact implements SdkPojo, Serializable,
        ToCopyableBuilder<TrialComponentArtifact.Builder, TrialComponentArtifact> {
    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaType").getter(getter(TrialComponentArtifact::mediaType)).setter(setter(Builder::mediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaType").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(TrialComponentArtifact::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MEDIA_TYPE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mediaType;

    private final String value;

    private TrialComponentArtifact(BuilderImpl builder) {
        this.mediaType = builder.mediaType;
        this.value = builder.value;
    }

    /**
     * <p>
     * The media type of the artifact, which indicates the type of data in the artifact file. The media type consists of
     * a <i>type</i> and a <i>subtype</i> concatenated with a slash (/) character, for example, text/csv, image/jpeg,
     * and s3/uri. The type specifies the category of the media. The subtype specifies the kind of data.
     * </p>
     * 
     * @return The media type of the artifact, which indicates the type of data in the artifact file. The media type
     *         consists of a <i>type</i> and a <i>subtype</i> concatenated with a slash (/) character, for example,
     *         text/csv, image/jpeg, and s3/uri. The type specifies the category of the media. The subtype specifies the
     *         kind of data.
     */
    public final String mediaType() {
        return mediaType;
    }

    /**
     * <p>
     * The location of the artifact.
     * </p>
     * 
     * @return The location of the artifact.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaType());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentArtifact)) {
            return false;
        }
        TrialComponentArtifact other = (TrialComponentArtifact) obj;
        return Objects.equals(mediaType(), other.mediaType()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrialComponentArtifact").add("MediaType", mediaType()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaType":
            return Optional.ofNullable(clazz.cast(mediaType()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentArtifact, T> g) {
        return obj -> g.apply((TrialComponentArtifact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialComponentArtifact> {
        /**
         * <p>
         * The media type of the artifact, which indicates the type of data in the artifact file. The media type
         * consists of a <i>type</i> and a <i>subtype</i> concatenated with a slash (/) character, for example,
         * text/csv, image/jpeg, and s3/uri. The type specifies the category of the media. The subtype specifies the
         * kind of data.
         * </p>
         * 
         * @param mediaType
         *        The media type of the artifact, which indicates the type of data in the artifact file. The media type
         *        consists of a <i>type</i> and a <i>subtype</i> concatenated with a slash (/) character, for example,
         *        text/csv, image/jpeg, and s3/uri. The type specifies the category of the media. The subtype specifies
         *        the kind of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaType(String mediaType);

        /**
         * <p>
         * The location of the artifact.
         * </p>
         * 
         * @param value
         *        The location of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String mediaType;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentArtifact model) {
            mediaType(model.mediaType);
            value(model.value);
        }

        public final String getMediaType() {
            return mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public TrialComponentArtifact build() {
            return new TrialComponentArtifact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
