/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for user interface template information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UiTemplateInfo implements SdkPojo, Serializable, ToCopyableBuilder<UiTemplateInfo.Builder, UiTemplateInfo> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(UiTemplateInfo::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentSha256").getter(getter(UiTemplateInfo::contentSha256)).setter(setter(Builder::contentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentSha256").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD,
            CONTENT_SHA256_FIELD));

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String contentSha256;

    private UiTemplateInfo(BuilderImpl builder) {
        this.url = builder.url;
        this.contentSha256 = builder.contentSha256;
    }

    /**
     * <p>
     * The URL for the user interface template.
     * </p>
     * 
     * @return The URL for the user interface template.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The SHA-256 digest of the contents of the template.
     * </p>
     * 
     * @return The SHA-256 digest of the contents of the template.
     */
    public final String contentSha256() {
        return contentSha256;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(contentSha256());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UiTemplateInfo)) {
            return false;
        }
        UiTemplateInfo other = (UiTemplateInfo) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(contentSha256(), other.contentSha256());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UiTemplateInfo").add("Url", url()).add("ContentSha256", contentSha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "ContentSha256":
            return Optional.ofNullable(clazz.cast(contentSha256()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UiTemplateInfo, T> g) {
        return obj -> g.apply((UiTemplateInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UiTemplateInfo> {
        /**
         * <p>
         * The URL for the user interface template.
         * </p>
         * 
         * @param url
         *        The URL for the user interface template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The SHA-256 digest of the contents of the template.
         * </p>
         * 
         * @param contentSha256
         *        The SHA-256 digest of the contents of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentSha256(String contentSha256);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String contentSha256;

        private BuilderImpl() {
        }

        private BuilderImpl(UiTemplateInfo model) {
            url(model.url);
            contentSha256(model.contentSha256);
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getContentSha256() {
            return contentSha256;
        }

        @Override
        public final Builder contentSha256(String contentSha256) {
            this.contentSha256 = contentSha256;
            return this;
        }

        public final void setContentSha256(String contentSha256) {
            this.contentSha256 = contentSha256;
        }

        @Override
        public UiTemplateInfo build() {
            return new UiTemplateInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
