/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkteamRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateWorkteamRequest.Builder, UpdateWorkteamRequest> {
    private static final SdkField<String> WORKTEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkteamName").getter(getter(UpdateWorkteamRequest::workteamName)).setter(setter(Builder::workteamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamName").build()).build();

    private static final SdkField<List<MemberDefinition>> MEMBER_DEFINITIONS_FIELD = SdkField
            .<List<MemberDefinition>> builder(MarshallingType.LIST)
            .memberName("MemberDefinitions")
            .getter(getter(UpdateWorkteamRequest::memberDefinitions))
            .setter(setter(Builder::memberDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateWorkteamRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<NotificationConfiguration> builder(MarshallingType.SDK_POJO).memberName("NotificationConfiguration")
            .getter(getter(UpdateWorkteamRequest::notificationConfiguration)).setter(setter(Builder::notificationConfiguration))
            .constructor(NotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_NAME_FIELD,
            MEMBER_DEFINITIONS_FIELD, DESCRIPTION_FIELD, NOTIFICATION_CONFIGURATION_FIELD));

    private final String workteamName;

    private final List<MemberDefinition> memberDefinitions;

    private final String description;

    private final NotificationConfiguration notificationConfiguration;

    private UpdateWorkteamRequest(BuilderImpl builder) {
        super(builder);
        this.workteamName = builder.workteamName;
        this.memberDefinitions = builder.memberDefinitions;
        this.description = builder.description;
        this.notificationConfiguration = builder.notificationConfiguration;
    }

    /**
     * <p>
     * The name of the work team to update.
     * </p>
     * 
     * @return The name of the work team to update.
     */
    public final String workteamName() {
        return workteamName;
    }

    /**
     * Returns true if the MemberDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMemberDefinitions() {
        return memberDefinitions != null && !(memberDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the
     * work team.
     * </p>
     * <p>
     * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces
     * created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC
     * identity provider (IdP) use <code>OidcMemberDefinition</code>. You should not provide input for both of these
     * parameters in a single request.
     * </p>
     * <p>
     * For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user groups</i>
     * within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code> objects that
     * make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code> values. To add a
     * Amazon Cognito user group to an existing worker pool, see <a href="">Adding groups to a User Pool</a>. For more
     * information about user pools, see <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito
     * User Pools</a>.
     * </p>
     * <p>
     * For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private
     * work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>. Be aware that user
     * groups that are already in the work team must also be listed in <code>Groups</code> when you make this request to
     * remain on the work team. If you do not include these user groups, they will no longer be associated with the work
     * team you update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMemberDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make
     *         up the work team. </p>
     *         <p>
     *         Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private
     *         workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created
     *         using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. You should not provide
     *         input for both of these parameters in a single request.
     *         </p>
     *         <p>
     *         For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user
     *         groups</i> within the user pool used to create a workforce. All of the
     *         <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same
     *         <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an existing
     *         worker pool, see <a href="">Adding groups to a User Pool</a>. For more information about user pools, see
     *         <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
     *         Amazon Cognito User Pools</a>.
     *         </p>
     *         <p>
     *         For workforces created using your own OIDC IdP, specify the user groups that you want to include in your
     *         private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>. Be
     *         aware that user groups that are already in the work team must also be listed in <code>Groups</code> when
     *         you make this request to remain on the work team. If you do not include these user groups, they will no
     *         longer be associated with the work team you update.
     */
    public final List<MemberDefinition> memberDefinitions() {
        return memberDefinitions;
    }

    /**
     * <p>
     * An updated description for the work team.
     * </p>
     * 
     * @return An updated description for the work team.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Configures SNS topic notifications for available or expiring work items
     * </p>
     * 
     * @return Configures SNS topic notifications for available or expiring work items
     */
    public final NotificationConfiguration notificationConfiguration() {
        return notificationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workteamName());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberDefinitions() ? memberDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkteamRequest)) {
            return false;
        }
        UpdateWorkteamRequest other = (UpdateWorkteamRequest) obj;
        return Objects.equals(workteamName(), other.workteamName()) && hasMemberDefinitions() == other.hasMemberDefinitions()
                && Objects.equals(memberDefinitions(), other.memberDefinitions())
                && Objects.equals(description(), other.description())
                && Objects.equals(notificationConfiguration(), other.notificationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkteamRequest").add("WorkteamName", workteamName())
                .add("MemberDefinitions", hasMemberDefinitions() ? memberDefinitions() : null).add("Description", description())
                .add("NotificationConfiguration", notificationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkteamName":
            return Optional.ofNullable(clazz.cast(workteamName()));
        case "MemberDefinitions":
            return Optional.ofNullable(clazz.cast(memberDefinitions()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "NotificationConfiguration":
            return Optional.ofNullable(clazz.cast(notificationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkteamRequest, T> g) {
        return obj -> g.apply((UpdateWorkteamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkteamRequest> {
        /**
         * <p>
         * The name of the work team to update.
         * </p>
         * 
         * @param workteamName
         *        The name of the work team to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteamName(String workteamName);

        /**
         * <p>
         * A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up
         * the work team.
         * </p>
         * <p>
         * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private
         * workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created
         * using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. You should not provide
         * input for both of these parameters in a single request.
         * </p>
         * <p>
         * For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user
         * groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code>
         * objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code>
         * values. To add a Amazon Cognito user group to an existing worker pool, see <a href="">Adding groups to a User
         * Pool</a>. For more information about user pools, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon
         * Cognito User Pools</a>.
         * </p>
         * <p>
         * For workforces created using your own OIDC IdP, specify the user groups that you want to include in your
         * private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>. Be
         * aware that user groups that are already in the work team must also be listed in <code>Groups</code> when you
         * make this request to remain on the work team. If you do not include these user groups, they will no longer be
         * associated with the work team you update.
         * </p>
         * 
         * @param memberDefinitions
         *        A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that
         *        make up the work team. </p>
         *        <p>
         *        Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private
         *        workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces
         *        created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. You should
         *        not provide input for both of these parameters in a single request.
         *        </p>
         *        <p>
         *        For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user
         *        groups</i> within the user pool used to create a workforce. All of the
         *        <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same
         *        <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an
         *        existing worker pool, see <a href="">Adding groups to a User Pool</a>. For more information about user
         *        pools, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"
         *        >Amazon Cognito User Pools</a>.
         *        </p>
         *        <p>
         *        For workforces created using your own OIDC IdP, specify the user groups that you want to include in
         *        your private work team in <code>OidcMemberDefinition</code> by listing those groups in
         *        <code>Groups</code>. Be aware that user groups that are already in the work team must also be listed
         *        in <code>Groups</code> when you make this request to remain on the work team. If you do not include
         *        these user groups, they will no longer be associated with the work team you update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDefinitions(Collection<MemberDefinition> memberDefinitions);

        /**
         * <p>
         * A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up
         * the work team.
         * </p>
         * <p>
         * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private
         * workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created
         * using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. You should not provide
         * input for both of these parameters in a single request.
         * </p>
         * <p>
         * For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user
         * groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code>
         * objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code>
         * values. To add a Amazon Cognito user group to an existing worker pool, see <a href="">Adding groups to a User
         * Pool</a>. For more information about user pools, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon
         * Cognito User Pools</a>.
         * </p>
         * <p>
         * For workforces created using your own OIDC IdP, specify the user groups that you want to include in your
         * private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>. Be
         * aware that user groups that are already in the work team must also be listed in <code>Groups</code> when you
         * make this request to remain on the work team. If you do not include these user groups, they will no longer be
         * associated with the work team you update.
         * </p>
         * 
         * @param memberDefinitions
         *        A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that
         *        make up the work team. </p>
         *        <p>
         *        Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private
         *        workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces
         *        created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. You should
         *        not provide input for both of these parameters in a single request.
         *        </p>
         *        <p>
         *        For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user
         *        groups</i> within the user pool used to create a workforce. All of the
         *        <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same
         *        <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an
         *        existing worker pool, see <a href="">Adding groups to a User Pool</a>. For more information about user
         *        pools, see <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"
         *        >Amazon Cognito User Pools</a>.
         *        </p>
         *        <p>
         *        For workforces created using your own OIDC IdP, specify the user groups that you want to include in
         *        your private work team in <code>OidcMemberDefinition</code> by listing those groups in
         *        <code>Groups</code>. Be aware that user groups that are already in the work team must also be listed
         *        in <code>Groups</code> when you make this request to remain on the work team. If you do not include
         *        these user groups, they will no longer be associated with the work team you update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDefinitions(MemberDefinition... memberDefinitions);

        /**
         * <p>
         * A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up
         * the work team.
         * </p>
         * <p>
         * Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private
         * workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created
         * using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. You should not provide
         * input for both of these parameters in a single request.
         * </p>
         * <p>
         * For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user
         * groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code>
         * objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code>
         * values. To add a Amazon Cognito user group to an existing worker pool, see <a href="">Adding groups to a User
         * Pool</a>. For more information about user pools, see <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon
         * Cognito User Pools</a>.
         * </p>
         * <p>
         * For workforces created using your own OIDC IdP, specify the user groups that you want to include in your
         * private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>. Be
         * aware that user groups that are already in the work team must also be listed in <code>Groups</code> when you
         * make this request to remain on the work team. If you do not include these user groups, they will no longer be
         * associated with the work team you update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MemberDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<MemberDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MemberDefinition>.Builder#build()} is called immediately and
         * its result is passed to {@link #memberDefinitions(List<MemberDefinition>)}.
         * 
         * @param memberDefinitions
         *        a consumer that will call methods on {@link List<MemberDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberDefinitions(List<MemberDefinition>)
         */
        Builder memberDefinitions(Consumer<MemberDefinition.Builder>... memberDefinitions);

        /**
         * <p>
         * An updated description for the work team.
         * </p>
         * 
         * @param description
         *        An updated description for the work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Configures SNS topic notifications for available or expiring work items
         * </p>
         * 
         * @param notificationConfiguration
         *        Configures SNS topic notifications for available or expiring work items
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfiguration(NotificationConfiguration notificationConfiguration);

        /**
         * <p>
         * Configures SNS topic notifications for available or expiring work items
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationConfiguration.Builder} avoiding the
         * need to create one manually via {@link NotificationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationConfiguration(NotificationConfiguration)}.
         * 
         * @param notificationConfiguration
         *        a consumer that will call methods on {@link NotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfiguration(NotificationConfiguration)
         */
        default Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return notificationConfiguration(NotificationConfiguration.builder().applyMutation(notificationConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String workteamName;

        private List<MemberDefinition> memberDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private NotificationConfiguration notificationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkteamRequest model) {
            super(model);
            workteamName(model.workteamName);
            memberDefinitions(model.memberDefinitions);
            description(model.description);
            notificationConfiguration(model.notificationConfiguration);
        }

        public final String getWorkteamName() {
            return workteamName;
        }

        @Override
        public final Builder workteamName(String workteamName) {
            this.workteamName = workteamName;
            return this;
        }

        public final void setWorkteamName(String workteamName) {
            this.workteamName = workteamName;
        }

        public final List<MemberDefinition.Builder> getMemberDefinitions() {
            List<MemberDefinition.Builder> result = MemberDefinitionsCopier.copyToBuilder(this.memberDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder memberDefinitions(Collection<MemberDefinition> memberDefinitions) {
            this.memberDefinitions = MemberDefinitionsCopier.copy(memberDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDefinitions(MemberDefinition... memberDefinitions) {
            memberDefinitions(Arrays.asList(memberDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDefinitions(Consumer<MemberDefinition.Builder>... memberDefinitions) {
            memberDefinitions(Stream.of(memberDefinitions).map(c -> MemberDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMemberDefinitions(Collection<MemberDefinition.BuilderImpl> memberDefinitions) {
            this.memberDefinitions = MemberDefinitionsCopier.copyFromBuilder(memberDefinitions);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return notificationConfiguration != null ? notificationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkteamRequest build() {
            return new UpdateWorkteamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
