/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelQualityJobDefinitionsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListModelQualityJobDefinitionsRequest.Builder, ListModelQualityJobDefinitionsRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(ListModelQualityJobDefinitionsRequest::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListModelQualityJobDefinitionsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListModelQualityJobDefinitionsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelQualityJobDefinitionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListModelQualityJobDefinitionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListModelQualityJobDefinitionsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListModelQualityJobDefinitionsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListModelQualityJobDefinitionsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, NAME_CONTAINS_FIELD,
            CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD));

    private final String endpointName;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private final String nameContains;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private ListModelQualityJobDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.nameContains = builder.nameContains;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
    }

    /**
     * <p>
     * A filter that returns only model quality monitoring job definitions that are associated with the specified
     * endpoint.
     * </p>
     * 
     * @return A filter that returns only model quality monitoring job definitions that are associated with the
     *         specified endpoint.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The field to sort results by. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link MonitoringJobDefinitionSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field to sort results by. The default is <code>CreationTime</code>.
     * @see MonitoringJobDefinitionSortKey
     */
    public final MonitoringJobDefinitionSortKey sortBy() {
        return MonitoringJobDefinitionSortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * The field to sort results by. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link MonitoringJobDefinitionSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field to sort results by. The default is <code>CreationTime</code>.
     * @see MonitoringJobDefinitionSortKey
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Descending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Descending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * If the result of the previous <code>ListModelQualityJobDefinitions</code> request was truncated, the response
     * includes a <code>NextToken</code>. To retrieve the next set of model quality monitoring job definitions, use the
     * token in the next request.
     * </p>
     * 
     * @return If the result of the previous <code>ListModelQualityJobDefinitions</code> request was truncated, the
     *         response includes a <code>NextToken</code>. To retrieve the next set of model quality monitoring job
     *         definitions, use the token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a call to <code>ListModelQualityJobDefinitions</code>.
     * </p>
     * 
     * @return The maximum number of results to return in a call to <code>ListModelQualityJobDefinitions</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A string in the transform job name. This filter returns only model quality monitoring job definitions whose name
     * contains the specified string.
     * </p>
     * 
     * @return A string in the transform job name. This filter returns only model quality monitoring job definitions
     *         whose name contains the specified string.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * A filter that returns only model quality monitoring job definitions created before the specified time.
     * </p>
     * 
     * @return A filter that returns only model quality monitoring job definitions created before the specified time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only model quality monitoring job definitions created after the specified time.
     * </p>
     * 
     * @return A filter that returns only model quality monitoring job definitions created after the specified time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelQualityJobDefinitionsRequest)) {
            return false;
        }
        ListModelQualityJobDefinitionsRequest other = (ListModelQualityJobDefinitionsRequest) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelQualityJobDefinitionsRequest").add("EndpointName", endpointName())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("NameContains", nameContains())
                .add("CreationTimeBefore", creationTimeBefore()).add("CreationTimeAfter", creationTimeAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelQualityJobDefinitionsRequest, T> g) {
        return obj -> g.apply((ListModelQualityJobDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListModelQualityJobDefinitionsRequest> {
        /**
         * <p>
         * A filter that returns only model quality monitoring job definitions that are associated with the specified
         * endpoint.
         * </p>
         * 
         * @param endpointName
         *        A filter that returns only model quality monitoring job definitions that are associated with the
         *        specified endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The field to sort results by. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field to sort results by. The default is <code>CreationTime</code>.
         * @see MonitoringJobDefinitionSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringJobDefinitionSortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field to sort results by. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field to sort results by. The default is <code>CreationTime</code>.
         * @see MonitoringJobDefinitionSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringJobDefinitionSortKey
         */
        Builder sortBy(MonitoringJobDefinitionSortKey sortBy);

        /**
         * <p>
         * The sort order for results. The default is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for results. The default is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * If the result of the previous <code>ListModelQualityJobDefinitions</code> request was truncated, the response
         * includes a <code>NextToken</code>. To retrieve the next set of model quality monitoring job definitions, use
         * the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListModelQualityJobDefinitions</code> request was truncated, the
         *        response includes a <code>NextToken</code>. To retrieve the next set of model quality monitoring job
         *        definitions, use the token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a call to <code>ListModelQualityJobDefinitions</code>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a call to <code>ListModelQualityJobDefinitions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A string in the transform job name. This filter returns only model quality monitoring job definitions whose
         * name contains the specified string.
         * </p>
         * 
         * @param nameContains
         *        A string in the transform job name. This filter returns only model quality monitoring job definitions
         *        whose name contains the specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * A filter that returns only model quality monitoring job definitions created before the specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        A filter that returns only model quality monitoring job definitions created before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * A filter that returns only model quality monitoring job definitions created after the specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        A filter that returns only model quality monitoring job definitions created after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String endpointName;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private String nameContains;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelQualityJobDefinitionsRequest model) {
            super(model);
            endpointName(model.endpointName);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            nameContains(model.nameContains);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        @Transient
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        @Transient
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        @Transient
        public final Builder sortBy(MonitoringJobDefinitionSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        @Transient
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        @Transient
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        @Transient
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        @Transient
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        @Transient
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelQualityJobDefinitionsRequest build() {
            return new ListModelQualityJobDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
