/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this parameter to configure your Amazon Cognito workforce. A single Cognito workforce is created using and
 * corresponds to a single <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito
 * user pool</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CognitoConfig implements SdkPojo, Serializable, ToCopyableBuilder<CognitoConfig.Builder, CognitoConfig> {
    private static final SdkField<String> USER_POOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPool").getter(getter(CognitoConfig::userPool)).setter(setter(Builder::userPool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPool").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(CognitoConfig::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_FIELD,
            CLIENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userPool;

    private final String clientId;

    private CognitoConfig(BuilderImpl builder) {
        this.userPool = builder.userPool;
        this.clientId = builder.clientId;
    }

    /**
     * <p>
     * A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> user
     * pool</a> is a user directory in Amazon Cognito. With a user pool, your users can sign in to your web or mobile
     * app through Amazon Cognito. Your users can also sign in through social identity providers like Google, Facebook,
     * Amazon, or Apple, and through SAML identity providers.
     * </p>
     * 
     * @return A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
     *         user pool</a> is a user directory in Amazon Cognito. With a user pool, your users can sign in to your web
     *         or mobile app through Amazon Cognito. Your users can also sign in through social identity providers like
     *         Google, Facebook, Amazon, or Apple, and through SAML identity providers.
     */
    public final String userPool() {
        return userPool;
    }

    /**
     * <p>
     * The client ID for your Amazon Cognito user pool.
     * </p>
     * 
     * @return The client ID for your Amazon Cognito user pool.
     */
    public final String clientId() {
        return clientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPool());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoConfig)) {
            return false;
        }
        CognitoConfig other = (CognitoConfig) obj;
        return Objects.equals(userPool(), other.userPool()) && Objects.equals(clientId(), other.clientId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CognitoConfig").add("UserPool", userPool()).add("ClientId", clientId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPool":
            return Optional.ofNullable(clazz.cast(userPool()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CognitoConfig, T> g) {
        return obj -> g.apply((CognitoConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CognitoConfig> {
        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> user
         * pool</a> is a user directory in Amazon Cognito. With a user pool, your users can sign in to your web or
         * mobile app through Amazon Cognito. Your users can also sign in through social identity providers like Google,
         * Facebook, Amazon, or Apple, and through SAML identity providers.
         * </p>
         * 
         * @param userPool
         *        A <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
         *        user pool</a> is a user directory in Amazon Cognito. With a user pool, your users can sign in to your
         *        web or mobile app through Amazon Cognito. Your users can also sign in through social identity
         *        providers like Google, Facebook, Amazon, or Apple, and through SAML identity providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPool(String userPool);

        /**
         * <p>
         * The client ID for your Amazon Cognito user pool.
         * </p>
         * 
         * @param clientId
         *        The client ID for your Amazon Cognito user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);
    }

    static final class BuilderImpl implements Builder {
        private String userPool;

        private String clientId;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoConfig model) {
            userPool(model.userPool);
            clientId(model.clientId);
        }

        public final String getUserPool() {
            return userPool;
        }

        public final void setUserPool(String userPool) {
            this.userPool = userPool;
        }

        @Override
        @Transient
        public final Builder userPool(String userPool) {
            this.userPool = userPool;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        @Transient
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public CognitoConfig build() {
            return new CognitoConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
