/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeviceFleetRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateDeviceFleetRequest.Builder, CreateDeviceFleetRequest> {
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(CreateDeviceFleetRequest::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateDeviceFleetRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateDeviceFleetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<EdgeOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(CreateDeviceFleetRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(EdgeOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDeviceFleetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_IOT_ROLE_ALIAS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableIotRoleAlias").getter(getter(CreateDeviceFleetRequest::enableIotRoleAlias))
            .setter(setter(Builder::enableIotRoleAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIotRoleAlias").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_NAME_FIELD,
            ROLE_ARN_FIELD, DESCRIPTION_FIELD, OUTPUT_CONFIG_FIELD, TAGS_FIELD, ENABLE_IOT_ROLE_ALIAS_FIELD));

    private final String deviceFleetName;

    private final String roleArn;

    private final String description;

    private final EdgeOutputConfig outputConfig;

    private final List<Tag> tags;

    private final Boolean enableIotRoleAlias;

    private CreateDeviceFleetRequest(BuilderImpl builder) {
        super(builder);
        this.deviceFleetName = builder.deviceFleetName;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.outputConfig = builder.outputConfig;
        this.tags = builder.tags;
        this.enableIotRoleAlias = builder.enableIotRoleAlias;
    }

    /**
     * <p>
     * The name of the fleet that the device belongs to.
     * </p>
     * 
     * @return The name of the fleet that the device belongs to.
     */
    public final String deviceFleetName() {
        return deviceFleetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A description of the fleet.
     * </p>
     * 
     * @return A description of the fleet.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The output configuration for storing sample data collected by the fleet.
     * </p>
     * 
     * @return The output configuration for storing sample data collected by the fleet.
     */
    public final EdgeOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Creates tags for the specified fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Creates tags for the specified fleet.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias
     * generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".
     * </p>
     * <p>
     * For example, if your device fleet is called "demo-fleet", the name of the role alias will be
     * "SageMakerEdge-demo-fleet".
     * </p>
     * 
     * @return Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the
     *         role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".</p>
     *         <p>
     *         For example, if your device fleet is called "demo-fleet", the name of the role alias will be
     *         "SageMakerEdge-demo-fleet".
     */
    public final Boolean enableIotRoleAlias() {
        return enableIotRoleAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableIotRoleAlias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeviceFleetRequest)) {
            return false;
        }
        CreateDeviceFleetRequest other = (CreateDeviceFleetRequest) obj;
        return Objects.equals(deviceFleetName(), other.deviceFleetName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(description(), other.description()) && Objects.equals(outputConfig(), other.outputConfig())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(enableIotRoleAlias(), other.enableIotRoleAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeviceFleetRequest").add("DeviceFleetName", deviceFleetName()).add("RoleArn", roleArn())
                .add("Description", description()).add("OutputConfig", outputConfig()).add("Tags", hasTags() ? tags() : null)
                .add("EnableIotRoleAlias", enableIotRoleAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "EnableIotRoleAlias":
            return Optional.ofNullable(clazz.cast(enableIotRoleAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeviceFleetRequest, T> g) {
        return obj -> g.apply((CreateDeviceFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeviceFleetRequest> {
        /**
         * <p>
         * The name of the fleet that the device belongs to.
         * </p>
         * 
         * @param deviceFleetName
         *        The name of the fleet that the device belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A description of the fleet.
         * </p>
         * 
         * @param description
         *        A description of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The output configuration for storing sample data collected by the fleet.
         * </p>
         * 
         * @param outputConfig
         *        The output configuration for storing sample data collected by the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(EdgeOutputConfig outputConfig);

        /**
         * <p>
         * The output configuration for storing sample data collected by the fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link EdgeOutputConfig.Builder} avoiding the need to
         * create one manually via {@link EdgeOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EdgeOutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(EdgeOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link EdgeOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(EdgeOutputConfig)
         */
        default Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return outputConfig(EdgeOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * Creates tags for the specified fleet.
         * </p>
         * 
         * @param tags
         *        Creates tags for the specified fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Creates tags for the specified fleet.
         * </p>
         * 
         * @param tags
         *        Creates tags for the specified fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Creates tags for the specified fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role
         * alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".
         * </p>
         * <p>
         * For example, if your device fleet is called "demo-fleet", the name of the role alias will be
         * "SageMakerEdge-demo-fleet".
         * </p>
         * 
         * @param enableIotRoleAlias
         *        Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the
         *        role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".</p>
         *        <p>
         *        For example, if your device fleet is called "demo-fleet", the name of the role alias will be
         *        "SageMakerEdge-demo-fleet".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableIotRoleAlias(Boolean enableIotRoleAlias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String deviceFleetName;

        private String roleArn;

        private String description;

        private EdgeOutputConfig outputConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableIotRoleAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeviceFleetRequest model) {
            super(model);
            deviceFleetName(model.deviceFleetName);
            roleArn(model.roleArn);
            description(model.description);
            outputConfig(model.outputConfig);
            tags(model.tags);
            enableIotRoleAlias(model.enableIotRoleAlias);
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        @Transient
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableIotRoleAlias() {
            return enableIotRoleAlias;
        }

        public final void setEnableIotRoleAlias(Boolean enableIotRoleAlias) {
            this.enableIotRoleAlias = enableIotRoleAlias;
        }

        @Override
        @Transient
        public final Builder enableIotRoleAlias(Boolean enableIotRoleAlias) {
            this.enableIotRoleAlias = enableIotRoleAlias;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeviceFleetRequest build() {
            return new CreateDeviceFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
