/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineSummary implements SdkPojo, Serializable, ToCopyableBuilder<PipelineSummary.Builder, PipelineSummary> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(PipelineSummary::pipelineArn)).setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineName").getter(getter(PipelineSummary::pipelineName)).setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()).build();

    private static final SdkField<String> PIPELINE_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDisplayName").getter(getter(PipelineSummary::pipelineDisplayName))
            .setter(setter(Builder::pipelineDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDisplayName").build())
            .build();

    private static final SdkField<String> PIPELINE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDescription").getter(getter(PipelineSummary::pipelineDescription))
            .setter(setter(Builder::pipelineDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDescription").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(PipelineSummary::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(PipelineSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(PipelineSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> LAST_EXECUTION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastExecutionTime").getter(getter(PipelineSummary::lastExecutionTime))
            .setter(setter(Builder::lastExecutionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            PIPELINE_NAME_FIELD, PIPELINE_DISPLAY_NAME_FIELD, PIPELINE_DESCRIPTION_FIELD, ROLE_ARN_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, LAST_EXECUTION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineArn;

    private final String pipelineName;

    private final String pipelineDisplayName;

    private final String pipelineDescription;

    private final String roleArn;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final Instant lastExecutionTime;

    private PipelineSummary(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.pipelineName = builder.pipelineName;
        this.pipelineDisplayName = builder.pipelineDisplayName;
        this.pipelineDescription = builder.pipelineDescription;
        this.roleArn = builder.roleArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastExecutionTime = builder.lastExecutionTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The display name of the pipeline.
     * </p>
     * 
     * @return The display name of the pipeline.
     */
    public final String pipelineDisplayName() {
        return pipelineDisplayName;
    }

    /**
     * <p>
     * The description of the pipeline.
     * </p>
     * 
     * @return The description of the pipeline.
     */
    public final String pipelineDescription() {
        return pipelineDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that the pipeline used to execute.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that the pipeline used to execute.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The creation time of the pipeline.
     * </p>
     * 
     * @return The creation time of the pipeline.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time that the pipeline was last modified.
     * </p>
     * 
     * @return The time that the pipeline was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The last time that a pipeline execution began.
     * </p>
     * 
     * @return The last time that a pipeline execution began.
     */
    public final Instant lastExecutionTime() {
        return lastExecutionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineSummary)) {
            return false;
        }
        PipelineSummary other = (PipelineSummary) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn()) && Objects.equals(pipelineName(), other.pipelineName())
                && Objects.equals(pipelineDisplayName(), other.pipelineDisplayName())
                && Objects.equals(pipelineDescription(), other.pipelineDescription())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastExecutionTime(), other.lastExecutionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineSummary").add("PipelineArn", pipelineArn()).add("PipelineName", pipelineName())
                .add("PipelineDisplayName", pipelineDisplayName()).add("PipelineDescription", pipelineDescription())
                .add("RoleArn", roleArn()).add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("LastExecutionTime", lastExecutionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "PipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "PipelineDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineDisplayName()));
        case "PipelineDescription":
            return Optional.ofNullable(clazz.cast(pipelineDescription()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastExecutionTime":
            return Optional.ofNullable(clazz.cast(lastExecutionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineSummary, T> g) {
        return obj -> g.apply((PipelineSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The display name of the pipeline.
         * </p>
         * 
         * @param pipelineDisplayName
         *        The display name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDisplayName(String pipelineDisplayName);

        /**
         * <p>
         * The description of the pipeline.
         * </p>
         * 
         * @param pipelineDescription
         *        The description of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDescription(String pipelineDescription);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that the pipeline used to execute.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) that the pipeline used to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The creation time of the pipeline.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time that the pipeline was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time that the pipeline was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The last time that a pipeline execution began.
         * </p>
         * 
         * @param lastExecutionTime
         *        The last time that a pipeline execution began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutionTime(Instant lastExecutionTime);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineArn;

        private String pipelineName;

        private String pipelineDisplayName;

        private String pipelineDescription;

        private String roleArn;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private Instant lastExecutionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineSummary model) {
            pipelineArn(model.pipelineArn);
            pipelineName(model.pipelineName);
            pipelineDisplayName(model.pipelineDisplayName);
            pipelineDescription(model.pipelineDescription);
            roleArn(model.roleArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            lastExecutionTime(model.lastExecutionTime);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        @Transient
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        @Transient
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineDisplayName() {
            return pipelineDisplayName;
        }

        public final void setPipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
        }

        @Override
        @Transient
        public final Builder pipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
            return this;
        }

        public final String getPipelineDescription() {
            return pipelineDescription;
        }

        public final void setPipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
        }

        @Override
        @Transient
        public final Builder pipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getLastExecutionTime() {
            return lastExecutionTime;
        }

        public final void setLastExecutionTime(Instant lastExecutionTime) {
            this.lastExecutionTime = lastExecutionTime;
        }

        @Override
        @Transient
        public final Builder lastExecutionTime(Instant lastExecutionTime) {
            this.lastExecutionTime = lastExecutionTime;
            return this;
        }

        @Override
        public PipelineSummary build() {
            return new PipelineSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
