/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelExplainabilityJobDefinitionResponse extends SageMakerResponse implements
        ToCopyableBuilder<CreateModelExplainabilityJobDefinitionResponse.Builder, CreateModelExplainabilityJobDefinitionResponse> {
    private static final SdkField<String> JOB_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDefinitionArn").getter(getter(CreateModelExplainabilityJobDefinitionResponse::jobDefinitionArn))
            .setter(setter(Builder::jobDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_ARN_FIELD));

    private final String jobDefinitionArn;

    private CreateModelExplainabilityJobDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionArn = builder.jobDefinitionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model explainability job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model explainability job.
     */
    public final String jobDefinitionArn() {
        return jobDefinitionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelExplainabilityJobDefinitionResponse)) {
            return false;
        }
        CreateModelExplainabilityJobDefinitionResponse other = (CreateModelExplainabilityJobDefinitionResponse) obj;
        return Objects.equals(jobDefinitionArn(), other.jobDefinitionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelExplainabilityJobDefinitionResponse").add("JobDefinitionArn", jobDefinitionArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobDefinitionArn":
            return Optional.ofNullable(clazz.cast(jobDefinitionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelExplainabilityJobDefinitionResponse, T> g) {
        return obj -> g.apply((CreateModelExplainabilityJobDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateModelExplainabilityJobDefinitionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model explainability job.
         * </p>
         * 
         * @param jobDefinitionArn
         *        The Amazon Resource Name (ARN) of the model explainability job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionArn(String jobDefinitionArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String jobDefinitionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelExplainabilityJobDefinitionResponse model) {
            super(model);
            jobDefinitionArn(model.jobDefinitionArn);
        }

        public final String getJobDefinitionArn() {
            return jobDefinitionArn;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        @Override
        @Transient
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        @Override
        public CreateModelExplainabilityJobDefinitionResponse build() {
            return new CreateModelExplainabilityJobDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
