/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input configuration of the recommendation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationJobInputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationJobInputConfig.Builder, RecommendationJobInputConfig> {
    private static final SdkField<String> MODEL_PACKAGE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageVersionArn").getter(getter(RecommendationJobInputConfig::modelPackageVersionArn))
            .setter(setter(Builder::modelPackageVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersionArn").build())
            .build();

    private static final SdkField<Integer> JOB_DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("JobDurationInSeconds").getter(getter(RecommendationJobInputConfig::jobDurationInSeconds))
            .setter(setter(Builder::jobDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDurationInSeconds").build())
            .build();

    private static final SdkField<TrafficPattern> TRAFFIC_PATTERN_FIELD = SdkField
            .<TrafficPattern> builder(MarshallingType.SDK_POJO).memberName("TrafficPattern")
            .getter(getter(RecommendationJobInputConfig::trafficPattern)).setter(setter(Builder::trafficPattern))
            .constructor(TrafficPattern::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPattern").build()).build();

    private static final SdkField<RecommendationJobResourceLimit> RESOURCE_LIMIT_FIELD = SdkField
            .<RecommendationJobResourceLimit> builder(MarshallingType.SDK_POJO).memberName("ResourceLimit")
            .getter(getter(RecommendationJobInputConfig::resourceLimit)).setter(setter(Builder::resourceLimit))
            .constructor(RecommendationJobResourceLimit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLimit").build()).build();

    private static final SdkField<List<EndpointInputConfiguration>> ENDPOINT_CONFIGURATIONS_FIELD = SdkField
            .<List<EndpointInputConfiguration>> builder(MarshallingType.LIST)
            .memberName("EndpointConfigurations")
            .getter(getter(RecommendationJobInputConfig::endpointConfigurations))
            .setter(setter(Builder::endpointConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointInputConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointInputConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_PACKAGE_VERSION_ARN_FIELD, JOB_DURATION_IN_SECONDS_FIELD, TRAFFIC_PATTERN_FIELD, RESOURCE_LIMIT_FIELD,
            ENDPOINT_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelPackageVersionArn;

    private final Integer jobDurationInSeconds;

    private final TrafficPattern trafficPattern;

    private final RecommendationJobResourceLimit resourceLimit;

    private final List<EndpointInputConfiguration> endpointConfigurations;

    private RecommendationJobInputConfig(BuilderImpl builder) {
        this.modelPackageVersionArn = builder.modelPackageVersionArn;
        this.jobDurationInSeconds = builder.jobDurationInSeconds;
        this.trafficPattern = builder.trafficPattern;
        this.resourceLimit = builder.resourceLimit;
        this.endpointConfigurations = builder.endpointConfigurations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a versioned model package.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a versioned model package.
     */
    public final String modelPackageVersionArn() {
        return modelPackageVersionArn;
    }

    /**
     * <p>
     * Specifies the maximum duration of the job, in seconds.&gt;
     * </p>
     * 
     * @return Specifies the maximum duration of the job, in seconds.&gt;
     */
    public final Integer jobDurationInSeconds() {
        return jobDurationInSeconds;
    }

    /**
     * <p>
     * Specifies the traffic pattern of the job.
     * </p>
     * 
     * @return Specifies the traffic pattern of the job.
     */
    public final TrafficPattern trafficPattern() {
        return trafficPattern;
    }

    /**
     * <p>
     * Defines the resource limit of the job.
     * </p>
     * 
     * @return Defines the resource limit of the job.
     */
    public final RecommendationJobResourceLimit resourceLimit() {
        return resourceLimit;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEndpointConfigurations() {
        return endpointConfigurations != null && !(endpointConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the endpoint configuration to use for a job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointConfigurations} method.
     * </p>
     * 
     * @return Specifies the endpoint configuration to use for a job.
     */
    public final List<EndpointInputConfiguration> endpointConfigurations() {
        return endpointConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPattern());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLimit());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointConfigurations() ? endpointConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobInputConfig)) {
            return false;
        }
        RecommendationJobInputConfig other = (RecommendationJobInputConfig) obj;
        return Objects.equals(modelPackageVersionArn(), other.modelPackageVersionArn())
                && Objects.equals(jobDurationInSeconds(), other.jobDurationInSeconds())
                && Objects.equals(trafficPattern(), other.trafficPattern())
                && Objects.equals(resourceLimit(), other.resourceLimit())
                && hasEndpointConfigurations() == other.hasEndpointConfigurations()
                && Objects.equals(endpointConfigurations(), other.endpointConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationJobInputConfig").add("ModelPackageVersionArn", modelPackageVersionArn())
                .add("JobDurationInSeconds", jobDurationInSeconds()).add("TrafficPattern", trafficPattern())
                .add("ResourceLimit", resourceLimit())
                .add("EndpointConfigurations", hasEndpointConfigurations() ? endpointConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageVersionArn":
            return Optional.ofNullable(clazz.cast(modelPackageVersionArn()));
        case "JobDurationInSeconds":
            return Optional.ofNullable(clazz.cast(jobDurationInSeconds()));
        case "TrafficPattern":
            return Optional.ofNullable(clazz.cast(trafficPattern()));
        case "ResourceLimit":
            return Optional.ofNullable(clazz.cast(resourceLimit()));
        case "EndpointConfigurations":
            return Optional.ofNullable(clazz.cast(endpointConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobInputConfig, T> g) {
        return obj -> g.apply((RecommendationJobInputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationJobInputConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a versioned model package.
         * </p>
         * 
         * @param modelPackageVersionArn
         *        The Amazon Resource Name (ARN) of a versioned model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageVersionArn(String modelPackageVersionArn);

        /**
         * <p>
         * Specifies the maximum duration of the job, in seconds.&gt;
         * </p>
         * 
         * @param jobDurationInSeconds
         *        Specifies the maximum duration of the job, in seconds.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDurationInSeconds(Integer jobDurationInSeconds);

        /**
         * <p>
         * Specifies the traffic pattern of the job.
         * </p>
         * 
         * @param trafficPattern
         *        Specifies the traffic pattern of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPattern(TrafficPattern trafficPattern);

        /**
         * <p>
         * Specifies the traffic pattern of the job.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficPattern.Builder} avoiding the need to
         * create one manually via {@link TrafficPattern#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficPattern.Builder#build()} is called immediately and its
         * result is passed to {@link #trafficPattern(TrafficPattern)}.
         * 
         * @param trafficPattern
         *        a consumer that will call methods on {@link TrafficPattern.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPattern(TrafficPattern)
         */
        default Builder trafficPattern(Consumer<TrafficPattern.Builder> trafficPattern) {
            return trafficPattern(TrafficPattern.builder().applyMutation(trafficPattern).build());
        }

        /**
         * <p>
         * Defines the resource limit of the job.
         * </p>
         * 
         * @param resourceLimit
         *        Defines the resource limit of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLimit(RecommendationJobResourceLimit resourceLimit);

        /**
         * <p>
         * Defines the resource limit of the job.
         * </p>
         * This is a convenience that creates an instance of the {@link RecommendationJobResourceLimit.Builder} avoiding
         * the need to create one manually via {@link RecommendationJobResourceLimit#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecommendationJobResourceLimit.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceLimit(RecommendationJobResourceLimit)}.
         * 
         * @param resourceLimit
         *        a consumer that will call methods on {@link RecommendationJobResourceLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceLimit(RecommendationJobResourceLimit)
         */
        default Builder resourceLimit(Consumer<RecommendationJobResourceLimit.Builder> resourceLimit) {
            return resourceLimit(RecommendationJobResourceLimit.builder().applyMutation(resourceLimit).build());
        }

        /**
         * <p>
         * Specifies the endpoint configuration to use for a job.
         * </p>
         * 
         * @param endpointConfigurations
         *        Specifies the endpoint configuration to use for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigurations(Collection<EndpointInputConfiguration> endpointConfigurations);

        /**
         * <p>
         * Specifies the endpoint configuration to use for a job.
         * </p>
         * 
         * @param endpointConfigurations
         *        Specifies the endpoint configuration to use for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigurations(EndpointInputConfiguration... endpointConfigurations);

        /**
         * <p>
         * Specifies the endpoint configuration to use for a job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EndpointInputConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<EndpointInputConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndpointInputConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #endpointConfigurations(List<EndpointInputConfiguration>)}.
         * 
         * @param endpointConfigurations
         *        a consumer that will call methods on {@link List<EndpointInputConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfigurations(List<EndpointInputConfiguration>)
         */
        Builder endpointConfigurations(Consumer<EndpointInputConfiguration.Builder>... endpointConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String modelPackageVersionArn;

        private Integer jobDurationInSeconds;

        private TrafficPattern trafficPattern;

        private RecommendationJobResourceLimit resourceLimit;

        private List<EndpointInputConfiguration> endpointConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobInputConfig model) {
            modelPackageVersionArn(model.modelPackageVersionArn);
            jobDurationInSeconds(model.jobDurationInSeconds);
            trafficPattern(model.trafficPattern);
            resourceLimit(model.resourceLimit);
            endpointConfigurations(model.endpointConfigurations);
        }

        public final String getModelPackageVersionArn() {
            return modelPackageVersionArn;
        }

        public final void setModelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
        }

        @Override
        @Transient
        public final Builder modelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
            return this;
        }

        public final Integer getJobDurationInSeconds() {
            return jobDurationInSeconds;
        }

        public final void setJobDurationInSeconds(Integer jobDurationInSeconds) {
            this.jobDurationInSeconds = jobDurationInSeconds;
        }

        @Override
        @Transient
        public final Builder jobDurationInSeconds(Integer jobDurationInSeconds) {
            this.jobDurationInSeconds = jobDurationInSeconds;
            return this;
        }

        public final TrafficPattern.Builder getTrafficPattern() {
            return trafficPattern != null ? trafficPattern.toBuilder() : null;
        }

        public final void setTrafficPattern(TrafficPattern.BuilderImpl trafficPattern) {
            this.trafficPattern = trafficPattern != null ? trafficPattern.build() : null;
        }

        @Override
        @Transient
        public final Builder trafficPattern(TrafficPattern trafficPattern) {
            this.trafficPattern = trafficPattern;
            return this;
        }

        public final RecommendationJobResourceLimit.Builder getResourceLimit() {
            return resourceLimit != null ? resourceLimit.toBuilder() : null;
        }

        public final void setResourceLimit(RecommendationJobResourceLimit.BuilderImpl resourceLimit) {
            this.resourceLimit = resourceLimit != null ? resourceLimit.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceLimit(RecommendationJobResourceLimit resourceLimit) {
            this.resourceLimit = resourceLimit;
            return this;
        }

        public final List<EndpointInputConfiguration.Builder> getEndpointConfigurations() {
            List<EndpointInputConfiguration.Builder> result = EndpointInputConfigurationsCopier
                    .copyToBuilder(this.endpointConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointConfigurations(Collection<EndpointInputConfiguration.BuilderImpl> endpointConfigurations) {
            this.endpointConfigurations = EndpointInputConfigurationsCopier.copyFromBuilder(endpointConfigurations);
        }

        @Override
        @Transient
        public final Builder endpointConfigurations(Collection<EndpointInputConfiguration> endpointConfigurations) {
            this.endpointConfigurations = EndpointInputConfigurationsCopier.copy(endpointConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointConfigurations(EndpointInputConfiguration... endpointConfigurations) {
            endpointConfigurations(Arrays.asList(endpointConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointConfigurations(Consumer<EndpointInputConfiguration.Builder>... endpointConfigurations) {
            endpointConfigurations(Stream.of(endpointConfigurations)
                    .map(c -> EndpointInputConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecommendationJobInputConfig build() {
            return new RecommendationJobInputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
