/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a
 * single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user group
 * to one or more private work teams. If you add a user group to a private work team, all workers in that user group are
 * added to the work team.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OidcMemberDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<OidcMemberDefinition.Builder, OidcMemberDefinition> {
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(OidcMemberDefinition::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> groups;

    private OidcMemberDefinition(BuilderImpl builder) {
        this.groups = builder.groups;
    }

    /**
     * Returns true if the Groups property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of comma seperated strings that identifies user groups in your OIDC IdP. Each user group is made up of a
     * group of private workers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of comma seperated strings that identifies user groups in your OIDC IdP. Each user group is made
     *         up of a group of private workers.
     */
    public final List<String> groups() {
        return groups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcMemberDefinition)) {
            return false;
        }
        OidcMemberDefinition other = (OidcMemberDefinition) obj;
        return hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OidcMemberDefinition").add("Groups", hasGroups() ? groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OidcMemberDefinition, T> g) {
        return obj -> g.apply((OidcMemberDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OidcMemberDefinition> {
        /**
         * <p>
         * A list of comma seperated strings that identifies user groups in your OIDC IdP. Each user group is made up of
         * a group of private workers.
         * </p>
         * 
         * @param groups
         *        A list of comma seperated strings that identifies user groups in your OIDC IdP. Each user group is
         *        made up of a group of private workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * A list of comma seperated strings that identifies user groups in your OIDC IdP. Each user group is made up of
         * a group of private workers.
         * </p>
         * 
         * @param groups
         *        A list of comma seperated strings that identifies user groups in your OIDC IdP. Each user group is
         *        made up of a group of private workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);
    }

    static final class BuilderImpl implements Builder {
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OidcMemberDefinition model) {
            groups(model.groups);
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupsCopier.copy(groups);
        }

        @Override
        @Transient
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupsCopier.copy(groups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        public OidcMemberDefinition build() {
            return new OidcMemberDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
