/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of settings that apply to the <code>SageMaker Domain</code>. These settings are specified through the
 * <code>CreateDomain</code> API call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainSettings implements SdkPojo, Serializable, ToCopyableBuilder<DomainSettings.Builder, DomainSettings> {
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(DomainSettings::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RStudioServerProDomainSettings> R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FIELD = SdkField
            .<RStudioServerProDomainSettings> builder(MarshallingType.SDK_POJO)
            .memberName("RStudioServerProDomainSettings")
            .getter(getter(DomainSettings::rStudioServerProDomainSettings))
            .setter(setter(Builder::rStudioServerProDomainSettings))
            .constructor(RStudioServerProDomainSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RStudioServerProDomainSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_IDS_FIELD,
            R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> securityGroupIds;

    private final RStudioServerProDomainSettings rStudioServerProDomainSettings;

    private DomainSettings(BuilderImpl builder) {
        this.securityGroupIds = builder.securityGroupIds;
        this.rStudioServerProDomainSettings = builder.rStudioServerProDomainSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication
     * between Domain-level apps and user apps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for
     *         communication between Domain-level apps and user apps.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.
     * </p>
     * 
     * @return A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.
     */
    public final RStudioServerProDomainSettings rStudioServerProDomainSettings() {
        return rStudioServerProDomainSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rStudioServerProDomainSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSettings)) {
            return false;
        }
        DomainSettings other = (DomainSettings) obj;
        return hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(rStudioServerProDomainSettings(), other.rStudioServerProDomainSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainSettings").add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("RStudioServerProDomainSettings", rStudioServerProDomainSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "RStudioServerProDomainSettings":
            return Optional.ofNullable(clazz.cast(rStudioServerProDomainSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSettings, T> g) {
        return obj -> g.apply((DomainSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainSettings> {
        /**
         * <p>
         * The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication
         * between Domain-level apps and user apps.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for
         *        communication between Domain-level apps and user apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication
         * between Domain-level apps and user apps.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for
         *        communication between Domain-level apps and user apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.
         * </p>
         * 
         * @param rStudioServerProDomainSettings
         *        A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rStudioServerProDomainSettings(RStudioServerProDomainSettings rStudioServerProDomainSettings);

        /**
         * <p>
         * A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.
         * </p>
         * This is a convenience that creates an instance of the {@link RStudioServerProDomainSettings.Builder} avoiding
         * the need to create one manually via {@link RStudioServerProDomainSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link RStudioServerProDomainSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #rStudioServerProDomainSettings(RStudioServerProDomainSettings)}.
         * 
         * @param rStudioServerProDomainSettings
         *        a consumer that will call methods on {@link RStudioServerProDomainSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rStudioServerProDomainSettings(RStudioServerProDomainSettings)
         */
        default Builder rStudioServerProDomainSettings(
                Consumer<RStudioServerProDomainSettings.Builder> rStudioServerProDomainSettings) {
            return rStudioServerProDomainSettings(RStudioServerProDomainSettings.builder()
                    .applyMutation(rStudioServerProDomainSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private RStudioServerProDomainSettings rStudioServerProDomainSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSettings model) {
            securityGroupIds(model.securityGroupIds);
            rStudioServerProDomainSettings(model.rStudioServerProDomainSettings);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = DomainSecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        @Transient
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = DomainSecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final RStudioServerProDomainSettings.Builder getRStudioServerProDomainSettings() {
            return rStudioServerProDomainSettings != null ? rStudioServerProDomainSettings.toBuilder() : null;
        }

        public final void setRStudioServerProDomainSettings(
                RStudioServerProDomainSettings.BuilderImpl rStudioServerProDomainSettings) {
            this.rStudioServerProDomainSettings = rStudioServerProDomainSettings != null ? rStudioServerProDomainSettings.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder rStudioServerProDomainSettings(RStudioServerProDomainSettings rStudioServerProDomainSettings) {
            this.rStudioServerProDomainSettings = rStudioServerProDomainSettings;
            return this;
        }

        @Override
        public DomainSettings build() {
            return new DomainSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
