/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single resource returned as part of the <a>Search</a> API response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchRecord implements SdkPojo, Serializable, ToCopyableBuilder<SearchRecord.Builder, SearchRecord> {
    private static final SdkField<TrainingJob> TRAINING_JOB_FIELD = SdkField.<TrainingJob> builder(MarshallingType.SDK_POJO)
            .memberName("TrainingJob").getter(getter(SearchRecord::trainingJob)).setter(setter(Builder::trainingJob))
            .constructor(TrainingJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJob").build()).build();

    private static final SdkField<Experiment> EXPERIMENT_FIELD = SdkField.<Experiment> builder(MarshallingType.SDK_POJO)
            .memberName("Experiment").getter(getter(SearchRecord::experiment)).setter(setter(Builder::experiment))
            .constructor(Experiment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Experiment").build()).build();

    private static final SdkField<Trial> TRIAL_FIELD = SdkField.<Trial> builder(MarshallingType.SDK_POJO).memberName("Trial")
            .getter(getter(SearchRecord::trial)).setter(setter(Builder::trial)).constructor(Trial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trial").build()).build();

    private static final SdkField<TrialComponent> TRIAL_COMPONENT_FIELD = SdkField
            .<TrialComponent> builder(MarshallingType.SDK_POJO).memberName("TrialComponent")
            .getter(getter(SearchRecord::trialComponent)).setter(setter(Builder::trialComponent))
            .constructor(TrialComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponent").build()).build();

    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("Endpoint").getter(getter(SearchRecord::endpoint)).setter(setter(Builder::endpoint))
            .constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<ModelPackage> MODEL_PACKAGE_FIELD = SdkField.<ModelPackage> builder(MarshallingType.SDK_POJO)
            .memberName("ModelPackage").getter(getter(SearchRecord::modelPackage)).setter(setter(Builder::modelPackage))
            .constructor(ModelPackage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackage").build()).build();

    private static final SdkField<ModelPackageGroup> MODEL_PACKAGE_GROUP_FIELD = SdkField
            .<ModelPackageGroup> builder(MarshallingType.SDK_POJO).memberName("ModelPackageGroup")
            .getter(getter(SearchRecord::modelPackageGroup)).setter(setter(Builder::modelPackageGroup))
            .constructor(ModelPackageGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroup").build()).build();

    private static final SdkField<Pipeline> PIPELINE_FIELD = SdkField.<Pipeline> builder(MarshallingType.SDK_POJO)
            .memberName("Pipeline").getter(getter(SearchRecord::pipeline)).setter(setter(Builder::pipeline))
            .constructor(Pipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipeline").build()).build();

    private static final SdkField<PipelineExecution> PIPELINE_EXECUTION_FIELD = SdkField
            .<PipelineExecution> builder(MarshallingType.SDK_POJO).memberName("PipelineExecution")
            .getter(getter(SearchRecord::pipelineExecution)).setter(setter(Builder::pipelineExecution))
            .constructor(PipelineExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecution").build()).build();

    private static final SdkField<FeatureGroup> FEATURE_GROUP_FIELD = SdkField.<FeatureGroup> builder(MarshallingType.SDK_POJO)
            .memberName("FeatureGroup").getter(getter(SearchRecord::featureGroup)).setter(setter(Builder::featureGroup))
            .constructor(FeatureGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroup").build()).build();

    private static final SdkField<Project> PROJECT_FIELD = SdkField.<Project> builder(MarshallingType.SDK_POJO)
            .memberName("Project").getter(getter(SearchRecord::project)).setter(setter(Builder::project))
            .constructor(Project::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_FIELD,
            EXPERIMENT_FIELD, TRIAL_FIELD, TRIAL_COMPONENT_FIELD, ENDPOINT_FIELD, MODEL_PACKAGE_FIELD, MODEL_PACKAGE_GROUP_FIELD,
            PIPELINE_FIELD, PIPELINE_EXECUTION_FIELD, FEATURE_GROUP_FIELD, PROJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final TrainingJob trainingJob;

    private final Experiment experiment;

    private final Trial trial;

    private final TrialComponent trialComponent;

    private final Endpoint endpoint;

    private final ModelPackage modelPackage;

    private final ModelPackageGroup modelPackageGroup;

    private final Pipeline pipeline;

    private final PipelineExecution pipelineExecution;

    private final FeatureGroup featureGroup;

    private final Project project;

    private SearchRecord(BuilderImpl builder) {
        this.trainingJob = builder.trainingJob;
        this.experiment = builder.experiment;
        this.trial = builder.trial;
        this.trialComponent = builder.trialComponent;
        this.endpoint = builder.endpoint;
        this.modelPackage = builder.modelPackage;
        this.modelPackageGroup = builder.modelPackageGroup;
        this.pipeline = builder.pipeline;
        this.pipelineExecution = builder.pipelineExecution;
        this.featureGroup = builder.featureGroup;
        this.project = builder.project;
    }

    /**
     * <p>
     * The properties of a training job.
     * </p>
     * 
     * @return The properties of a training job.
     */
    public final TrainingJob trainingJob() {
        return trainingJob;
    }

    /**
     * <p>
     * The properties of an experiment.
     * </p>
     * 
     * @return The properties of an experiment.
     */
    public final Experiment experiment() {
        return experiment;
    }

    /**
     * <p>
     * The properties of a trial.
     * </p>
     * 
     * @return The properties of a trial.
     */
    public final Trial trial() {
        return trial;
    }

    /**
     * <p>
     * The properties of a trial component.
     * </p>
     * 
     * @return The properties of a trial component.
     */
    public final TrialComponent trialComponent() {
        return trialComponent;
    }

    /**
     * Returns the value of the Endpoint property for this object.
     * 
     * @return The value of the Endpoint property for this object.
     */
    public final Endpoint endpoint() {
        return endpoint;
    }

    /**
     * Returns the value of the ModelPackage property for this object.
     * 
     * @return The value of the ModelPackage property for this object.
     */
    public final ModelPackage modelPackage() {
        return modelPackage;
    }

    /**
     * Returns the value of the ModelPackageGroup property for this object.
     * 
     * @return The value of the ModelPackageGroup property for this object.
     */
    public final ModelPackageGroup modelPackageGroup() {
        return modelPackageGroup;
    }

    /**
     * Returns the value of the Pipeline property for this object.
     * 
     * @return The value of the Pipeline property for this object.
     */
    public final Pipeline pipeline() {
        return pipeline;
    }

    /**
     * Returns the value of the PipelineExecution property for this object.
     * 
     * @return The value of the PipelineExecution property for this object.
     */
    public final PipelineExecution pipelineExecution() {
        return pipelineExecution;
    }

    /**
     * Returns the value of the FeatureGroup property for this object.
     * 
     * @return The value of the FeatureGroup property for this object.
     */
    public final FeatureGroup featureGroup() {
        return featureGroup;
    }

    /**
     * <p>
     * The properties of a project.
     * </p>
     * 
     * @return The properties of a project.
     */
    public final Project project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(experiment());
        hashCode = 31 * hashCode + Objects.hashCode(trial());
        hashCode = 31 * hashCode + Objects.hashCode(trialComponent());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackage());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecution());
        hashCode = 31 * hashCode + Objects.hashCode(featureGroup());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRecord)) {
            return false;
        }
        SearchRecord other = (SearchRecord) obj;
        return Objects.equals(trainingJob(), other.trainingJob()) && Objects.equals(experiment(), other.experiment())
                && Objects.equals(trial(), other.trial()) && Objects.equals(trialComponent(), other.trialComponent())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(modelPackage(), other.modelPackage())
                && Objects.equals(modelPackageGroup(), other.modelPackageGroup()) && Objects.equals(pipeline(), other.pipeline())
                && Objects.equals(pipelineExecution(), other.pipelineExecution())
                && Objects.equals(featureGroup(), other.featureGroup()) && Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchRecord").add("TrainingJob", trainingJob()).add("Experiment", experiment())
                .add("Trial", trial()).add("TrialComponent", trialComponent()).add("Endpoint", endpoint())
                .add("ModelPackage", modelPackage()).add("ModelPackageGroup", modelPackageGroup()).add("Pipeline", pipeline())
                .add("PipelineExecution", pipelineExecution()).add("FeatureGroup", featureGroup()).add("Project", project())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingJob":
            return Optional.ofNullable(clazz.cast(trainingJob()));
        case "Experiment":
            return Optional.ofNullable(clazz.cast(experiment()));
        case "Trial":
            return Optional.ofNullable(clazz.cast(trial()));
        case "TrialComponent":
            return Optional.ofNullable(clazz.cast(trialComponent()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "ModelPackage":
            return Optional.ofNullable(clazz.cast(modelPackage()));
        case "ModelPackageGroup":
            return Optional.ofNullable(clazz.cast(modelPackageGroup()));
        case "Pipeline":
            return Optional.ofNullable(clazz.cast(pipeline()));
        case "PipelineExecution":
            return Optional.ofNullable(clazz.cast(pipelineExecution()));
        case "FeatureGroup":
            return Optional.ofNullable(clazz.cast(featureGroup()));
        case "Project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchRecord, T> g) {
        return obj -> g.apply((SearchRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchRecord> {
        /**
         * <p>
         * The properties of a training job.
         * </p>
         * 
         * @param trainingJob
         *        The properties of a training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJob(TrainingJob trainingJob);

        /**
         * <p>
         * The properties of a training job.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingJob.Builder} avoiding the need to create
         * one manually via {@link TrainingJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingJob.Builder#build()} is called immediately and its result
         * is passed to {@link #trainingJob(TrainingJob)}.
         * 
         * @param trainingJob
         *        a consumer that will call methods on {@link TrainingJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJob(TrainingJob)
         */
        default Builder trainingJob(Consumer<TrainingJob.Builder> trainingJob) {
            return trainingJob(TrainingJob.builder().applyMutation(trainingJob).build());
        }

        /**
         * <p>
         * The properties of an experiment.
         * </p>
         * 
         * @param experiment
         *        The properties of an experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experiment(Experiment experiment);

        /**
         * <p>
         * The properties of an experiment.
         * </p>
         * This is a convenience that creates an instance of the {@link Experiment.Builder} avoiding the need to create
         * one manually via {@link Experiment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Experiment.Builder#build()} is called immediately and its result
         * is passed to {@link #experiment(Experiment)}.
         * 
         * @param experiment
         *        a consumer that will call methods on {@link Experiment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experiment(Experiment)
         */
        default Builder experiment(Consumer<Experiment.Builder> experiment) {
            return experiment(Experiment.builder().applyMutation(experiment).build());
        }

        /**
         * <p>
         * The properties of a trial.
         * </p>
         * 
         * @param trial
         *        The properties of a trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trial(Trial trial);

        /**
         * <p>
         * The properties of a trial.
         * </p>
         * This is a convenience that creates an instance of the {@link Trial.Builder} avoiding the need to create one
         * manually via {@link Trial#builder()}.
         *
         * When the {@link Consumer} completes, {@link Trial.Builder#build()} is called immediately and its result is
         * passed to {@link #trial(Trial)}.
         * 
         * @param trial
         *        a consumer that will call methods on {@link Trial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trial(Trial)
         */
        default Builder trial(Consumer<Trial.Builder> trial) {
            return trial(Trial.builder().applyMutation(trial).build());
        }

        /**
         * <p>
         * The properties of a trial component.
         * </p>
         * 
         * @param trialComponent
         *        The properties of a trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponent(TrialComponent trialComponent);

        /**
         * <p>
         * The properties of a trial component.
         * </p>
         * This is a convenience that creates an instance of the {@link TrialComponent.Builder} avoiding the need to
         * create one manually via {@link TrialComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #trialComponent(TrialComponent)}.
         * 
         * @param trialComponent
         *        a consumer that will call methods on {@link TrialComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trialComponent(TrialComponent)
         */
        default Builder trialComponent(Consumer<TrialComponent.Builder> trialComponent) {
            return trialComponent(TrialComponent.builder().applyMutation(trialComponent).build());
        }

        /**
         * Sets the value of the Endpoint property for this object.
         *
         * @param endpoint
         *        The new value for the Endpoint property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(Endpoint endpoint);

        /**
         * Sets the value of the Endpoint property for this object.
         *
         * This is a convenience that creates an instance of the {@link Endpoint.Builder} avoiding the need to create
         * one manually via {@link Endpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #endpoint(Endpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(Endpoint)
         */
        default Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return endpoint(Endpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * Sets the value of the ModelPackage property for this object.
         *
         * @param modelPackage
         *        The new value for the ModelPackage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackage(ModelPackage modelPackage);

        /**
         * Sets the value of the ModelPackage property for this object.
         *
         * This is a convenience that creates an instance of the {@link ModelPackage.Builder} avoiding the need to
         * create one manually via {@link ModelPackage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelPackage.Builder#build()} is called immediately and its
         * result is passed to {@link #modelPackage(ModelPackage)}.
         * 
         * @param modelPackage
         *        a consumer that will call methods on {@link ModelPackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackage(ModelPackage)
         */
        default Builder modelPackage(Consumer<ModelPackage.Builder> modelPackage) {
            return modelPackage(ModelPackage.builder().applyMutation(modelPackage).build());
        }

        /**
         * Sets the value of the ModelPackageGroup property for this object.
         *
         * @param modelPackageGroup
         *        The new value for the ModelPackageGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroup(ModelPackageGroup modelPackageGroup);

        /**
         * Sets the value of the ModelPackageGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link ModelPackageGroup.Builder} avoiding the need to
         * create one manually via {@link ModelPackageGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelPackageGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #modelPackageGroup(ModelPackageGroup)}.
         * 
         * @param modelPackageGroup
         *        a consumer that will call methods on {@link ModelPackageGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackageGroup(ModelPackageGroup)
         */
        default Builder modelPackageGroup(Consumer<ModelPackageGroup.Builder> modelPackageGroup) {
            return modelPackageGroup(ModelPackageGroup.builder().applyMutation(modelPackageGroup).build());
        }

        /**
         * Sets the value of the Pipeline property for this object.
         *
         * @param pipeline
         *        The new value for the Pipeline property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipeline(Pipeline pipeline);

        /**
         * Sets the value of the Pipeline property for this object.
         *
         * This is a convenience that creates an instance of the {@link Pipeline.Builder} avoiding the need to create
         * one manually via {@link Pipeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link Pipeline.Builder#build()} is called immediately and its result is
         * passed to {@link #pipeline(Pipeline)}.
         * 
         * @param pipeline
         *        a consumer that will call methods on {@link Pipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipeline(Pipeline)
         */
        default Builder pipeline(Consumer<Pipeline.Builder> pipeline) {
            return pipeline(Pipeline.builder().applyMutation(pipeline).build());
        }

        /**
         * Sets the value of the PipelineExecution property for this object.
         *
         * @param pipelineExecution
         *        The new value for the PipelineExecution property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecution(PipelineExecution pipelineExecution);

        /**
         * Sets the value of the PipelineExecution property for this object.
         *
         * This is a convenience that creates an instance of the {@link PipelineExecution.Builder} avoiding the need to
         * create one manually via {@link PipelineExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #pipelineExecution(PipelineExecution)}.
         * 
         * @param pipelineExecution
         *        a consumer that will call methods on {@link PipelineExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineExecution(PipelineExecution)
         */
        default Builder pipelineExecution(Consumer<PipelineExecution.Builder> pipelineExecution) {
            return pipelineExecution(PipelineExecution.builder().applyMutation(pipelineExecution).build());
        }

        /**
         * Sets the value of the FeatureGroup property for this object.
         *
         * @param featureGroup
         *        The new value for the FeatureGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroup(FeatureGroup featureGroup);

        /**
         * Sets the value of the FeatureGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link FeatureGroup.Builder} avoiding the need to
         * create one manually via {@link FeatureGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link FeatureGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #featureGroup(FeatureGroup)}.
         * 
         * @param featureGroup
         *        a consumer that will call methods on {@link FeatureGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featureGroup(FeatureGroup)
         */
        default Builder featureGroup(Consumer<FeatureGroup.Builder> featureGroup) {
            return featureGroup(FeatureGroup.builder().applyMutation(featureGroup).build());
        }

        /**
         * <p>
         * The properties of a project.
         * </p>
         * 
         * @param project
         *        The properties of a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(Project project);

        /**
         * <p>
         * The properties of a project.
         * </p>
         * This is a convenience that creates an instance of the {@link Project.Builder} avoiding the need to create one
         * manually via {@link Project#builder()}.
         *
         * When the {@link Consumer} completes, {@link Project.Builder#build()} is called immediately and its result is
         * passed to {@link #project(Project)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link Project.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(Project)
         */
        default Builder project(Consumer<Project.Builder> project) {
            return project(Project.builder().applyMutation(project).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TrainingJob trainingJob;

        private Experiment experiment;

        private Trial trial;

        private TrialComponent trialComponent;

        private Endpoint endpoint;

        private ModelPackage modelPackage;

        private ModelPackageGroup modelPackageGroup;

        private Pipeline pipeline;

        private PipelineExecution pipelineExecution;

        private FeatureGroup featureGroup;

        private Project project;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRecord model) {
            trainingJob(model.trainingJob);
            experiment(model.experiment);
            trial(model.trial);
            trialComponent(model.trialComponent);
            endpoint(model.endpoint);
            modelPackage(model.modelPackage);
            modelPackageGroup(model.modelPackageGroup);
            pipeline(model.pipeline);
            pipelineExecution(model.pipelineExecution);
            featureGroup(model.featureGroup);
            project(model.project);
        }

        public final TrainingJob.Builder getTrainingJob() {
            return trainingJob != null ? trainingJob.toBuilder() : null;
        }

        public final void setTrainingJob(TrainingJob.BuilderImpl trainingJob) {
            this.trainingJob = trainingJob != null ? trainingJob.build() : null;
        }

        @Override
        @Transient
        public final Builder trainingJob(TrainingJob trainingJob) {
            this.trainingJob = trainingJob;
            return this;
        }

        public final Experiment.Builder getExperiment() {
            return experiment != null ? experiment.toBuilder() : null;
        }

        public final void setExperiment(Experiment.BuilderImpl experiment) {
            this.experiment = experiment != null ? experiment.build() : null;
        }

        @Override
        @Transient
        public final Builder experiment(Experiment experiment) {
            this.experiment = experiment;
            return this;
        }

        public final Trial.Builder getTrial() {
            return trial != null ? trial.toBuilder() : null;
        }

        public final void setTrial(Trial.BuilderImpl trial) {
            this.trial = trial != null ? trial.build() : null;
        }

        @Override
        @Transient
        public final Builder trial(Trial trial) {
            this.trial = trial;
            return this;
        }

        public final TrialComponent.Builder getTrialComponent() {
            return trialComponent != null ? trialComponent.toBuilder() : null;
        }

        public final void setTrialComponent(TrialComponent.BuilderImpl trialComponent) {
            this.trialComponent = trialComponent != null ? trialComponent.build() : null;
        }

        @Override
        @Transient
        public final Builder trialComponent(TrialComponent trialComponent) {
            this.trialComponent = trialComponent;
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        @Transient
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final ModelPackage.Builder getModelPackage() {
            return modelPackage != null ? modelPackage.toBuilder() : null;
        }

        public final void setModelPackage(ModelPackage.BuilderImpl modelPackage) {
            this.modelPackage = modelPackage != null ? modelPackage.build() : null;
        }

        @Override
        @Transient
        public final Builder modelPackage(ModelPackage modelPackage) {
            this.modelPackage = modelPackage;
            return this;
        }

        public final ModelPackageGroup.Builder getModelPackageGroup() {
            return modelPackageGroup != null ? modelPackageGroup.toBuilder() : null;
        }

        public final void setModelPackageGroup(ModelPackageGroup.BuilderImpl modelPackageGroup) {
            this.modelPackageGroup = modelPackageGroup != null ? modelPackageGroup.build() : null;
        }

        @Override
        @Transient
        public final Builder modelPackageGroup(ModelPackageGroup modelPackageGroup) {
            this.modelPackageGroup = modelPackageGroup;
            return this;
        }

        public final Pipeline.Builder getPipeline() {
            return pipeline != null ? pipeline.toBuilder() : null;
        }

        public final void setPipeline(Pipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        @Transient
        public final Builder pipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final PipelineExecution.Builder getPipelineExecution() {
            return pipelineExecution != null ? pipelineExecution.toBuilder() : null;
        }

        public final void setPipelineExecution(PipelineExecution.BuilderImpl pipelineExecution) {
            this.pipelineExecution = pipelineExecution != null ? pipelineExecution.build() : null;
        }

        @Override
        @Transient
        public final Builder pipelineExecution(PipelineExecution pipelineExecution) {
            this.pipelineExecution = pipelineExecution;
            return this;
        }

        public final FeatureGroup.Builder getFeatureGroup() {
            return featureGroup != null ? featureGroup.toBuilder() : null;
        }

        public final void setFeatureGroup(FeatureGroup.BuilderImpl featureGroup) {
            this.featureGroup = featureGroup != null ? featureGroup.build() : null;
        }

        @Override
        @Transient
        public final Builder featureGroup(FeatureGroup featureGroup) {
            this.featureGroup = featureGroup;
            return this;
        }

        public final Project.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(Project.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        @Transient
        public final Builder project(Project project) {
            this.project = project;
            return this;
        }

        @Override
        public SearchRecord build() {
            return new SearchRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
