/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssociationsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListAssociationsResponse.Builder, ListAssociationsResponse> {
    private static final SdkField<List<AssociationSummary>> ASSOCIATION_SUMMARIES_FIELD = SdkField
            .<List<AssociationSummary>> builder(MarshallingType.LIST)
            .memberName("AssociationSummaries")
            .getter(getter(ListAssociationsResponse::associationSummaries))
            .setter(setter(Builder::associationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAssociationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AssociationSummary> associationSummaries;

    private final String nextToken;

    private ListAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associationSummaries = builder.associationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AssociationSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAssociationSummaries() {
        return associationSummaries != null && !(associationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of associations and their properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssociationSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of associations and their properties.
     */
    public final List<AssociationSummary> associationSummaries() {
        return associationSummaries;
    }

    /**
     * <p>
     * A token for getting the next set of associations, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of associations, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociationSummaries() ? associationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationsResponse)) {
            return false;
        }
        ListAssociationsResponse other = (ListAssociationsResponse) obj;
        return hasAssociationSummaries() == other.hasAssociationSummaries()
                && Objects.equals(associationSummaries(), other.associationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssociationsResponse")
                .add("AssociationSummaries", hasAssociationSummaries() ? associationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationSummaries":
            return Optional.ofNullable(clazz.cast(associationSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociationsResponse, T> g) {
        return obj -> g.apply((ListAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAssociationsResponse> {
        /**
         * <p>
         * A list of associations and their properties.
         * </p>
         * 
         * @param associationSummaries
         *        A list of associations and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationSummaries(Collection<AssociationSummary> associationSummaries);

        /**
         * <p>
         * A list of associations and their properties.
         * </p>
         * 
         * @param associationSummaries
         *        A list of associations and their properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationSummaries(AssociationSummary... associationSummaries);

        /**
         * <p>
         * A list of associations and their properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssociationSummary>.Builder} avoiding the
         * need to create one manually via {@link List<AssociationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssociationSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #associationSummaries(List<AssociationSummary>)}.
         * 
         * @param associationSummaries
         *        a consumer that will call methods on {@link List<AssociationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationSummaries(List<AssociationSummary>)
         */
        Builder associationSummaries(Consumer<AssociationSummary.Builder>... associationSummaries);

        /**
         * <p>
         * A token for getting the next set of associations, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of associations, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<AssociationSummary> associationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationsResponse model) {
            super(model);
            associationSummaries(model.associationSummaries);
            nextToken(model.nextToken);
        }

        public final List<AssociationSummary.Builder> getAssociationSummaries() {
            List<AssociationSummary.Builder> result = AssociationSummariesCopier.copyToBuilder(this.associationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociationSummaries(Collection<AssociationSummary.BuilderImpl> associationSummaries) {
            this.associationSummaries = AssociationSummariesCopier.copyFromBuilder(associationSummaries);
        }

        @Override
        @Transient
        public final Builder associationSummaries(Collection<AssociationSummary> associationSummaries) {
            this.associationSummaries = AssociationSummariesCopier.copy(associationSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associationSummaries(AssociationSummary... associationSummaries) {
            associationSummaries(Arrays.asList(associationSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder associationSummaries(Consumer<AssociationSummary.Builder>... associationSummaries) {
            associationSummaries(Stream.of(associationSummaries).map(c -> AssociationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssociationsResponse build() {
            return new ListAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
